/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.handler.transaction;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.AbstractSynapseHandler;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.wso2.micro.integrator.initializer.handler.DataHolder;
import org.wso2.micro.integrator.initializer.handler.transaction.store.TransactionStore;

public class TransactionCountHandler
extends AbstractSynapseHandler {
    private static final Log LOG = LogFactory.getLog(TransactionCountHandler.class);
    private static final double MAX_TRANSACTION_COUNT = 1.9327352823E9;
    private static volatile int transactionCount = 0;
    private ExecutorService transactionCountExecutor;
    private final Object lock = new Object();

    public TransactionCountHandler(ExecutorService executor) {
        this.transactionCountExecutor = executor;
    }

    public boolean handleRequestInFlow(org.apache.synapse.MessageContext messageContext) {
        try {
            this.transactionCountExecutor.execute(() -> this.handleTransactionCount(messageContext));
        }
        catch (RejectedExecutionException e) {
            LOG.error((Object)"Transaction could not be counted.", (Throwable)e);
        }
        return true;
    }

    public boolean handleRequestOutFlow(org.apache.synapse.MessageContext messageContext) {
        return true;
    }

    public boolean handleResponseInFlow(org.apache.synapse.MessageContext messageContext) {
        return true;
    }

    public boolean handleResponseOutFlow(org.apache.synapse.MessageContext messageContext) {
        return true;
    }

    public static long getTransactionCount() {
        return transactionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTransactionCount(org.apache.synapse.MessageContext messageContext) {
        MessageContext axis2MessageContext = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        Object transactionProperty = axis2MessageContext.getProperty("INTERNAL_TRANSACTION_COUNTED");
        if (!(transactionProperty instanceof Boolean) || !((Boolean)transactionProperty).booleanValue()) {
            axis2MessageContext.setProperty("INTERNAL_TRANSACTION_COUNTED", (Object)true);
            Object object = this.lock;
            synchronized (object) {
                this.commitAndResetTransactionCountIfReachedToMaxIntegerValue();
                ++transactionCount;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Transaction " + axis2MessageContext.getLogCorrelationID() + " is counted."));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Skipped counting the transaction " + axis2MessageContext.getLogCorrelationID() + " since it has been counted before."));
        }
    }

    private void commitAndResetTransactionCountIfReachedToMaxIntegerValue() {
        if ((double)transactionCount >= 1.9327352823E9) {
            DataHolder dataHolder = DataHolder.getInstance();
            TransactionStore transactionStore = dataHolder.getTransactionStore();
            try {
                transactionStore.addTransaction();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Transaction count reached to max Integer value. Hence, adding the current transaction count: " + transactionCount + " to the database."));
                }
                transactionStore.setNewNodeId();
                transactionCount = 0;
            }
            catch (Throwable e) {
                LOG.fatal((Object)("Could not persist the transaction count for the last period of " + DataHolder.getInstance().getTransactionUpdateInterval() + "min."), e);
            }
        }
    }
}

