/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.handler.transaction.store.connector;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.sql.DataSource;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.micro.integrator.initializer.handler.transaction.TransactionCountHandler;
import org.wso2.micro.integrator.initializer.handler.transaction.exception.TransactionCounterException;
import org.wso2.micro.integrator.initializer.handler.transaction.exception.TransactionCounterInitializationException;
import org.wso2.micro.integrator.initializer.handler.transaction.security.CryptoUtil;

public class RDBMSConnector {
    private static final Log LOG = LogFactory.getLog(RDBMSConnector.class);
    private DataSource dataSource;
    private String nodeId;
    private Cipher cipher;

    public RDBMSConnector(DataSource dataSource, String nodeId, Cipher cipher) throws TransactionCounterInitializationException {
        this.nodeId = nodeId;
        this.cipher = cipher;
        this.dataSource = dataSource;
        try (Connection connection = this.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            String databaseType = metaData.getDatabaseProductName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Successfully connected to : " + databaseType));
            }
        }
        catch (SQLException ex) {
            throw new TransactionCounterInitializationException("Error while initializing RDBMS connection.", ex);
        }
    }

    private Connection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(true);
        return connection;
    }

    public synchronized void addTransaction() throws TransactionCounterException {
        try {
            if (this.checkDataExists()) {
                this.updateStats();
            } else {
                this.addNewRow();
            }
        }
        catch (SQLException e) {
            throw new TransactionCounterException("Error occurred while adding transaction count to the database", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getTransactionCountOfMonth(int year, int monthNumber) throws TransactionCounterException {
        String monthNumberStr = Integer.toString(monthNumber);
        monthNumberStr = monthNumberStr.length() == 1 ? "0" + monthNumberStr : monthNumberStr;
        String dateString = year + "-" + monthNumberStr + "-01";
        try (Connection dbConnection = this.getConnection();
             PreparedStatement prepStmt = dbConnection.prepareStatement("SELECT SUM(TRANSACTION_COUNT) FROM CURRENT_STATS WHERE TIME_STAMP =?");){
            prepStmt.setDate(1, RDBMSConnector.convertToSQLDate(dateString));
            try (ResultSet rs = prepStmt.executeQuery();){
                if (!rs.next()) return -1L;
                Object count = rs.getObject(1);
                if (count != null) {
                    long l = Long.parseLong(count.toString());
                    return l;
                }
                long l = -1L;
                return l;
            }
        }
        catch (SQLException e) {
            throw new TransactionCounterException("Error occurred while getting the transaction count from the database", e);
        }
    }

    public List<String[]> getTransactionCountDataWithColumnNames(String startDate, String endDate) throws TransactionCounterException {
        ArrayList<String[]> data = new ArrayList<String[]>();
        try (Connection dbConnection = this.getConnection();
             PreparedStatement prepStmt = dbConnection.prepareStatement("SELECT * FROM CURRENT_STATS WHERE TIME_STAMP BETWEEN ? AND ?");){
            prepStmt.setDate(1, RDBMSConnector.convertToSQLDate(startDate));
            prepStmt.setDate(2, RDBMSConnector.convertToSQLDate(endDate));
            try (ResultSet rs = prepStmt.executeQuery();){
                ResultSetMetaData rsmd = rs.getMetaData();
                data.add(new String[]{rsmd.getColumnName(1), rsmd.getColumnName(2), rsmd.getColumnName(3), rsmd.getColumnName(4)});
                while (rs.next()) {
                    data.add(new String[]{rs.getString(1), rs.getString(2), String.valueOf(rs.getLong(3)), rs.getString(4)});
                }
            }
        }
        catch (SQLException e) {
            throw new TransactionCounterException("Error occurred while getting the transaction count data from the database for the given time period", e);
        }
        return data;
    }

    private void addNewRow() throws SQLException {
        String encryptedCount;
        long transactionCount = TransactionCountHandler.getTransactionCount();
        try {
            encryptedCount = CryptoUtil.doEncryption(this.cipher, Long.toString(transactionCount));
        }
        catch (TransactionCounterException e) {
            LOG.error((Object)"Error occurred while encrypting the transaction count", (Throwable)e);
            return;
        }
        try (Connection dbConnection = this.getConnection();
             PreparedStatement prepStmt = dbConnection.prepareStatement("INSERT INTO CURRENT_STATS (TIME_STAMP, NODE_ID, TRANSACTION_COUNT,TRANSACTION_COUNT_ENCRYPTED) VALUES (?,?,?,?)");){
            prepStmt.setDate(1, RDBMSConnector.getCurrentMonthAndYear());
            prepStmt.setString(2, this.nodeId);
            prepStmt.setLong(3, transactionCount);
            prepStmt.setString(4, encryptedCount);
            prepStmt.executeUpdate();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean checkDataExists() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateStats() throws SQLException {
        String encryptedCount;
        long transactionCount = TransactionCountHandler.getTransactionCount();
        try {
            encryptedCount = CryptoUtil.doEncryption(this.cipher, Long.toString(transactionCount));
        }
        catch (TransactionCounterException e) {
            LOG.error((Object)"Error occurred while encrypting the transaction count", (Throwable)e);
            return;
        }
        try (Connection dbConnection = this.getConnection();
             PreparedStatement prepStmt = dbConnection.prepareStatement("UPDATE CURRENT_STATS SET TRANSACTION_COUNT=?, TRANSACTION_COUNT_ENCRYPTED=? WHERE NODE_ID=? AND TIME_STAMP=?");){
            prepStmt.setDate(4, RDBMSConnector.getCurrentMonthAndYear());
            prepStmt.setString(3, this.nodeId);
            prepStmt.setLong(1, transactionCount);
            prepStmt.setString(2, encryptedCount);
            prepStmt.executeUpdate();
        }
    }

    public static Date getCurrentMonthAndYear() {
        java.util.Date date = new java.util.Date();
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        String localDateStr = localDate.toString();
        return RDBMSConnector.convertToSQLDate(localDateStr.substring(0, localDateStr.length() - 2) + "01");
    }

    public void setNewNodeId(String newNodeId) {
        this.nodeId = newNodeId;
    }

    private static Date convertToSQLDate(String date) {
        return new Date(ConverterUtil.convertToDate((String)date).getTime());
    }
}

