/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.api.API;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.rest.APISerializer;
import org.wso2.micro.integrator.initializer.persistence.AbstractStore;

public class APIStore
extends AbstractStore<API> {
    public APIStore(String configPath, String configName) {
        super(configPath);
    }

    @Override
    protected String getFileName(API api) {
        return api.getFileName();
    }

    @Override
    protected API getObjectToPersist(String name, SynapseConfiguration config) {
        return config.getAPI(name);
    }

    @Override
    protected OMElement saveToFile(API api, SynapseConfiguration synapseConfig) {
        try {
            return this.serializer.serializeAPI(api, synapseConfig, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the API: " + api.getName() + " to the file system", e);
            return null;
        }
    }

    @Override
    protected OMElement serialize(API api) {
        return APISerializer.serializeAPI((API)api);
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfiguration) {
        File apiDirectory = new File(this.configPath, "api");
        if (!apiDirectory.exists()) {
            return;
        }
        File apiFile = new File(apiDirectory, fileName);
        synapseConfiguration.getArtifactDeploymentStore().addBackedUpArtifact(apiFile.getAbsolutePath());
        apiFile.delete();
    }
}

