/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.persistence;

import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MultiXMLConfigurationSerializer;
import org.wso2.micro.integrator.initializer.persistence.ServiceBusPersistenceException;

public abstract class AbstractStore<T> {
    protected Log log = LogFactory.getLog(this.getClass());
    protected String configPath;
    protected MultiXMLConfigurationSerializer serializer;

    public AbstractStore(String configPath) {
        this.configPath = configPath;
        this.serializer = new MultiXMLConfigurationSerializer(configPath);
    }

    public void save(String name, SynapseConfiguration config) {
        if (name == null) {
            this.log.warn((Object)"Name of the configuration item to be saved is not given");
            return;
        }
        T obj = this.getObjectToPersist(name, config);
        if (obj == null) {
            this.log.warn((Object)("Unable to find the item: " + name + " for persistence"));
            return;
        }
        String fileName = this.getFileName(obj);
        if (fileName == null) {
            try {
                this.serializer.serializeSynapseXML(config);
            }
            catch (Exception e) {
                this.handleException("Error while saving the mediation configuration to the file system", e);
            }
        } else {
            this.saveToFile(obj, config);
        }
    }

    public void delete(String name, String fileName, SynapseConfiguration config) {
        if (fileName == null) {
            try {
                this.serializer.serializeSynapseXML(config);
            }
            catch (Exception e) {
                this.handleException("Error while saving the mediation configuration to the file system", e);
            }
        } else {
            this.deleteFile(fileName, config);
        }
    }

    protected abstract OMElement saveToFile(T var1, SynapseConfiguration var2);

    protected abstract void deleteFile(String var1, SynapseConfiguration var2);

    protected abstract T getObjectToPersist(String var1, SynapseConfiguration var2);

    protected abstract String getFileName(T var1);

    protected abstract OMElement serialize(T var1);

    protected void handleException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
        throw new ServiceBusPersistenceException(msg, e);
    }
}

