/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.eventing.EventSourceSerializer;
import org.apache.synapse.eventing.SynapseEventSource;
import org.wso2.micro.integrator.initializer.persistence.AbstractStore;

public class EventSourceStore
extends AbstractStore<SynapseEventSource> {
    public EventSourceStore(String configPath, String configName) {
        super(configPath);
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfiguration) {
        File eventsDir = new File(this.configPath, "event-sources");
        if (!eventsDir.exists()) {
            return;
        }
        File eventFile = new File(eventsDir, fileName);
        synapseConfiguration.getArtifactDeploymentStore().addBackedUpArtifact(eventFile.getAbsolutePath());
        eventFile.delete();
    }

    @Override
    protected String getFileName(SynapseEventSource eventSrc) {
        return eventSrc.getFileName();
    }

    @Override
    protected SynapseEventSource getObjectToPersist(String name, SynapseConfiguration config) {
        return config.getEventSource(name);
    }

    @Override
    protected OMElement saveToFile(SynapseEventSource eventSrc, SynapseConfiguration synapseConfiguration) {
        try {
            return this.serializer.serializeEventSource(eventSrc, synapseConfiguration, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the event source: " + eventSrc.getName() + " to the file system", e);
            return null;
        }
    }

    @Override
    protected OMElement serialize(SynapseEventSource eventSrc) {
        return EventSourceSerializer.serializeEventSource(null, (SynapseEventSource)eventSrc);
    }
}

