/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.inbound.InboundEndpointSerializer;
import org.apache.synapse.inbound.InboundEndpoint;
import org.wso2.micro.integrator.initializer.persistence.AbstractStore;

public class InboundStore
extends AbstractStore<InboundEndpoint> {
    public InboundStore(String configPath, String configName) {
        super(configPath);
    }

    @Override
    protected String getFileName(InboundEndpoint inboundEndpoint) {
        if (inboundEndpoint.getFileName() == null) {
            inboundEndpoint.setFileName(inboundEndpoint.getName() + ".xml");
        }
        return inboundEndpoint.getFileName();
    }

    @Override
    protected OMElement saveToFile(InboundEndpoint inboundEndpoint, SynapseConfiguration synapseConfiguration) {
        try {
            return this.serializer.serializeInboundEndpoint(inboundEndpoint, synapseConfiguration, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the inbound ep service: " + inboundEndpoint.getName() + " to the file system", e);
            return null;
        }
    }

    @Override
    protected OMElement serialize(InboundEndpoint inboundEndpoint) {
        return InboundEndpointSerializer.serializeInboundEndpoint((InboundEndpoint)inboundEndpoint);
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfiguration) {
        File inboundDir = new File(this.configPath, "inbound-endpoints");
        if (!inboundDir.exists()) {
            return;
        }
        File inboundFile = new File(inboundDir, fileName);
        synapseConfiguration.getArtifactDeploymentStore().addBackedUpArtifact(inboundFile.getAbsolutePath());
        inboundFile.delete();
    }

    @Override
    protected InboundEndpoint getObjectToPersist(String name, SynapseConfiguration config) {
        return config.getInboundEndpoint(name);
    }
}

