/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.Startup;
import org.apache.synapse.api.API;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MultiXMLConfigurationSerializer;
import org.apache.synapse.config.xml.XMLConfigurationSerializer;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.template.TemplateMediator;
import org.apache.synapse.message.processor.MessageProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.wso2.micro.integrator.initializer.persistence.APIStore;
import org.wso2.micro.integrator.initializer.persistence.AbstractStore;
import org.wso2.micro.integrator.initializer.persistence.EndpointStore;
import org.wso2.micro.integrator.initializer.persistence.EndpointTemplateStore;
import org.wso2.micro.integrator.initializer.persistence.EventSourceStore;
import org.wso2.micro.integrator.initializer.persistence.ExecutorStore;
import org.wso2.micro.integrator.initializer.persistence.ImportStore;
import org.wso2.micro.integrator.initializer.persistence.InboundStore;
import org.wso2.micro.integrator.initializer.persistence.LocalEntryStore;
import org.wso2.micro.integrator.initializer.persistence.MessageProcessorStore;
import org.wso2.micro.integrator.initializer.persistence.MessageStoreStore;
import org.wso2.micro.integrator.initializer.persistence.ProxyServiceStore;
import org.wso2.micro.integrator.initializer.persistence.SequenceStore;
import org.wso2.micro.integrator.initializer.persistence.ServiceBusPersistenceException;
import org.wso2.micro.integrator.initializer.persistence.StartupStore;
import org.wso2.micro.integrator.initializer.persistence.SynapseRegistryStore;
import org.wso2.micro.integrator.initializer.persistence.TemplateStore;

public class MediationPersistenceManager {
    private static final Log log = LogFactory.getLog(MediationPersistenceManager.class);
    private boolean initialized = false;
    private String configPath;
    private boolean flatFileMode;
    private SynapseConfiguration synapseConfiguration;
    private String configName;
    private final LinkedList<PersistenceRequest> requestQueue = new LinkedList();
    private MediationPersistenceWorker worker;
    private boolean acceptRequests;
    private long interval = 5000L;
    private Map<Integer, AbstractStore> dataStores;

    public MediationPersistenceManager(String configPath, SynapseConfiguration synapseConfiguration, long interval, String configName) {
        if (this.initialized) {
            log.warn((Object)"Mediation persistence manager is already initialized");
            return;
        }
        if (configPath == null) {
            log.warn((Object)"Synapse configuration location is not provided - Unable to initialize the mediation persistence manager.");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing the mediation persistence manager");
        }
        this.configPath = configPath;
        this.synapseConfiguration = synapseConfiguration;
        this.configName = configName;
        if (interval > 0L) {
            this.interval = interval;
        } else {
            log.warn((Object)("Invalid interval value " + interval + " for the mediation persistence worker, Using defaults"));
        }
        File file = new File(configPath);
        this.flatFileMode = file.exists() && file.isFile();
        this.initDataStores();
        this.worker = new MediationPersistenceWorker();
        this.worker.start();
        this.acceptRequests = true;
        this.initialized = true;
    }

    private void initDataStores() {
        this.dataStores = new HashMap<Integer, AbstractStore>();
        this.dataStores.put(0, new ProxyServiceStore(this.configPath, this.configName));
        this.dataStores.put(1, new SequenceStore(this.configPath, this.configName));
        this.dataStores.put(2, new EndpointStore(this.configPath, this.configName));
        this.dataStores.put(3, new StartupStore(this.configPath, this.configName));
        this.dataStores.put(5, new EventSourceStore(this.configPath, this.configName));
        this.dataStores.put(4, new LocalEntryStore(this.configPath, this.configName));
        this.dataStores.put(6, new SynapseRegistryStore(this.configPath, this.configName));
        this.dataStores.put(8, new ExecutorStore(this.configPath, this.configName));
        this.dataStores.put(9, new TemplateStore(this.configPath, this.configName));
        this.dataStores.put(12, new EndpointTemplateStore(this.configPath, this.configName));
        this.dataStores.put(10, new MessageStoreStore(this.configPath, this.configName));
        this.dataStores.put(11, new MessageProcessorStore(this.configPath, this.configName));
        this.dataStores.put(13, new APIStore(this.configPath, this.configName));
        this.dataStores.put(14, new ImportStore(this.configPath, this.configName));
        this.dataStores.put(15, new InboundStore(this.configPath, this.configName));
    }

    public void destroy() {
        if (!this.initialized) {
            return;
        }
        this.acceptRequests = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Shutting down mediation persistence manager");
        }
        while (!this.requestQueue.isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.worker.proceed = false;
        if (this.worker.isAlive()) {
            this.worker.interrupt();
        }
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveItem(String name, int itemType) {
        if (!this.initialized || !this.acceptRequests) {
            log.warn((Object)"Mediation persistence manager is either not initialized or not in the 'accepting' mode. Ignoring the save request.");
            return;
        }
        if (itemType == 7) {
            this.saveFullConfiguration(false);
            return;
        }
        PersistenceRequest request = new PersistenceRequest(name, itemType, true);
        LinkedList<PersistenceRequest> linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.addToQueue(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteItem(String name, String fileName, int itemType) {
        if (!this.initialized || !this.acceptRequests) {
            log.warn((Object)"Mediation persistence manager is either not initialized or not in the 'accepting' mode. Ignoring the delete request.");
            return;
        }
        if (itemType == 7) {
            return;
        }
        PersistenceRequest request = new PersistenceRequest(name, fileName, itemType, false);
        LinkedList<PersistenceRequest> linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.addToQueue(request);
        }
    }

    private void addToQueue(PersistenceRequest request) {
        int i;
        boolean matchFound = false;
        for (i = 0; i < this.requestQueue.size(); ++i) {
            PersistenceRequest oldRequest = this.requestQueue.get(i);
            if (oldRequest.subjectType == 7) {
                return;
            }
            if (oldRequest.subjectType != request.subjectType || !oldRequest.subjectId.equals(request.subjectId)) continue;
            matchFound = true;
            break;
        }
        if (matchFound) {
            this.requestQueue.remove(i);
            this.requestQueue.add(i, request);
        } else {
            this.requestQueue.offer(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFullConfiguration(boolean registryOnly) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Received request to save full mediation configuration");
        }
        PersistenceRequest request = new PersistenceRequest(null, 7, true);
        request.registryOnly = registryOnly;
        LinkedList<PersistenceRequest> linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.requestQueue.clear();
            this.requestQueue.offer(request);
        }
    }

    private void handleException(String msg, Throwable t) {
        log.error((Object)msg, t);
        throw new ServiceBusPersistenceException(msg, t);
    }

    private void persistElement(SynapseConfiguration config, PersistenceRequest request) {
        if (request.subjectType == 7) {
            this.saveFullConfiguration(config);
        } else {
            AbstractStore dataStore = this.dataStores.get(request.subjectType);
            dataStore.save(request.subjectId, config);
        }
    }

    private void deleteElement(SynapseConfiguration config, PersistenceRequest request) {
        AbstractStore dataStore = this.dataStores.get(request.subjectType);
        dataStore.delete(request.subjectId, request.fileName, config);
    }

    private void saveToFlatFile(SynapseConfiguration config) throws IOException, XMLStreamException {
        File outputFile = new File(this.configPath);
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        XMLConfigurationSerializer.serializeConfiguration((SynapseConfiguration)config, (OutputStream)fos);
        fos.flush();
        fos.close();
    }

    private void saveFullConfiguration(SynapseConfiguration config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Serializing full mediation configuration to the file system");
        }
        SynapseConfiguration deployedArtifacts = this.removeCAppArtifactsBeforePersist(config);
        MultiXMLConfigurationSerializer serializer = new MultiXMLConfigurationSerializer(this.configPath);
        serializer.serialize(config);
        this.addCAppArtifactsAfterPersist(config, deployedArtifacts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCAppArtifactsAfterPersist(SynapseConfiguration synapseConfiguration, SynapseConfiguration cAppConfig) {
        Lock lock = this.getLock(synapseConfiguration.getAxisConfiguration());
        try {
            lock.lock();
            Map endpoints = cAppConfig.getDefinedEndpoints();
            for (Object name : endpoints.keySet()) {
                Endpoint newEndpoint = (Endpoint)endpoints.get(name);
                synapseConfiguration.addEndpoint((String)name, newEndpoint);
            }
            Map sequences = cAppConfig.getDefinedSequences();
            for (Object name : sequences.keySet()) {
                SequenceMediator newSequences = (SequenceMediator)sequences.get(name);
                synapseConfiguration.addSequence((String)name, (Mediator)newSequences);
            }
            Collection proxyServices = cAppConfig.getProxyServices();
            for (Object proxy : proxyServices) {
                this.deleteItem(proxy.getName(), proxy.getFileName(), 0);
            }
            Map localEntries = cAppConfig.getDefinedEntries();
            for (Object name : localEntries.keySet()) {
                Entry newEntry = (Entry)localEntries.get(name);
                synapseConfiguration.addEntry((String)name, newEntry);
            }
            Collection messageStores = cAppConfig.getMessageStores().values();
            for (Object store : messageStores) {
                synapseConfiguration.addMessageStore(store.getName(), (MessageStore)store);
            }
            Collection messageProcessors = cAppConfig.getMessageProcessors().values();
            for (Object processor : messageProcessors) {
                synapseConfiguration.addMessageProcessor(processor.getName(), (MessageProcessor)processor);
            }
            Map sequenceTemplates = cAppConfig.getSequenceTemplates();
            for (Object name : sequenceTemplates.keySet()) {
                TemplateMediator newTemplate = (TemplateMediator)sequenceTemplates.get(name);
                synapseConfiguration.addSequenceTemplate((String)name, newTemplate);
            }
            Map endpointTemplates = cAppConfig.getEndpointTemplates();
            for (Object name : endpointTemplates.keySet()) {
                Template newEndpointTemplate = (Template)endpointTemplates.get(name);
                synapseConfiguration.addEndpointTemplate((String)name, newEndpointTemplate);
            }
            Collection apiCollection = cAppConfig.getAPIs();
            for (Object api : apiCollection) {
                synapseConfiguration.addAPI(api.getName(), (API)api);
                api.init((SynapseEnvironment)synapseConfiguration.getAxisConfiguration().getParameter("synapse.env").getValue());
            }
            Collection tasks = cAppConfig.getStartups();
            for (Startup task : tasks) {
                synapseConfiguration.addStartup(task);
            }
            Collection inboundEndpoints = cAppConfig.getInboundEndpoints();
            Iterator iterator = inboundEndpoints.iterator();
            while (iterator.hasNext()) {
                InboundEndpoint inboundEndpoint;
                InboundEndpoint newInbound = inboundEndpoint = (InboundEndpoint)iterator.next();
                synapseConfiguration.addInboundEndpoint(newInbound.getName(), newInbound);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynapseConfiguration removeCAppArtifactsBeforePersist(SynapseConfiguration synapseConfiguration) {
        HashMap returnMap = new HashMap();
        Lock lock = this.getLock(synapseConfiguration.getAxisConfiguration());
        SynapseConfiguration cAppArtifactConfig = new SynapseConfiguration();
        try {
            lock.lock();
            Map endpoints = synapseConfiguration.getDefinedEndpoints();
            for (Object name : endpoints.keySet()) {
                Endpoint ep = (Endpoint)endpoints.get(name);
                if (ep == null || ep.getArtifactContainerName() == null) continue;
                ep.setIsEdited(true);
                cAppArtifactConfig.addEndpoint((String)name, ep);
                synapseConfiguration.removeEndpoint((String)name);
            }
            Map sequences = synapseConfiguration.getDefinedSequences();
            for (Object name : sequences.keySet()) {
                SequenceMediator seq = (SequenceMediator)sequences.get(name);
                if (seq == null || seq.getArtifactContainerName() == null) continue;
                seq.setIsEdited(true);
                cAppArtifactConfig.addSequence((String)name, (Mediator)seq);
                synapseConfiguration.removeSequence((String)name);
            }
            Collection proxyServices = synapseConfiguration.getProxyServices();
            for (Object proxy : proxyServices) {
                if (proxy == null || proxy.getArtifactContainerName() == null) continue;
                proxy.setIsEdited(true);
                cAppArtifactConfig.addProxyService(proxy.getName(), (ProxyService)proxy);
            }
            Map localEntries = synapseConfiguration.getDefinedEntries();
            for (Object name : localEntries.keySet()) {
                Entry localEntry = (Entry)localEntries.get(name);
                if (localEntry == null || localEntry.getArtifactContainerName() == null) continue;
                localEntry.setIsEdited(true);
                cAppArtifactConfig.addEntry((String)name, localEntry);
                synapseConfiguration.removeEntry((String)name);
            }
            Collection messageStores = synapseConfiguration.getMessageStores().values();
            for (Object store : messageStores) {
                if (store == null || store.getArtifactContainerName() == null) continue;
                store.setIsEdited(true);
                cAppArtifactConfig.addMessageStore(store.getName(), (MessageStore)store);
                synapseConfiguration.removeMessageStore(store.getName());
            }
            Collection messageProcessors = synapseConfiguration.getMessageProcessors().values();
            for (Object processor : messageProcessors) {
                if (processor == null || processor.getArtifactContainerName() == null) continue;
                processor.setIsEdited(true);
                cAppArtifactConfig.addMessageProcessor(processor.getName(), (MessageProcessor)processor);
                synapseConfiguration.removeMessageProcessor(processor.getName());
            }
            Map sequenceTemplates = synapseConfiguration.getSequenceTemplates();
            for (Object name : sequenceTemplates.keySet()) {
                TemplateMediator seqTemplate = (TemplateMediator)sequenceTemplates.get(name);
                if (seqTemplate == null || seqTemplate.getArtifactContainerName() == null) continue;
                seqTemplate.setIsEdited(true);
                cAppArtifactConfig.addSequenceTemplate((String)name, seqTemplate);
                synapseConfiguration.removeSequenceTemplate((String)name);
            }
            Map endpointTemplates = synapseConfiguration.getEndpointTemplates();
            for (Object name : endpointTemplates.keySet()) {
                Template template = (Template)endpointTemplates.get(name);
                if (template == null || template.getArtifactContainerName() == null) continue;
                template.setIsEdited(true);
                cAppArtifactConfig.addEndpointTemplate((String)name, template);
                synapseConfiguration.removeEndpointTemplate((String)name);
            }
            Collection apiCollection = synapseConfiguration.getAPIs();
            for (Object api : apiCollection) {
                if (api == null || api.getArtifactContainerName() == null) continue;
                api.setIsEdited(true);
                cAppArtifactConfig.addAPI(api.getName(), (API)api);
                synapseConfiguration.removeAPI(api.getName());
            }
            Collection tasks = synapseConfiguration.getStartups();
            for (Startup task : tasks) {
                if (task == null || task.getArtifactContainerName() == null) continue;
                task.setIsEdited(true);
                cAppArtifactConfig.addStartup(task);
                synapseConfiguration.removeStartup(task.getName());
            }
            Collection inboundEndpoints = synapseConfiguration.getInboundEndpoints();
            for (InboundEndpoint inboundEndpoint : inboundEndpoints) {
                if (inboundEndpoint == null || inboundEndpoint.getArtifactContainerName() == null) continue;
                inboundEndpoint.setIsEdited(true);
                cAppArtifactConfig.addInboundEndpoint(inboundEndpoint.getName(), inboundEndpoint);
                synapseConfiguration.removeInboundEndpoint(inboundEndpoint.getName());
            }
            SynapseConfiguration synapseConfiguration2 = cAppArtifactConfig;
            return synapseConfiguration2;
        }
        finally {
            lock.unlock();
        }
    }

    protected Lock getLock(AxisConfiguration axisConfig) {
        Parameter p = axisConfig.getParameter("synapse.config.lock");
        if (p != null) {
            return (Lock)p.getValue();
        }
        log.warn((Object)"synapse.config.lock is null, Recreating a new lock");
        ReentrantLock lock = new ReentrantLock();
        try {
            axisConfig.addParameter("synapse.config.lock", (Object)lock);
            return lock;
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while setting synapse.config.lock");
            return null;
        }
    }

    private class PersistenceRequest {
        private boolean save;
        private int subjectType;
        private String subjectId;
        private String fileName;
        private boolean registryOnly;

        public PersistenceRequest(String subjectId, int subjectType, boolean save) {
            this.save = save;
            this.subjectId = subjectId;
            this.subjectType = subjectType;
        }

        public PersistenceRequest(String subjectId, String fileName, int subjectType, boolean save) {
            this.save = save;
            this.subjectId = subjectId;
            this.subjectType = subjectType;
            this.fileName = fileName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersistenceRequest pr = (PersistenceRequest)o;
            return pr.subjectType == this.subjectType && pr.save == this.save && pr.subjectId.equals(this.subjectId);
        }

        public int hashCode() {
            int result = this.save ? 1 : 0;
            result = 31 * result + this.subjectType;
            result = 31 * result + (this.subjectId != null ? this.subjectId.hashCode() : 0);
            return result;
        }
    }

    private class MediationPersistenceWorker
    extends Thread {
        boolean proceed = true;

        private MediationPersistenceWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting the mediation persistence worker thread");
            }
            while (this.proceed) {
                PersistenceRequest request;
                LinkedList linkedList = MediationPersistenceManager.this.requestQueue;
                synchronized (linkedList) {
                    request = (PersistenceRequest)MediationPersistenceManager.this.requestQueue.poll();
                }
                if (request == null) {
                    try {
                        MediationPersistenceWorker.sleep(MediationPersistenceManager.this.interval);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    if (MediationPersistenceManager.this.flatFileMode) {
                        MediationPersistenceManager.this.saveToFlatFile(MediationPersistenceManager.this.synapseConfiguration);
                        continue;
                    }
                    if (request.save) {
                        MediationPersistenceManager.this.persistElement(MediationPersistenceManager.this.synapseConfiguration, request);
                        continue;
                    }
                    MediationPersistenceManager.this.deleteElement(MediationPersistenceManager.this.synapseConfiguration, request);
                }
                catch (Throwable t) {
                    log.error((Object)"Error while saving mediation configuration changes", t);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Stopping the mediation persistence worker thread");
            }
        }
    }
}

