/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MessageStoreSerializer;
import org.apache.synapse.message.store.MessageStore;
import org.wso2.micro.integrator.initializer.persistence.AbstractStore;

public class MessageStoreStore
extends AbstractStore<MessageStore> {
    public MessageStoreStore(String configPath, String configName) {
        super(configPath);
    }

    @Override
    protected OMElement saveToFile(MessageStore store, SynapseConfiguration synapseConfig) {
        try {
            return this.serializer.serializeMessageStore(store, synapseConfig, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the Message Store: " + store.getName() + " to the file system", e);
            return null;
        }
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration config) {
        File msDir = new File(this.configPath, "message-stores");
        if (!msDir.exists()) {
            return;
        }
        File msFile = new File(msDir, fileName);
        config.getArtifactDeploymentStore().addBackedUpArtifact(msFile.getAbsolutePath());
        msFile.delete();
    }

    @Override
    protected MessageStore getObjectToPersist(String name, SynapseConfiguration config) {
        return config.getMessageStore(name);
    }

    @Override
    protected String getFileName(MessageStore messageStore) {
        return messageStore.getFileName();
    }

    @Override
    protected OMElement serialize(MessageStore obj) {
        return MessageStoreSerializer.serializeMessageStore(null, (MessageStore)obj);
    }
}

