/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.ProxyServiceSerializer;
import org.apache.synapse.core.axis2.ProxyService;
import org.wso2.micro.integrator.initializer.persistence.AbstractStore;

public class ProxyServiceStore
extends AbstractStore<ProxyService> {
    public ProxyServiceStore(String configPath, String configName) {
        super(configPath);
    }

    @Override
    protected String getFileName(ProxyService proxy) {
        return proxy.getFileName();
    }

    @Override
    protected OMElement saveToFile(ProxyService proxy, SynapseConfiguration synapseConfiguration) {
        try {
            return this.serializer.serializeProxy(proxy, synapseConfiguration, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the proxy service: " + proxy.getName() + " to the file system", e);
            return null;
        }
    }

    @Override
    protected OMElement serialize(ProxyService proxy) {
        return ProxyServiceSerializer.serializeProxy(null, (ProxyService)proxy);
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfiguration) {
        File proxyDir = new File(this.configPath, "proxy-services");
        if (!proxyDir.exists()) {
            return;
        }
        File proxyFile = new File(proxyDir, fileName);
        synapseConfiguration.getArtifactDeploymentStore().addBackedUpArtifact(proxyFile.getAbsolutePath());
        proxyFile.delete();
    }

    @Override
    protected ProxyService getObjectToPersist(String name, SynapseConfiguration config) {
        return config.getProxyService(name);
    }
}

