/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.micro.integrator.initializer.persistence.AbstractStore;

public class SequenceStore
extends AbstractStore<SequenceMediator> {
    public SequenceStore(String configPath, String configName) {
        super(configPath);
    }

    @Override
    protected String getFileName(SequenceMediator sequence) {
        return sequence.getFileName();
    }

    @Override
    protected SequenceMediator getObjectToPersist(String name, SynapseConfiguration config) {
        return (SequenceMediator)config.getDefinedSequences().get(name);
    }

    @Override
    protected OMElement saveToFile(SequenceMediator sequence, SynapseConfiguration synapseConfig) {
        try {
            return this.serializer.serializeSequence(sequence, synapseConfig, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the sequence: " + sequence.getName() + " to the file system", e);
            return null;
        }
    }

    @Override
    protected OMElement serialize(SequenceMediator sequence) {
        SequenceMediatorSerializer serializer = new SequenceMediatorSerializer();
        return serializer.serializeMediator(null, (Mediator)sequence);
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfig) {
        File sequenceDir = new File(this.configPath, "sequences");
        if (!sequenceDir.exists()) {
            return;
        }
        File sequenceFile = new File(sequenceDir, fileName);
        synapseConfig.getArtifactDeploymentStore().addBackedUpArtifact(sequenceFile.getAbsolutePath());
        sequenceFile.delete();
    }
}

