/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.serviceCatalog;

import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.micro.integrator.initializer.utils.ServiceCatalogUtils;

public class ServiceCatalogDeployer
implements Runnable {
    private static final Log log = LogFactory.getLog(ServiceCatalogDeployer.class);
    private static final String CAPP_UNZIP_DIR;
    private final String cAppName;
    private final Map serviceCatalogConfiguration;
    private final String repoLocation;

    public ServiceCatalogDeployer(String name, String repoLocation, Map serviceCatalogConfiguration) {
        this.cAppName = name;
        this.repoLocation = repoLocation;
        this.serviceCatalogConfiguration = serviceCatalogConfiguration;
    }

    @Override
    public void run() {
        log.info((Object)("Executing Service Catalog deployer for CApp : " + this.cAppName));
        if (!ServiceCatalogUtils.checkPreConditions()) {
            return;
        }
        Map<String, String> md5MapOfAllService = ServiceCatalogUtils.getAllServices(this.serviceCatalogConfiguration);
        if (md5MapOfAllService == null) {
            return;
        }
        if (!ServiceCatalogUtils.createTemporaryFolders(CAPP_UNZIP_DIR)) {
            return;
        }
        File tempDir = new File(CAPP_UNZIP_DIR, "temp");
        if (!ServiceCatalogUtils.extractMetadataFromCAPPs(tempDir, this.repoLocation, md5MapOfAllService)) {
            return;
        }
        if (!ServiceCatalogUtils.archiveDir(CAPP_UNZIP_DIR + File.separator + "payload.zip", tempDir.getPath())) {
            return;
        }
        ServiceCatalogUtils.publishToAPIM(this.serviceCatalogConfiguration, CAPP_UNZIP_DIR + File.separator + "payload.zip");
    }

    static {
        String javaTmpDir = System.getProperty("java.io.tmpdir");
        CAPP_UNZIP_DIR = javaTmpDir.endsWith(File.separator) ? javaTmpDir + "ServiceCatalog" : javaTmpDir + File.separator + "ServiceCatalog";
    }
}

