/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.initializer.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.xml.SynapseImportSerializer;
import org.apache.synapse.libraries.imports.SynapseImport;

public class SynapseArtifactInitUtils {
    private static final Log log = LogFactory.getLog(SynapseArtifactInitUtils.class);
    private static final String CONNECTOR_XML = "connector.xml";
    private static String APP_UNZIP_DIR;
    private static boolean isAppDirCreated;

    public static String getAppUnzipDir() {
        return APP_UNZIP_DIR;
    }

    public static void initializeConnectors(AxisConfiguration axisConfiguration) {
        String synapseLibPath = axisConfiguration.getRepository().getPath() + File.separator + "synapse-libs";
        File synapseLibDir = new File(synapseLibPath);
        if (synapseLibDir.exists() && synapseLibDir.isDirectory()) {
            File[] connectorList = synapseLibDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".zip");
                }
            });
            if (connectorList == null) {
                return;
            }
            String importConfigDirPath = axisConfiguration.getRepository().getPath() + "synapse-configs/default/imports";
            File importsDir = new File(importConfigDirPath);
            if (!importsDir.exists() && !importsDir.mkdirs()) {
                log.error((Object)("Import synapse config directory does not exists and unable to create: " + importsDir.getAbsolutePath()));
                return;
            }
            for (File connectorZip : connectorList) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Generating import for connector deployed with package: " + connectorZip.getName()));
                }
                String connectorExtractedPath = null;
                try {
                    connectorExtractedPath = SynapseArtifactInitUtils.extractConnector(connectorZip.getAbsolutePath());
                }
                catch (IOException e) {
                    log.error((Object)("Error while extracting Connector zip : " + connectorZip.getAbsolutePath()), (Throwable)e);
                    continue;
                }
                String packageName = SynapseArtifactInitUtils.retrievePackageName(connectorExtractedPath);
                String connectorName = connectorZip.getName().substring(0, connectorZip.getName().indexOf(45));
                QName qualifiedName = new QName(packageName, connectorName);
                File importFile = new File(importsDir, qualifiedName.toString() + ".xml");
                if (importFile.exists()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Generating import config to enable connector: " + qualifiedName));
                }
                SynapseArtifactInitUtils.generateImportConfig(qualifiedName, importFile);
            }
        }
    }

    private static void generateImportConfig(QName qualifiedName, File targetImportFile) {
        SynapseImport synImport = new SynapseImport();
        synImport.setLibName(qualifiedName.getLocalPart());
        synImport.setLibPackage(qualifiedName.getNamespaceURI());
        synImport.setStatus(true);
        OMElement impEl = SynapseImportSerializer.serializeImport((SynapseImport)synImport);
        if (impEl != null) {
            try (FileWriter fileWriter = new FileWriter(targetImportFile);){
                fileWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + impEl.toString());
            }
            catch (IOException e) {
                log.error((Object)("Error occurred while writing import file: " + qualifiedName));
            }
        } else {
            log.error((Object)("Could not add Synapse Import. Invalid import params for libName : " + qualifiedName.getLocalPart() + " packageName : " + qualifiedName.getNamespaceURI()));
        }
    }

    private static String retrievePackageName(String extractedPath) {
        String packageName = null;
        File connectorXml = new File(extractedPath + CONNECTOR_XML);
        if (!connectorXml.exists()) {
            log.error((Object)("connector.xml file not found at : " + extractedPath));
        }
        try (FileInputStream xmlInputStream = new FileInputStream(connectorXml);){
            OMElement connectorDef = new StAXOMBuilder((InputStream)xmlInputStream).getDocumentElement();
            OMAttribute packageAttr = connectorDef.getFirstElement().getAttribute(new QName("package"));
            if (packageAttr != null) {
                packageName = packageAttr.getAttributeValue();
            }
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error while parsing the connector.xml file ", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("connector.xml File cannot be loaded from " + extractedPath), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error occurred while reading: " + connectorXml.getPath()));
        }
        return packageName;
    }

    public static String extractConnector(String connectorPath) throws IOException {
        SynapseArtifactInitUtils.createTempDirectory();
        String tempConnectorPathFormatted = SynapseArtifactInitUtils.formatPath(connectorPath);
        String fileName = tempConnectorPathFormatted.substring(tempConnectorPathFormatted.lastIndexOf(47) + 1);
        String dest = SynapseArtifactInitUtils.getAppUnzipDir() + File.separator + System.currentTimeMillis() + fileName + File.separator;
        SynapseArtifactInitUtils.createDir(dest);
        SynapseArtifactInitUtils.extract(connectorPath, dest);
        return dest;
    }

    private static void createTempDirectory() {
        if (isAppDirCreated) {
            return;
        }
        SynapseArtifactInitUtils.createDir(SynapseArtifactInitUtils.getAppUnzipDir());
        isAppDirCreated = true;
    }

    public static void createDir(String path) {
        File temp = new File(path);
        if (!temp.exists() && !temp.mkdirs()) {
            log.error((Object)("Error while creating directory : " + path));
            return;
        }
    }

    public static String formatPath(String path) {
        String pathformatted = path.replaceAll("\\b\\s+\\b", "%20");
        try {
            pathformatted = URLDecoder.decode(pathformatted, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Unsupported Encoding in the path :" + pathformatted));
        }
        return pathformatted.replace('\\', '/');
    }

    private static void extract(String sourcePath, String destPath) throws IOException {
        ZipFile zipFile = new ZipFile(sourcePath);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        String canonicalDestPath = new File(destPath).getCanonicalPath();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String canonicalEntryPath = new File(destPath + entry.getName()).getCanonicalPath();
            if (!canonicalEntryPath.startsWith(canonicalDestPath)) {
                throw new IOException("Entry is outside of the target dir: " + entry.getName());
            }
            if (entry.isDirectory() || !entry.getName().equalsIgnoreCase(CONNECTOR_XML)) continue;
            SynapseArtifactInitUtils.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(destPath + entry.getName())));
        }
        zipFile.close();
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[40960];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    static {
        isAppDirCreated = false;
        String javaTmpDir = System.getProperty("java.io.tmpdir");
        APP_UNZIP_DIR = javaTmpDir.endsWith(File.separator) ? javaTmpDir + "synapse-libs" : javaTmpDir + File.separator + "synapse-libs";
    }
}

