/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.jetty.auth.oauth2;

import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.util.Throwables;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;

public final class LocalServerReceiver
implements VerificationCodeReceiver {
    private static final String LOCALHOST = "localhost";
    private static final String CALLBACK_PATH = "/Callback";
    private HttpServer server;
    String code;
    String error;
    final Semaphore waitUnlessSignaled = new Semaphore(0);
    private int port;
    private final String host;
    private final String callbackPath;
    private String successLandingPageUrl;
    private String failureLandingPageUrl;

    public LocalServerReceiver() {
        this(LOCALHOST, -1, CALLBACK_PATH, null, null);
    }

    LocalServerReceiver(String host, int port, String successLandingPageUrl, String failureLandingPageUrl) {
        this(host, port, CALLBACK_PATH, successLandingPageUrl, failureLandingPageUrl);
    }

    LocalServerReceiver(String host, int port, String callbackPath, String successLandingPageUrl, String failureLandingPageUrl) {
        this.host = host;
        this.port = port;
        this.callbackPath = callbackPath;
        this.successLandingPageUrl = successLandingPageUrl;
        this.failureLandingPageUrl = failureLandingPageUrl;
    }

    @Override
    public String getRedirectUri() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(this.port != -1 ? this.port : this.findOpenPort()), 0);
        HttpContext context = this.server.createContext(this.callbackPath, new CallbackHandler());
        this.server.setExecutor(null);
        try {
            this.server.start();
            this.port = this.server.getAddress().getPort();
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new IOException(e);
        }
        return "http://" + this.getHost() + ":" + this.port + this.callbackPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findOpenPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            socket.setReuseAddress(true);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("No free TCP/IP port to start embedded HTTP Server on");
        }
    }

    @Override
    public String waitForCode() throws IOException {
        this.waitUnlessSignaled.acquireUninterruptibly();
        if (this.error != null) {
            throw new IOException("User authorization failed (" + this.error + ")");
        }
        return this.code;
    }

    @Override
    public void stop() throws IOException {
        this.waitUnlessSignaled.release();
        if (this.server != null) {
            try {
                this.server.stop(0);
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e);
                throw new IOException(e);
            }
            this.server = null;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getCallbackPath() {
        return this.callbackPath;
    }

    class CallbackHandler
    implements HttpHandler {
        CallbackHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            if (!LocalServerReceiver.this.callbackPath.equals(httpExchange.getRequestURI().getPath())) {
                return;
            }
            StringBuilder body = new StringBuilder();
            try {
                Map<String, String> parms = this.queryToMap(httpExchange.getRequestURI().getQuery());
                LocalServerReceiver.this.error = parms.get("error");
                LocalServerReceiver.this.code = parms.get("code");
                Headers respHeaders = httpExchange.getResponseHeaders();
                if (LocalServerReceiver.this.error == null && LocalServerReceiver.this.successLandingPageUrl != null) {
                    respHeaders.add("Location", LocalServerReceiver.this.successLandingPageUrl);
                    httpExchange.sendResponseHeaders(302, -1L);
                } else if (LocalServerReceiver.this.error != null && LocalServerReceiver.this.failureLandingPageUrl != null) {
                    respHeaders.add("Location", LocalServerReceiver.this.failureLandingPageUrl);
                    httpExchange.sendResponseHeaders(302, -1L);
                } else {
                    this.writeLandingHtml(httpExchange, respHeaders);
                }
                httpExchange.close();
            }
            finally {
                LocalServerReceiver.this.waitUnlessSignaled.release();
            }
        }

        private Map<String, String> queryToMap(String query) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (query != null) {
                for (String param : query.split("&")) {
                    String[] pair = param.split("=");
                    if (pair.length > 1) {
                        result.put(pair[0], pair[1]);
                        continue;
                    }
                    result.put(pair[0], "");
                }
            }
            return result;
        }

        private void writeLandingHtml(HttpExchange exchange, Headers headers) throws IOException {
            try (OutputStream os = exchange.getResponseBody();){
                exchange.sendResponseHeaders(200, 0L);
                headers.add("ContentType", "text/html");
                OutputStreamWriter doc = new OutputStreamWriter(os, StandardCharsets.UTF_8);
                doc.write("<html>");
                doc.write("<head><title>OAuth 2.0 Authentication Token Received</title></head>");
                doc.write("<body>");
                doc.write("Received verification code. You may now close this window.");
                doc.write("</body>");
                doc.write("</html>\n");
                doc.flush();
            }
        }
    }

    public static final class Builder {
        private String host = "localhost";
        private int port = -1;
        private String successLandingPageUrl;
        private String failureLandingPageUrl;
        private String callbackPath = "/Callback";

        public LocalServerReceiver build() {
            return new LocalServerReceiver(this.host, this.port, this.callbackPath, this.successLandingPageUrl, this.failureLandingPageUrl);
        }

        public String getHost() {
            return this.host;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public String getCallbackPath() {
            return this.callbackPath;
        }

        public Builder setCallbackPath(String callbackPath) {
            this.callbackPath = callbackPath;
            return this;
        }

        public Builder setLandingPages(String successLandingPageUrl, String failureLandingPageUrl) {
            this.successLandingPageUrl = successLandingPageUrl;
            this.failureLandingPageUrl = failureLandingPageUrl;
            return this;
        }
    }
}

