/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.internal.AttributeUtil;
import io.opentelemetry.sdk.logs.LogBuilder;
import io.opentelemetry.sdk.logs.LogEmitterSharedState;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.data.LogDataBuilder;
import io.opentelemetry.sdk.logs.data.Severity;
import java.time.Instant;
import java.util.concurrent.TimeUnit;

final class SdkLogBuilder
implements LogBuilder {
    private final LogDataBuilder logDataBuilder;
    private final LogEmitterSharedState logEmitterSharedState;
    private final LogLimits logLimits;

    SdkLogBuilder(LogEmitterSharedState logEmitterSharedState, LogDataBuilder logDataBuilder) {
        this.logEmitterSharedState = logEmitterSharedState;
        this.logDataBuilder = logDataBuilder;
        this.logLimits = logEmitterSharedState.getLogLimits();
    }

    @Override
    public LogBuilder setEpoch(long timestamp, TimeUnit unit) {
        this.logDataBuilder.setEpoch(timestamp, unit);
        return this;
    }

    @Override
    public LogBuilder setEpoch(Instant instant) {
        this.logDataBuilder.setEpoch(instant);
        return this;
    }

    @Override
    public LogBuilder setContext(Context context) {
        this.logDataBuilder.setContext(context);
        return this;
    }

    @Override
    public LogBuilder setSeverity(Severity severity) {
        this.logDataBuilder.setSeverity(severity);
        return this;
    }

    @Override
    public LogBuilder setSeverityText(String severityText) {
        this.logDataBuilder.setSeverityText(severityText);
        return this;
    }

    @Override
    public LogBuilder setName(String name) {
        this.logDataBuilder.setName(name);
        return this;
    }

    @Override
    public LogBuilder setBody(String body) {
        this.logDataBuilder.setBody(body);
        return this;
    }

    @Override
    public LogBuilder setAttributes(Attributes attributes) {
        this.logDataBuilder.setAttributes(AttributeUtil.applyAttributesLimit(attributes, this.logLimits.getMaxNumberOfAttributes(), this.logLimits.getMaxAttributeValueLength()));
        return this;
    }

    @Override
    public void emit() {
        if (this.logEmitterSharedState.hasBeenShutdown()) {
            return;
        }
        this.logEmitterSharedState.getLogProcessor().emit(this.logDataBuilder.build());
    }
}

