/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom;

import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.XMLGregorianCalendar;
import org.xcmis.spi.utils.CmisUtils;

public class AtomUtils {
    private static final Pattern Z_FORMAT = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})[Tt](\\d{2}):(\\d{2}):(\\d{2})(\\.(\\d{1,3}))?[zZ]");
    private static final Pattern TD_FORMAT = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})[Tt](\\d{2}):(\\d{2}):(\\d{2})(\\.(\\d{1,3}))?([+-])((\\d{2}):(\\d{2}))");

    public static String getAtomDate(Calendar c) {
        return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03dZ", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
    }

    public static Calendar parseCalendar(String date) {
        Matcher m = Z_FORMAT.matcher(date);
        if (m.matches()) {
            Calendar c = Calendar.getInstance();
            c.set(1, Integer.parseInt(m.group(1)));
            c.set(2, Integer.parseInt(m.group(2)) - 1);
            c.set(5, Integer.parseInt(m.group(3)));
            c.set(11, Integer.parseInt(m.group(4)));
            c.set(12, Integer.parseInt(m.group(5)));
            c.set(13, Integer.parseInt(m.group(6)));
            c.set(14, m.group(7) == null ? 0 : Integer.parseInt(m.group(8)));
            return c;
        }
        m = TD_FORMAT.matcher(date);
        if (m.matches()) {
            int t = m.group(9).equals("+") ? 1 : -1;
            Calendar c = Calendar.getInstance();
            c.set(1, Integer.parseInt(m.group(1)));
            c.set(2, Integer.parseInt(m.group(2)) - 1);
            c.set(5, Integer.parseInt(m.group(3)));
            c.set(11, Integer.parseInt(m.group(4)) + t * Integer.parseInt(m.group(11)));
            c.set(12, Integer.parseInt(m.group(5)) + t * Integer.parseInt(m.group(12)));
            c.set(13, Integer.parseInt(m.group(6)));
            c.set(14, m.group(7) == null ? 0 : Integer.parseInt(m.group(8)));
            return c;
        }
        throw new IllegalArgumentException("Unsupported date format " + date);
    }

    public static XMLGregorianCalendar parseXMLCalendar(String date) {
        return CmisUtils.fromCalendar((Calendar)AtomUtils.parseCalendar(date));
    }
}

