/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParameterList;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Person;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.EmptyResponseContext;
import org.apache.abdera.protocol.server.context.MediaResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.commons.codec.binary.Base64;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.ModuleException;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.AtomUtils;
import org.xcmis.restatom.abdera.ContentTypeElement;
import org.xcmis.restatom.abdera.ObjectTypeElement;
import org.xcmis.restatom.collections.AbstractCmisCollection;
import org.xcmis.restatom.types.CmisContentType;
import org.xcmis.restatom.types.EnumReturnVersion;
import org.xcmis.spi.BaseContentStream;
import org.xcmis.spi.ChangeTokenHolder;
import org.xcmis.spi.Connection;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentAlreadyExistsException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.StreamNotSupportedException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.Rendition;
import org.xcmis.spi.model.RepositoryCapabilities;
import org.xcmis.spi.model.impl.StringProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CmisObjectCollection
extends AbstractCmisCollection<CmisObject> {
    protected static final String SPACES_AIR_SPECIFIC_REFERER = "app:/CMISSpacesAir.swf";
    protected static final String ANONYMOUS = "anonymous";
    protected static final String SYSTEM = "system";

    @Override
    public void deleteEntry(String objectId, RequestContext request) throws ResponseContextException {
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            conn.deleteObject(objectId, null);
        }
        catch (ConstraintException cve) {
            throw new ResponseContextException(this.createErrorResponse(cve, 409));
        }
        catch (StorageException re) {
            throw new ResponseContextException(this.createErrorResponse(re, 500));
        }
        catch (UpdateConflictException uce) {
            throw new ResponseContextException(this.createErrorResponse(uce, 409));
        }
        catch (ObjectNotFoundException onfe) {
            throw new ResponseContextException(this.createErrorResponse(onfe, 404));
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 400));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseContext deleteMedia(RequestContext request) {
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            ChangeTokenHolder changeTokenHolder = new ChangeTokenHolder();
            changeTokenHolder.setValue((Object)request.getHeader("If-Match"));
            String objectId = conn.deleteContentStream(this.getId(request), changeTokenHolder);
            CmisObject object = conn.getProperties(objectId, true, "cmis:changeToken");
            Property<?> changeToken = this.getProperty(object, "cmis:changeToken");
            EmptyResponseContext response = new EmptyResponseContext(204);
            if (changeToken != null && changeToken.getValues().size() > 0) {
                response.setEntityTag((String)changeToken.getValues().get(0));
            }
            EmptyResponseContext emptyResponseContext = response;
            return emptyResponseContext;
        }
        catch (ConstraintException cve) {
            ResponseContext responseContext = this.createErrorResponse(cve, 409);
            return responseContext;
        }
        catch (StorageException re) {
            ResponseContext responseContext = this.createErrorResponse(re, 500);
            return responseContext;
        }
        catch (UpdateConflictException uce) {
            ResponseContext responseContext = this.createErrorResponse(uce, 409);
            return responseContext;
        }
        catch (ObjectNotFoundException onfe) {
            ResponseContext responseContext = this.createErrorResponse(onfe, 404);
            return responseContext;
        }
        catch (InvalidArgumentException iae) {
            ResponseContext responseContext = this.createErrorResponse(iae, 400);
            return responseContext;
        }
        catch (Throwable t) {
            ResponseContext responseContext = this.createErrorResponse(t, 500);
            return responseContext;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public void deleteMedia(String documentId, RequestContext request) throws ResponseContextException {
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            ChangeTokenHolder changeTokenHolder = new ChangeTokenHolder();
            changeTokenHolder.setValue((Object)request.getHeader("If-Match"));
            conn.deleteContentStream(documentId, changeTokenHolder);
        }
        catch (ConstraintException cve) {
            throw new ResponseContextException(this.createErrorResponse(cve, 409));
        }
        catch (StorageException re) {
            throw new ResponseContextException(this.createErrorResponse(re, 500));
        }
        catch (UpdateConflictException uce) {
            throw new ResponseContextException(this.createErrorResponse(uce, 409));
        }
        catch (ObjectNotFoundException onfe) {
            throw new ResponseContextException(this.createErrorResponse(onfe, 404));
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 400));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public String getAuthor(RequestContext request) throws ResponseContextException {
        Principal principal = request.getPrincipal();
        if (principal != null) {
            return principal.getName();
        }
        return ANONYMOUS;
    }

    public List<Person> getAuthors(CmisObject object, RequestContext request) throws ResponseContextException {
        String author = object.getObjectInfo().getCreatedBy();
        Person p = request.getAbdera().getFactory().newAuthor();
        if (author != null) {
            p.setName(author);
        } else {
            p.setName(SYSTEM);
        }
        return Collections.singletonList(p);
    }

    public String getContentType(CmisObject object) {
        String contentType = object.getObjectInfo().getContentStreamMimeType();
        if (contentType != null && !"".equals(contentType)) {
            return contentType;
        }
        return null;
    }

    public CmisObject getEntry(String id, RequestContext request) throws ResponseContextException {
        IncludeRelationships includeRelationships;
        boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions", false);
        String propertyFilter = request.getParameter("filter");
        boolean includePolicies = this.getBooleanParameter(request, "includePolicyIds", false);
        boolean includeACL = this.getBooleanParameter(request, "includeACL", false);
        String renditionFilter = request.getParameter("renditionFilter");
        try {
            includeRelationships = request.getParameter("includeRelationships") == null || request.getParameter("includeRelationships").length() == 0 ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)request.getParameter("includeRelationships"));
        }
        catch (IllegalArgumentException iae) {
            String msg = "Invalid parameter " + request.getParameter("includeRelationships");
            throw new ResponseContextException(this.createErrorResponse(msg, 400));
        }
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            CmisObject object = id.charAt(0) != '/' ? conn.getObject(id, includeAllowableActions, includeRelationships, includePolicies, includeACL, true, propertyFilter, renditionFilter) : conn.getObjectByPath(id, includeAllowableActions, includeRelationships, includePolicies, includeACL, true, propertyFilter, renditionFilter);
            BaseType type = this.getBaseObjectType(object);
            if (type == BaseType.DOCUMENT) {
                EnumReturnVersion enumReturnVersion;
                String returnVersion = request.getParameter("returnVersion");
                if (returnVersion == null || returnVersion.length() == 0) {
                    CmisObject cmisObject = object;
                    return cmisObject;
                }
                try {
                    enumReturnVersion = EnumReturnVersion.fromValue(returnVersion);
                }
                catch (IllegalArgumentException iae) {
                    String msg = "Invalid parameter " + returnVersion;
                    throw new ResponseContextException(this.createErrorResponse(msg, 400));
                }
                if (enumReturnVersion == EnumReturnVersion.THIS) {
                    CmisObject iae = object;
                    return iae;
                }
                if (enumReturnVersion == EnumReturnVersion.LATEST && object.getObjectInfo().isLatestVersion().booleanValue()) {
                    CmisObject iae = object;
                    return iae;
                }
                if (enumReturnVersion == EnumReturnVersion.LATESTMAJOR && object.getObjectInfo().isLatestMajorVersion().booleanValue()) {
                    CmisObject iae = object;
                    return iae;
                }
                String versionSeriesId = object.getObjectInfo().getVersionSeriesId();
                CmisObject cmisObject = conn.getObjectOfLatestVersion(versionSeriesId, enumReturnVersion == EnumReturnVersion.LATESTMAJOR, includeAllowableActions, includeRelationships, includePolicies, includeACL, true, propertyFilter, renditionFilter);
                return cmisObject;
            }
            CmisObject cmisObject = object;
            return cmisObject;
        }
        catch (FilterNotValidException fe) {
            throw new ResponseContextException(this.createErrorResponse(fe, 400));
        }
        catch (ObjectNotFoundException onfe) {
            throw new ResponseContextException(this.createErrorResponse(onfe, 404));
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 400));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public String getId(CmisObject object) throws ResponseContextException {
        return object.getObjectInfo().getId();
    }

    public String getId(RequestContext request) {
        return request.getTarget().getParameter("objectid");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseContext getMedia(RequestContext request) {
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            ContentStream content = conn.getContentStream(this.getId(request), this.getStreamId(request));
            MediaResponseContext response = new MediaResponseContext(content.getStream(), 200);
            response.setContentType(content.getMediaType().toString());
            response.setContentLength(content.length());
            response.setHeader("Content-Disposition", (Object)("attachment; filename=\"" + content.getFileName() + "\""));
            MediaResponseContext mediaResponseContext = response;
            return mediaResponseContext;
        }
        catch (ObjectNotFoundException onfe) {
            ResponseContext responseContext = this.createErrorResponse(onfe, 404);
            return responseContext;
        }
        catch (ConstraintException cve) {
            ResponseContext responseContext = this.createErrorResponse(cve, 409);
            return responseContext;
        }
        catch (Throwable t) {
            ResponseContext responseContext = this.createErrorResponse(t, 500);
            return responseContext;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public String getName(CmisObject object) throws ResponseContextException {
        return object.getObjectInfo().getName();
    }

    public String getStreamId(RequestContext request) {
        return request.getTarget().getParameter("streamid");
    }

    public String getTitle(CmisObject object) throws ResponseContextException {
        return object.getObjectInfo().getName();
    }

    public Date getUpdated(CmisObject object) throws ResponseContextException {
        return this.getLastModificationDate(object).getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseContext putEntry(RequestContext request) {
        Entry entry;
        try {
            entry = this.getEntryFromRequest(request);
        }
        catch (ResponseContextException rce) {
            return rce.getResponseContext();
        }
        Connection conn = null;
        try {
            CmisObject object;
            conn = this.getConnection(request);
            ObjectTypeElement objectElement = (ObjectTypeElement)entry.getFirstChild(AtomCMIS.OBJECT);
            object = objectElement != null ? (object = objectElement.getObject()) : new CmisObject();
            this.updatePropertiesFromEntry(object, entry);
            Map properties = object.getProperties();
            Collection policyIds = object.getPolicyIds();
            List acl = object.getACL();
            ContentStream contentStream = this.getContentStream(entry, request);
            boolean checkin = this.getBooleanParameter(request, "checkin", false);
            String updatedId = null;
            if (checkin) {
                boolean major = this.getBooleanParameter(request, "major", true);
                String checkinComment = request.getParameter("checkinComment");
                updatedId = conn.checkin(this.getId(request), major, properties, contentStream, checkinComment, acl, null, policyIds);
            } else {
                CmisObject cmisObject = conn.getProperties(this.getId(request), true, "cmis:baseTypeId");
                BaseType baseType = cmisObject.getObjectInfo().getBaseType();
                ChangeTokenHolder changeTokenHolder = new ChangeTokenHolder();
                changeTokenHolder.setValue((Object)request.getHeader("If-Match"));
                updatedId = conn.updateProperties(this.getId(request), changeTokenHolder, properties);
                if (baseType == BaseType.DOCUMENT && contentStream != null) {
                    updatedId = conn.setContentStream(this.getId(request), contentStream, changeTokenHolder, Boolean.valueOf(true));
                }
            }
            CmisObject updated = conn.getProperties(updatedId, true, "*");
            entry = request.getAbdera().getFactory().newEntry();
            this.addEntryDetails(request, entry, request.getResolvedUri(), updated);
            ResponseContext responseContext = this.buildGetEntryResponse(request, entry);
            return responseContext;
        }
        catch (ConstraintException cve) {
            ResponseContext responseContext = this.createErrorResponse(cve, 409);
            return responseContext;
        }
        catch (NameConstraintViolationException nce) {
            ResponseContext responseContext = this.createErrorResponse(nce, 400);
            return responseContext;
        }
        catch (StorageException re) {
            ResponseContext responseContext = this.createErrorResponse(re, 500);
            return responseContext;
        }
        catch (UpdateConflictException uce) {
            ResponseContext responseContext = this.createErrorResponse(uce, 409);
            return responseContext;
        }
        catch (InvalidArgumentException iae) {
            ResponseContext responseContext = this.createErrorResponse(iae, 400);
            return responseContext;
        }
        catch (ResponseContextException rce) {
            ResponseContext responseContext = rce.getResponseContext();
            return responseContext;
        }
        catch (Throwable t) {
            ResponseContext responseContext = this.createErrorResponse(t, 500);
            return responseContext;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public void putMedia(CmisObject entryObj, MimeType contentType, String slug, InputStream inputStream, RequestContext request) throws ResponseContextException {
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            BaseContentStream content = new BaseContentStream(inputStream, null, this.convertMimeType(contentType));
            ChangeTokenHolder changeTokenHolder = new ChangeTokenHolder();
            changeTokenHolder.setValue((Object)request.getHeader("If-Match"));
            boolean overwriteFlag = this.getBooleanParameter(request, "overwriteFlag", true);
            conn.setContentStream(this.getId(request), (ContentStream)content, changeTokenHolder, Boolean.valueOf(overwriteFlag));
        }
        catch (ConstraintException cve) {
            throw new ResponseContextException(this.createErrorResponse(cve, 409));
        }
        catch (StorageException re) {
            throw new ResponseContextException(this.createErrorResponse(re, 409));
        }
        catch (ContentAlreadyExistsException ce) {
            throw new ResponseContextException(this.createErrorResponse(ce, 409));
        }
        catch (StreamNotSupportedException se) {
            throw new ResponseContextException(this.createErrorResponse(se, 400));
        }
        catch (UpdateConflictException uce) {
            throw new ResponseContextException(this.createErrorResponse(uce, 409));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseContext putMedia(RequestContext request) {
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            BaseContentStream content = new BaseContentStream(request.getInputStream(), null, this.convertMimeType(request.getContentType()));
            ChangeTokenHolder changeTokenHolder = new ChangeTokenHolder();
            changeTokenHolder.setValue((Object)request.getHeader("If-Match"));
            boolean overwriteFlag = this.getBooleanParameter(request, "overwriteFlag", true);
            String updatedId = conn.setContentStream(this.getId(request), (ContentStream)content, changeTokenHolder, Boolean.valueOf(overwriteFlag));
            CmisObject updated = conn.getProperties(updatedId, true, "cmis:changeToken");
            EmptyResponseContext response = new EmptyResponseContext(201);
            String contentLink = this.getContentLink(this.getId(request), request);
            response.setHeader("Content-Location", (Object)contentLink);
            response.setHeader("Location", (Object)contentLink);
            String changeToken = updated.getObjectInfo().getChangeToken();
            if (changeToken != null) {
                response.setEntityTag(changeToken);
            }
            EmptyResponseContext emptyResponseContext = response;
            return emptyResponseContext;
        }
        catch (IOException ioe) {
            ResponseContext responseContext = this.createErrorResponse(ioe, 500);
            return responseContext;
        }
        catch (ConstraintException cve) {
            ResponseContext responseContext = this.createErrorResponse(cve, 409);
            return responseContext;
        }
        catch (StorageException re) {
            ResponseContext responseContext = this.createErrorResponse(re, 409);
            return responseContext;
        }
        catch (ContentAlreadyExistsException ce) {
            ResponseContext responseContext = this.createErrorResponse(ce, 409);
            return responseContext;
        }
        catch (StreamNotSupportedException se) {
            ResponseContext responseContext = this.createErrorResponse(se, 400);
            return responseContext;
        }
        catch (UpdateConflictException uce) {
            ResponseContext responseContext = this.createErrorResponse(uce, 409);
            return responseContext;
        }
        catch (Throwable t) {
            ResponseContext responseContext = this.createErrorResponse(t, 500);
            return responseContext;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    private void processRenditionLinks(Entry entry, CmisObject object, RequestContext request) throws ResponseContextException {
        String baseRenditionHref = this.getBaseRenditionHref(this.getId(object), request);
        List renditionList = object.getRenditions();
        for (Rendition rendition : renditionList) {
            Link link = entry.addLink(baseRenditionHref + "/" + rendition.getStreamId(), "alternate", rendition.getMimeType(), rendition.getTitle(), null, rendition.getLength());
            link.setAttributeValue(AtomCMIS.RENDITION_KIND, rendition.getKind());
            entry.addLink(link);
        }
    }

    protected String addEntryDetails(RequestContext request, Entry entry, IRI feedIri, CmisObject object) throws ResponseContextException {
        String relationships;
        String objectId = this.getId(object);
        entry.setId(objectId);
        entry.setPublished(AtomUtils.getAtomDate(this.getCreationDate(object)));
        entry.setUpdated(AtomUtils.getAtomDate(this.getLastModificationDate(object)));
        entry.setSummary("");
        for (Person person : this.getAuthors(object, request)) {
            entry.addAuthor(person);
        }
        entry.setTitle(this.getTitle(object));
        String service = this.getServiceLink(request);
        entry.addLink(service, "service", "application/atomsvc+xml", null, null, -1L);
        String self = this.getObjectLink(objectId, request);
        entry.addLink(self, "self");
        entry.addLink(self, "edit");
        this.processRenditionLinks(entry, object, request);
        String typeId = object.getObjectInfo().getTypeId();
        entry.addLink(this.getObjectTypeLink(typeId, request), "describedby", "application/atom+xml;type=entry", null, null, -1L);
        entry.addLink(this.getAllowableActionsLink(objectId, request), "http://docs.oasis-open.org/ns/cmis/link/200908/allowableactions", "application/cmis+xml;type=allowableActions", null, null, -1L);
        BaseType baseType = this.getBaseObjectType(object);
        if (baseType == BaseType.FOLDER) {
            String parentId;
            String folderTree;
            relationships = this.getRelationshipsLink(objectId, request);
            entry.addLink(relationships, "http://docs.oasis-open.org/ns/cmis/link/200908/relationships", "application/atom+xml;type=feed", null, null, -1L);
            String policies = this.getPoliciesLink(objectId, request);
            entry.addLink(policies, "http://docs.oasis-open.org/ns/cmis/link/200908/policies", "application/atom+xml;type=feed", null, null, -1L);
            String acl = this.getACLLink(objectId, request);
            entry.addLink(acl, "http://docs.oasis-open.org/ns/cmis/link/200908/acl", "application/cmisacl+xml", null, null, -1L);
            String children = this.getChildrenLink(objectId, request);
            entry.addLink(children, "down", "application/atom+xml;type=feed", null, null, -1L);
            String descendants = this.getDescendantsLink(objectId, request);
            if (descendants != null) {
                entry.addLink(descendants, "down", "application/cmistree+xml", null, null, -1L);
            }
            if ((folderTree = this.getFolderTreeLink(objectId, request)) != null) {
                entry.addLink(folderTree, "http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", "application/atom+xml;type=feed", null, null, -1L);
            }
            if ((parentId = object.getObjectInfo().getParentId()) != null) {
                String parent = this.getObjectLink(parentId, request);
                entry.addLink(parent, "up", "application/atom+xml;type=entry", null, null, -1L);
            }
            String name = object.getObjectInfo().getName();
            entry.setContent(name);
        } else if (baseType == BaseType.DOCUMENT) {
            relationships = this.getRelationshipsLink(objectId, request);
            entry.addLink(relationships, "http://docs.oasis-open.org/ns/cmis/link/200908/relationships", "application/atom+xml;type=feed", null, null, -1L);
            String policies = this.getPoliciesLink(objectId, request);
            entry.addLink(policies, "http://docs.oasis-open.org/ns/cmis/link/200908/policies", "application/atom+xml;type=feed", null, null, -1L);
            String acl = this.getACLLink(objectId, request);
            entry.addLink(acl, "http://docs.oasis-open.org/ns/cmis/link/200908/acl", "application/cmisacl+xml", null, null, -1L);
            String versionSeriesId = object.getObjectInfo().getVersionSeriesId();
            String allVersions = this.getAllVersionsLink(versionSeriesId, request);
            entry.addLink(allVersions, "version-history", "application/atom+xml;type=feed", null, null, -1L);
            StringBuilder sb = new StringBuilder();
            sb.append(self).append('?').append("returnVersion").append('=').append(EnumReturnVersion.LATEST.value());
            entry.addLink(sb.toString(), "current-version", "application/atom+xml;type=entry", null, null, -1L);
            String checkedoutProperty = object.getObjectInfo().getVersionSeriesCheckedOutId();
            if (checkedoutProperty != null) {
                String pwcLink = this.getObjectLink(checkedoutProperty, request);
                entry.addLink(pwcLink, "working-copy", "application/atom+xml;type=entry", null, null, -1L);
            }
            String parent = this.getParentsLink(objectId, request);
            entry.addLink(parent, "up", "application/atom+xml;type=feed", null, null, -1L);
            String contentLink = this.getContentLink(objectId, request);
            entry.addLink(contentLink, "edit-media");
            String contentType = this.getContentType(object);
            if (contentType != null) {
                entry.setContent(new IRI(contentLink), contentType);
            } else {
                Factory factory = request.getAbdera().getFactory();
                Content content = factory.newContent();
                content.setContentType(null);
                content.setSrc(contentLink);
                entry.setContentElement(content);
            }
        } else if (baseType == BaseType.POLICY) {
            relationships = this.getRelationshipsLink(objectId, request);
            entry.addLink(relationships, "http://docs.oasis-open.org/ns/cmis/link/200908/relationships", "application/atom+xml;type=feed", null, null, -1L);
            String policies = this.getPoliciesLink(objectId, request);
            entry.addLink(policies, "http://docs.oasis-open.org/ns/cmis/link/200908/policies", "application/atom+xml;type=feed", null, null, -1L);
            String acl = this.getACLLink(objectId, request);
            entry.addLink(acl, "http://docs.oasis-open.org/ns/cmis/link/200908/acl", "application/cmisacl+xml", null, null, -1L);
            String parent = this.getParentsLink(objectId, request);
            entry.addLink(parent, "up", "application/atom+xml;type=feed", null, null, -1L);
            String name = object.getObjectInfo().getName();
            entry.setContent(name);
        } else if (baseType == BaseType.RELATIONSHIP) {
            String sourceId = object.getObjectInfo().getSourceId();
            entry.addLink(this.getObjectLink(sourceId, request), "http://docs.oasis-open.org/ns/cmis/link/200908/source", "application/atom+xml;type=entry", null, null, -1L);
            String targetId = object.getObjectInfo().getTargetId();
            entry.addLink(this.getObjectLink(targetId, request), "http://docs.oasis-open.org/ns/cmis/link/200908/target", "application/atom+xml;type=entry", null, null, -1L);
            entry.setContent(this.getName(object));
        }
        ObjectTypeElement objectElement = new ObjectTypeElement(request.getAbdera().getFactory(), AtomCMIS.OBJECT);
        objectElement.build(object);
        entry.addExtension((Element)objectElement);
        return self;
    }

    protected org.xcmis.spi.utils.MimeType convertMimeType(MimeType abderaMimeType) {
        if (abderaMimeType == null) {
            return new org.xcmis.spi.utils.MimeType();
        }
        MimeTypeParameterList abderaParameters = abderaMimeType.getParameters();
        HashMap<String, String> paremeters = new HashMap<String, String>();
        Enumeration names = abderaParameters.getNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            paremeters.put(name, abderaParameters.get(name));
        }
        return new org.xcmis.spi.utils.MimeType(abderaMimeType.getPrimaryType(), abderaMimeType.getSubType(), paremeters);
    }

    protected Feed createFeedBase(RequestContext request) throws ResponseContextException {
        Factory factory = request.getAbdera().getFactory();
        Feed feed = factory.newFeed();
        feed.setId(this.getId(request));
        feed.setTitle(this.getTitle(request));
        feed.addAuthor(this.getAuthor(request));
        feed.setUpdated(AtomUtils.getAtomDate(Calendar.getInstance()));
        String service = this.getServiceLink(request);
        feed.addLink(service, "service", "application/atomsvc+xml", null, null, -1L);
        String self = this.getSelfLink(this.getId(request), request);
        feed.addLink(self, "self", "application/atom+xml;type=feed", null, null, -1L);
        String via = this.getObjectLink(this.getId(request), request);
        feed.addLink(via, "via", "application/atom+xml;type=entry", null, null, -1L);
        return feed;
    }

    protected String getACLLink(String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "objacl");
        params.put("id", id);
        String actions = request.absoluteUrlFor((Object)"ENTRY", params);
        return actions;
    }

    protected String getAllowableActionsLink(String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "allowableactions");
        params.put("id", id);
        String actions = request.absoluteUrlFor((Object)"ENTRY", params);
        return actions;
    }

    protected String getAllVersionsLink(String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "versions");
        params.put("id", id);
        String parents = request.absoluteUrlFor((Object)"ENTRY", params);
        return parents;
    }

    protected BaseType getBaseObjectType(CmisObject object) {
        return object.getObjectInfo().getBaseType();
    }

    protected String getBaseRenditionHref(String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "alternate");
        params.put("id", id);
        String link = request.absoluteUrlFor((Object)"ENTRY", params);
        return link;
    }

    protected String getChildrenLink(String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "children");
        params.put("id", id);
        String children = request.absoluteUrlFor((Object)"ENTRY", params);
        return children;
    }

    protected String getSelfLink(String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", this.getHref().substring(1));
        params.put("id", id);
        String children = request.absoluteUrlFor((Object)"ENTRY", params) + "?" + request.getUri().getQuery();
        return children;
    }

    protected String getContentLink(String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "file");
        params.put("id", id);
        String content = request.absoluteUrlFor((Object)"ENTRY", params);
        return content;
    }

    protected ContentStream getContentStream(Entry entry, RequestContext request) throws IOException, ResponseContextException {
        BaseContentStream contentStream = null;
        ContentTypeElement cmisContent = (ContentTypeElement)entry.getExtension(AtomCMIS.CONTENT);
        if (cmisContent != null) {
            CmisContentType content = cmisContent.getContent();
            String base64 = content.getBase64();
            byte[] data = null;
            if (base64 != null) {
                data = Base64.decodeBase64((byte[])base64.getBytes());
            }
            contentStream = new BaseContentStream(data, null, org.xcmis.spi.utils.MimeType.fromString((String)content.getMediatype()));
        } else {
            Content content = entry.getContentElement();
            if (content != null) {
                IRI src = content.getSrc();
                if (src != null) {
                    if (!src.equals((Object)new IRI(this.getContentLink(this.getId(request), request)))) {
                        HTTPConnection connection = new HTTPConnection(src.getScheme(), src.getHost(), src.getPort());
                        connection.setAllowUserInteraction(false);
                        String path = src.getQuery() != null ? src.getPath() + "?" + src.getQuery() : src.getPath();
                        try {
                            HTTPResponse response = connection.Get(path);
                            int status = response.getStatusCode();
                            if (200 != status) {
                                String msg = "Unable get content from URI : " + src.toString() + ". Response status is " + status;
                                throw new ResponseContextException(this.createErrorResponse(msg, status));
                            }
                            contentStream = new BaseContentStream(response.getInputStream(), null, org.xcmis.spi.utils.MimeType.fromString((String)response.getHeader("Content-Type")));
                        }
                        catch (ModuleException ce) {
                            throw new ResponseContextException(this.createErrorResponse(ce, 500));
                        }
                    }
                } else {
                    Content.Type contentType = content.getContentType();
                    if (contentType == Content.Type.XML || contentType == Content.Type.XHTML || contentType == Content.Type.HTML || contentType == Content.Type.TEXT) {
                        byte[] data;
                        org.xcmis.spi.utils.MimeType mediaType;
                        switch (contentType) {
                            case XHTML: {
                                mediaType = new org.xcmis.spi.utils.MimeType("application", "xhtml+xml");
                                break;
                            }
                            case HTML: {
                                mediaType = new org.xcmis.spi.utils.MimeType("text", "html");
                                break;
                            }
                            case TEXT: {
                                mediaType = new org.xcmis.spi.utils.MimeType("text", "plain");
                                break;
                            }
                            case XML: {
                                mediaType = this.convertMimeType(content.getMimeType());
                                break;
                            }
                            default: {
                                mediaType = new org.xcmis.spi.utils.MimeType();
                            }
                        }
                        if (SPACES_AIR_SPECIFIC_REFERER.equalsIgnoreCase(request.getHeader("referer"))) {
                            data = Base64.decodeBase64((byte[])content.getText().getBytes());
                        } else {
                            String charset = mediaType.getParameter("charset");
                            if (charset == null) {
                                mediaType.getParameters().put("charset", "UTF-8");
                            }
                            data = content.getValue().getBytes(charset == null ? "UTF-8" : charset);
                        }
                        contentStream = new BaseContentStream(data, null, mediaType);
                    } else {
                        contentStream = new BaseContentStream(content.getDataHandler().getInputStream(), null, this.convertMimeType(content.getMimeType()));
                    }
                }
            }
        }
        return contentStream;
    }

    protected Calendar getCreationDate(CmisObject object) {
        Calendar creationDate = object.getObjectInfo().getCreationDate();
        if (creationDate != null) {
            return creationDate;
        }
        return Calendar.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDescendantsLink(String id, RequestContext request) {
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            RepositoryCapabilities capabilities = conn.getStorage().getRepositoryInfo().getCapabilities();
            if (capabilities.isCapabilityGetDescendants()) {
                String children;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("repoid", this.getRepositoryId(request));
                params.put("atomdoctype", "descendants");
                params.put("id", id);
                String string = children = request.absoluteUrlFor((Object)"feed", params);
                return string;
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFolderTreeLink(String id, RequestContext request) {
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            RepositoryCapabilities capabilities = conn.getStorage().getRepositoryInfo().getCapabilities();
            if (capabilities.isCapabilityGetFolderTree()) {
                String children;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("repoid", this.getRepositoryId(request));
                params.put("atomdoctype", "foldertree");
                params.put("id", id);
                String string = children = request.absoluteUrlFor((Object)"feed", params);
                return string;
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return null;
    }

    protected Calendar getLastModificationDate(CmisObject object) {
        Calendar lastModification = object.getObjectInfo().getLastModificationDate();
        if (lastModification != null) {
            return lastModification;
        }
        return Calendar.getInstance();
    }

    protected String getObjectLink(String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "object");
        params.put("id", id);
        String link = request.absoluteUrlFor((Object)"ENTRY", params);
        return link;
    }

    protected String getParentsLink(String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "parents");
        params.put("id", id);
        String parents = request.absoluteUrlFor((Object)"feed", params);
        return parents;
    }

    protected String getPoliciesLink(String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "policies");
        params.put("id", id);
        String parents = request.absoluteUrlFor((Object)"feed", params);
        return parents;
    }

    protected Property<?> getProperty(CmisObject object, String propertyName) {
        Map properties = object.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (Property prop : properties.values()) {
                if (!propertyName.equals(prop.getId())) continue;
                return prop;
            }
        }
        return null;
    }

    protected String getRelationshipsLink(String id, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "relationships");
        params.put("id", id);
        String parents = request.absoluteUrlFor((Object)"feed", params);
        return parents;
    }

    protected String getResourceName(RequestContext request) {
        String path = request.getTarget().getParameter("path");
        if (path != null) {
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return path.charAt(0) == '/' ? path : '/' + path;
        }
        return super.getResourceName(request);
    }

    protected void updatePropertiesFromEntry(CmisObject object, Entry entry) {
        String author;
        String title = entry.getTitle();
        if (title != null && title.length() > 0) {
            StringProperty prop = (StringProperty)this.getProperty(object, "cmis:name");
            if (prop == null) {
                prop = new StringProperty();
                prop.setId("cmis:name");
                prop.setLocalName("cmis:name");
                prop.getValues().add(title);
                object.getProperties().put(prop.getId(), prop);
            } else {
                prop.getValues().clear();
                prop.getValues().add(title);
            }
        }
        String string = author = entry.getAuthor() != null ? entry.getAuthor().getName() : null;
        if (author != null && author.length() > 0) {
            StringProperty prop = (StringProperty)this.getProperty(object, "cmis:createdBy");
            if (prop == null) {
                prop = new StringProperty();
                prop.setId("cmis:createdBy");
                prop.setLocalName("cmis:createdBy");
                prop.getValues().add(author);
                object.getProperties().put(prop.getId(), prop);
            } else {
                prop.getValues().clear();
                prop.getValues().add(author);
            }
        }
    }
}

