/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.abdera.ObjectTypeElement;
import org.xcmis.restatom.collections.CmisObjectCollection;
import org.xcmis.spi.Connection;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.StreamNotSupportedException;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.VersioningState;
import org.xcmis.spi.model.impl.IdProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderChildrenCollection
extends CmisObjectCollection {
    public FolderChildrenCollection() {
        this.setHref("/children");
    }

    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        IncludeRelationships includeRelationships;
        boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions", false);
        try {
            includeRelationships = request.getParameter("includeRelationships") == null || request.getParameter("includeRelationships").length() == 0 ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)request.getParameter("includeRelationships"));
        }
        catch (IllegalArgumentException iae) {
            String msg = "Invalid parameter " + request.getParameter("includeRelationships");
            throw new ResponseContextException(msg, 400);
        }
        int maxItems = this.getIntegerParameter(request, "maxItems", Integer.MAX_VALUE);
        int skipCount = this.getIntegerParameter(request, "skipCount", 0);
        boolean includePathSegments = this.getBooleanParameter(request, "includePathSegment", false);
        String propertyFilter = request.getParameter("filter");
        String renditionFilter = request.getParameter("renditionFilter");
        String orderBy = request.getParameter("orderBy");
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            String objectId = this.getId(request);
            ItemsList list = conn.getChildren(objectId, includeAllowableActions, includeRelationships, includePathSegments, true, propertyFilter, renditionFilter, orderBy, maxItems, skipCount);
            this.addPageLinks(objectId, feed, "children", maxItems, skipCount, list.getNumItems(), list.isHasMoreItems(), request);
            if (list.getItems().size() > 0) {
                if (list.getNumItems() != -1) {
                    Element numItems = feed.addExtension(AtomCMIS.NUM_ITEMS);
                    numItems.setText(Integer.toString(list.getNumItems()));
                }
                for (CmisObject oif : list.getItems()) {
                    Entry e = feed.addEntry();
                    IRI feedIri = new IRI(this.getFeedIriForEntry(oif, request));
                    this.addEntryDetails(request, e, feedIri, oif);
                }
            }
        }
        catch (FilterNotValidException fe) {
            throw new ResponseContextException(this.createErrorResponse(fe, 400));
        }
        catch (ObjectNotFoundException onfe) {
            throw new ResponseContextException(this.createErrorResponse(onfe, 404));
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 404));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public Iterable<CmisObject> getEntries(RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException("entries");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseContext postEntry(RequestContext request) {
        Object targetFolderId;
        CmisObject object;
        Entry entry;
        try {
            entry = this.getEntryFromRequest(request);
        }
        catch (ResponseContextException rce) {
            return rce.getResponseContext();
        }
        String sourceFolderId = request.getParameter("sourceFolderId");
        String typeId = null;
        String id = null;
        CmisObject newObject = null;
        ObjectTypeElement objectElement = (ObjectTypeElement)entry.getFirstChild(AtomCMIS.OBJECT);
        boolean hasCMISElement = objectElement != null;
        object = hasCMISElement ? (object = objectElement.getObject()) : new CmisObject();
        this.updatePropertiesFromEntry(object, entry);
        if (hasCMISElement) {
            for (Property p : object.getProperties().values()) {
                String pName = p.getId();
                if ("cmis:objectTypeId".equals(pName)) {
                    typeId = (String)((IdProperty)p).getValues().get(0);
                    continue;
                }
                if (!"cmis:objectId".equals(pName)) continue;
                id = (String)((IdProperty)p).getValues().get(0);
            }
        } else {
            typeId = "cmis:document";
            IdProperty idProperty = new IdProperty();
            idProperty.setId("cmis:objectTypeId");
            idProperty.getValues().add(typeId);
            object.getProperties().put(idProperty.getId(), idProperty);
        }
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            String objectId = null;
            targetFolderId = this.getId(request);
            if (id != null) {
                if (sourceFolderId == null) {
                    conn.addObjectToFolder(id, (String)targetFolderId, true);
                    objectId = id;
                } else {
                    objectId = conn.moveObject(id, (String)targetFolderId, sourceFolderId);
                }
            } else {
                List addACL = object.getACL();
                List removeACL = null;
                List policies = null;
                if (object.getPolicyIds() != null && object.getPolicyIds().size() > 0) {
                    policies = (List)object.getPolicyIds();
                }
                TypeDefinition type = null;
                type = conn.getTypeDefinition(typeId);
                if (type.getBaseId() == BaseType.DOCUMENT) {
                    VersioningState versioningState;
                    String versioningStateParam = request.getParameter("versioningState");
                    try {
                        versioningState = versioningStateParam == null || versioningStateParam.length() == 0 ? VersioningState.MAJOR : VersioningState.fromValue((String)versioningStateParam);
                    }
                    catch (IllegalArgumentException iae) {
                        ResponseContext responseContext = this.createErrorResponse("Invalid argument " + versioningStateParam, 400);
                        if (conn != null) {
                            conn.close();
                        }
                        return responseContext;
                    }
                    objectId = conn.createDocument(this.getId(request), object.getProperties(), this.getContentStream(entry, request), addACL, removeACL, (Collection)policies, versioningState);
                } else {
                    objectId = type.getBaseId() == BaseType.FOLDER ? conn.createFolder(this.getId(request), object.getProperties(), addACL, removeACL, (Collection)policies) : (type.getBaseId() == BaseType.POLICY ? conn.createPolicy(this.getId(request), object.getProperties(), addACL, removeACL, (Collection)policies) : conn.createRelationship(object.getProperties(), addACL, removeACL, (Collection)policies));
                }
            }
            boolean isIncludeAllowableActions = false;
            IncludeRelationships isIncludeRelationships = null;
            boolean isIncludePolicyIDs = false;
            String renditionFilter = null;
            String propertyFilter = "*";
            boolean isIncludeAcl = false;
            newObject = conn.getObject(objectId, isIncludeAllowableActions, isIncludeRelationships, isIncludePolicyIDs, isIncludeAcl, true, propertyFilter, renditionFilter);
        }
        catch (ConstraintException cve) {
            targetFolderId = this.createErrorResponse(cve, 409);
            return targetFolderId;
        }
        catch (UpdateConflictException ue) {
            targetFolderId = this.createErrorResponse(ue, 409);
            return targetFolderId;
        }
        catch (ObjectNotFoundException onfe) {
            targetFolderId = this.createErrorResponse(onfe, 404);
            return targetFolderId;
        }
        catch (TypeNotFoundException te) {
            targetFolderId = this.createErrorResponse(te, 400);
            return targetFolderId;
        }
        catch (InvalidArgumentException iae) {
            targetFolderId = this.createErrorResponse(iae, 400);
            return targetFolderId;
        }
        catch (StreamNotSupportedException se) {
            targetFolderId = this.createErrorResponse(se, 403);
            return targetFolderId;
        }
        catch (StorageException re) {
            targetFolderId = this.createErrorResponse(re, 500);
            return targetFolderId;
        }
        catch (Throwable t) {
            targetFolderId = this.createErrorResponse(t, 500);
            return targetFolderId;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        entry = request.getAbdera().getFactory().newEntry();
        try {
            this.addEntryDetails(request, entry, request.getResolvedUri(), newObject);
        }
        catch (ResponseContextException rce) {
            return rce.getResponseContext();
        }
        HashMap params = new HashMap();
        String link = request.absoluteUrlFor((Object)"ENTRY", params);
        return this.buildCreateEntryResponse(link, entry);
    }

    public String getTitle(RequestContext request) {
        return "Folder Children";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Feed createFeedBase(RequestContext request) throws ResponseContextException {
        Feed feed;
        block11: {
            String folderTree;
            feed = super.createFeedBase(request);
            String id = this.getId(request);
            feed.addLink(this.getChildrenLink(id, request), "down", "application/atom+xml;type=feed", null, null, -1L);
            String descendants = this.getDescendantsLink(id, request);
            if (descendants != null) {
                feed.addLink(descendants, "down", "application/cmistree+xml", null, null, -1L);
            }
            if ((folderTree = this.getFolderTreeLink(id, request)) != null) {
                feed.addLink(folderTree, "http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", "application/atom+xml;type=feed", null, null, -1L);
            }
            Connection conn = null;
            try {
                conn = this.getConnection(request);
                if (id.equals(conn.getStorage().getRepositoryInfo().getRootFolderId())) break block11;
                try {
                    CmisObject parent = conn.getFolderParent(id, true, null);
                    feed.addLink(this.getObjectLink(this.getId(parent), request), "up", "application/atom+xml;type=entry", null, null, -1L);
                }
                catch (FilterNotValidException fe) {
                    throw new ResponseContextException(this.createErrorResponse(fe, 400));
                }
                catch (ObjectNotFoundException onfe) {
                    throw new ResponseContextException(this.createErrorResponse(onfe, 404));
                }
                catch (InvalidArgumentException iae) {
                    throw new ResponseContextException(this.createErrorResponse(iae, 400));
                }
                catch (Throwable t) {
                    throw new ResponseContextException(this.createErrorResponse(t, 500));
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        return feed;
    }
}

