/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.HashSet;
import java.util.regex.Matcher;
import javax.security.auth.Subject;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetBuilder;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.WorkspaceManager;
import org.apache.abdera.protocol.server.impl.AbstractProvider;
import org.apache.abdera.protocol.server.impl.AbstractWorkspaceManager;
import org.apache.abdera.protocol.server.impl.RegexTargetResolver;
import org.apache.abdera.protocol.server.impl.SimpleSubjectResolver;
import org.apache.abdera.protocol.server.impl.SimpleWorkspaceInfo;
import org.apache.abdera.protocol.server.impl.TemplateTargetBuilder;
import org.xcmis.restatom.CmisCollectionInfo;
import org.xcmis.restatom.WorkspaceManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderImpl
extends AbstractProvider {
    private final AbstractWorkspaceManager manager;
    private final TemplateTargetBuilder targetBuilder = new TemplateTargetBuilder();
    private final RegexTargetResolver resolver;

    public ProviderImpl() {
        this.targetBuilder.setTemplate((Object)"ENTRY", "{target_base}/cmisatom/{repoid}/{atomdoctype}/{id}");
        this.targetBuilder.setTemplate((Object)"SERVICE", "{target_base}/cmisatom/{repoid}");
        this.targetBuilder.setTemplate((Object)"feed", "{target_base}/cmisatom/{repoid}/{atomdoctype}/{id}{-opt|?|q,maxItems,skipCount,changeLogToken}{-join|&|q,maxItems,skipCount,changeLogToken}");
        this.resolver = new DecodeRegexTargetResolver();
        this.resolver.setPattern("/cmisatom/([^/]+)/typebyid(/)?([^/?]+)?(\\??.*)?", TargetType.TYPE_ENTRY, new String[]{"repoid", "typeid"});
        this.resolver.setPattern("/cmisatom/([^/]+)/types(/)?([^/?]+)?(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "slash", "typeid"});
        this.resolver.setPattern("/cmisatom/([^/]+?)/typedescendants(/)?([^/?]+)?(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "slash", "typeid"});
        this.resolver.setPattern("/cmisatom/([^/]+)/checkedout(/)?(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "slash"});
        this.resolver.setPattern("/cmisatom/([^/]+)/children/([^/?]+)(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "objectid"});
        this.resolver.setPattern("/cmisatom/([^/]+?)/object/([^/?]+)(\\??.*)?", TargetType.TYPE_ENTRY, new String[]{"repoid", "objectid"});
        this.resolver.setPattern("/cmisatom/([^/]+?)/objectbypath(/)?(\\??.*)?", TargetType.TYPE_ENTRY, new String[]{"repoid"});
        this.resolver.setPattern("/cmisatom/([^/]+)/parents/([^/?]+)(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "objectid"});
        this.resolver.setPattern("/cmisatom/([^/]+)/relationships/([^/?]+)(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "objectid"});
        this.resolver.setPattern("/cmisatom/([^/]+)/descendants/([^/?]+)(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "objectid"});
        this.resolver.setPattern("/cmisatom/([^/]+)/versions/([^/?]+)(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "versionSeriesId"});
        this.resolver.setPattern("/cmisatom/([^/]+)/foldertree/([^/?]+)(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "objectid"});
        this.resolver.setPattern("/cmisatom/([^/]+)/query(/)?(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "slash"});
        this.resolver.setPattern("/cmisatom/([^/]+)/file/([^/?]+)(\\??.*)?", TargetType.TYPE_MEDIA, new String[]{"repoid", "objectid"});
        this.resolver.setPattern("/cmisatom/([^/]+)/policies/([^/?]+)(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "objectid"});
        this.resolver.setPattern("/cmisatom/([^/]+)/alternate/([^/?]+)/([^/?]+)(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "objectid", "streamid"});
        this.resolver.setPattern("/cmisatom/([^/]+)/unfiled(/)?(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "slash"});
        this.resolver.setPattern("/cmisatom/([^/]+)/changes(/)?(\\??.*)?", TargetType.TYPE_COLLECTION, new String[]{"repoid", "slash"});
        SimpleWorkspaceInfo wInfo = new SimpleWorkspaceInfo();
        wInfo.addCollection((CollectionInfo)new CmisCollectionInfo("Folder Children", "/children", "root"));
        wInfo.addCollection((CollectionInfo)new CmisCollectionInfo("Types Children", "/types", "types"));
        wInfo.addCollection((CollectionInfo)new CmisCollectionInfo("Checkedout", "/checkedout", "checkedout"));
        wInfo.addCollection((CollectionInfo)new CmisCollectionInfo("Query", "/query", "query"));
        wInfo.addCollection((CollectionInfo)new CmisCollectionInfo("Unfiled", "/unfiled", "unfiled"));
        this.manager = new WorkspaceManagerImpl();
        this.manager.addWorkspace((WorkspaceInfo)wInfo);
    }

    protected TargetBuilder getTargetBuilder(RequestContext request) {
        return this.targetBuilder;
    }

    protected Resolver<Target> getTargetResolver(RequestContext request) {
        return this.resolver;
    }

    public WorkspaceManager getWorkspaceManager(RequestContext request) {
        return this.manager;
    }

    protected Resolver<Subject> getSubjectResolver(RequestContext request) {
        return new SubjectResolver();
    }

    private class DecodeRegexTargetResolver
    extends RegexTargetResolver {
        private DecodeRegexTargetResolver() {
        }

        protected Target getTarget(TargetType type, RequestContext request, Matcher matcher, String[] fields) {
            return new RegexTargetResolver.RegexTarget(type, request, matcher, fields){

                public String getParameter(String name) {
                    String parameter = super.getParameter(name);
                    if (parameter != null) {
                        try {
                            return URLDecoder.decode(parameter, "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                    return parameter;
                }
            };
        }
    }

    private class SubjectResolver
    extends SimpleSubjectResolver {
        private SubjectResolver() {
        }

        public Subject resolve(Principal principal) {
            HashSet<Principal> principals = new HashSet<Principal>(1);
            principals.add(principal != null ? principal : ANONYMOUS);
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            return subject;
        }
    }
}

