/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.collections.CmisObjectCollection;
import org.xcmis.spi.Connection;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.model.CmisObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllVersionsCollection
extends CmisObjectCollection {
    public AllVersionsCollection(Connection connection) {
        super(connection);
        this.setHref("/versions");
    }

    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        try {
            String objectId = this.getId(request);
            String propertyFilter = request.getParameter("filter");
            boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions", false);
            int maxItems = this.getIntegerParameter(request, "maxItems", Integer.MAX_VALUE);
            int skipCount = this.getIntegerParameter(request, "skipCount", 0);
            Connection connection = this.getConnection(request);
            List list = connection.getAllVersions(objectId, includeAllowableActions, true, propertyFilter);
            if (list.size() > 0) {
                Element numItems = feed.addExtension(AtomCMIS.NUM_ITEMS);
                numItems.setText(Integer.toString(list.size()));
                this.addPageLinks(objectId, feed, "versions", maxItems, skipCount, list.size(), skipCount + maxItems < list.size(), request);
                for (CmisObject one : list) {
                    Entry entry = feed.addEntry();
                    IRI feedIri = new IRI(this.getFeedIriForEntry(one, request));
                    this.addEntryDetails(request, entry, feedIri, one);
                }
            }
        }
        catch (FilterNotValidException fe) {
            throw new ResponseContextException(this.createErrorResponse(fe, 400));
        }
        catch (ObjectNotFoundException onfe) {
            throw new ResponseContextException(this.createErrorResponse(onfe, 404));
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 400));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
    }

    public Iterable<CmisObject> getEntries(RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException("versions");
    }

    public String getTitle(RequestContext request) {
        return "All versions.";
    }

    @Override
    public String getId(RequestContext request) {
        return request.getTarget().getParameter("versionSeriesId");
    }
}

