/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.util.Calendar;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.AtomUtils;
import org.xcmis.restatom.abdera.ObjectTypeElement;
import org.xcmis.restatom.collections.CmisObjectCollection;
import org.xcmis.spi.Connection;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.impl.IdProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckedOutCollection
extends CmisObjectCollection {
    public CheckedOutCollection(Connection connection) {
        super(connection);
        this.setHref("/checkedout");
    }

    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        try {
            IncludeRelationships includeRelationships;
            boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions", false);
            String orderBy = request.getParameter("orderBy");
            String propertyFilter = request.getParameter("filter");
            String renditionFilter = request.getParameter("renditionFilter");
            try {
                includeRelationships = request.getParameter("includeRelationships") == null || request.getParameter("includeRelationships").length() == 0 ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)request.getParameter("includeRelationships"));
            }
            catch (IllegalArgumentException iae) {
                String msg = "Invalid parameter " + request.getParameter("includeRelationships");
                throw new ResponseContextException(msg, 400);
            }
            int maxItems = this.getIntegerParameter(request, "maxItems", Integer.MAX_VALUE);
            int skipCount = this.getIntegerParameter(request, "skipCount", 0);
            Connection connection = this.getConnection(request);
            String folderId = this.getId(request);
            ItemsList list = connection.getCheckedOutDocs(folderId, includeAllowableActions, includeRelationships, true, propertyFilter, renditionFilter, orderBy, maxItems, skipCount);
            this.addPageLinks(folderId, feed, "checkedout", maxItems, skipCount, list.getNumItems(), list.isHasMoreItems(), request);
            if (list.getItems().size() > 0) {
                if (list.getNumItems() != -1) {
                    Element numItems = feed.addExtension(AtomCMIS.NUM_ITEMS);
                    numItems.setText(Integer.toString(list.getNumItems()));
                }
                for (CmisObject object : list.getItems()) {
                    Entry e = feed.addEntry();
                    IRI feedIri = new IRI(this.getFeedIriForEntry(object, request));
                    this.addEntryDetails(request, e, feedIri, object);
                }
            }
        }
        catch (FilterNotValidException fe) {
            throw new ResponseContextException(this.createErrorResponse(fe, 400));
        }
        catch (ObjectNotFoundException onfe) {
            throw new ResponseContextException(this.createErrorResponse(onfe, 400));
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 400));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
    }

    public Iterable<CmisObject> getEntries(RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException("entries");
    }

    @Override
    public String getId(RequestContext request) {
        String id = request.getParameter("folderId");
        if (id != null) {
            return id;
        }
        return null;
    }

    public String getTitle(RequestContext request) {
        return "Checkedout";
    }

    @Override
    public ResponseContext postEntry(RequestContext request) {
        CmisObject object;
        Entry entry;
        try {
            entry = this.getEntryFromRequest(request);
        }
        catch (ResponseContextException rce) {
            return rce.getResponseContext();
        }
        ObjectTypeElement objectElement = (ObjectTypeElement)entry.getFirstChild(AtomCMIS.OBJECT);
        boolean hasCMISElement = objectElement != null;
        object = hasCMISElement ? (object = objectElement.getObject()) : new CmisObject();
        this.updatePropertiesFromEntry(object, entry);
        String id = null;
        if (hasCMISElement) {
            for (Property p : object.getProperties().values()) {
                String pName = p.getId();
                if (!"cmis:objectId".equals(pName)) continue;
                id = (String)((IdProperty)p).getValues().get(0);
            }
        }
        try {
            Connection connection = this.getConnection(request);
            String pwcId = connection.checkout(id);
            entry = request.getAbdera().getFactory().newEntry();
            try {
                this.addEntryDetails(request, entry, request.getResolvedUri(), this.getEntry(pwcId, request));
            }
            catch (ResponseContextException e) {
                return this.createErrorResponse(e);
            }
            String link = this.getObjectLink(pwcId, request);
            return this.buildCreateEntryResponse(link, entry);
        }
        catch (ConstraintException cve) {
            return this.createErrorResponse(cve, 409);
        }
        catch (StorageException re) {
            return this.createErrorResponse(re, 500);
        }
        catch (UpdateConflictException uce) {
            return this.createErrorResponse(uce, 409);
        }
        catch (ObjectNotFoundException onfe) {
            return this.createErrorResponse(onfe, 404);
        }
        catch (InvalidArgumentException iae) {
            return this.createErrorResponse(iae, 400);
        }
        catch (Throwable t) {
            return this.createErrorResponse(t, 500);
        }
    }

    @Override
    protected Feed createFeedBase(RequestContext request) throws ResponseContextException {
        Factory factory = request.getAbdera().getFactory();
        Feed feed = factory.newFeed();
        feed.setId(this.getId(request));
        feed.setTitle(this.getTitle(request));
        feed.addAuthor(this.getAuthor(request));
        feed.setUpdated(AtomUtils.getAtomDate(Calendar.getInstance()));
        feed.addLink(this.getServiceLink(request), "service", "application/atomsvc+xml", null, null, -1L);
        return feed;
    }
}

