/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Person;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.AtomUtils;
import org.xcmis.restatom.abdera.TypeDefinitionTypeElement;
import org.xcmis.restatom.collections.AbstractCmisCollection;
import org.xcmis.spi.Connection;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.model.TypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CmisTypeCollection
extends AbstractCmisCollection<TypeDefinition> {
    public CmisTypeCollection(Connection connection) {
        super(connection);
    }

    public String getAuthor(RequestContext request) throws ResponseContextException {
        return "system";
    }

    public TypeDefinition getEntry(String typeId, RequestContext request) throws ResponseContextException {
        try {
            Connection connection = this.getConnection(request);
            TypeDefinition type = connection.getTypeDefinition(typeId);
            return type;
        }
        catch (TypeNotFoundException tne) {
            throw new ResponseContextException(this.createErrorResponse(tne, 400));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
    }

    public String getId(TypeDefinition entry) throws ResponseContextException {
        return entry.getId();
    }

    public String getId(RequestContext request) {
        String typeId = request.getTarget().getParameter("typeid");
        if (typeId == null) {
            return "cmis:types";
        }
        return typeId;
    }

    public String getName(TypeDefinition entry) throws ResponseContextException {
        return entry.getDisplayName();
    }

    public String getTitle(TypeDefinition entry) throws ResponseContextException {
        return entry.getDisplayName();
    }

    public String getTitle(RequestContext request) {
        return "Cmis Types";
    }

    public Date getUpdated(TypeDefinition entry) throws ResponseContextException {
        return new Date();
    }

    @Override
    public ResponseContext postEntry(RequestContext request) {
        Entry entry;
        try {
            entry = this.getEntryFromRequest(request);
        }
        catch (ResponseContextException rce) {
            return rce.getResponseContext();
        }
        try {
            Connection connection = this.getConnection(request);
            TypeDefinitionTypeElement typeElement = (TypeDefinitionTypeElement)entry.getFirstChild(AtomCMIS.TYPE);
            TypeDefinition type = typeElement.getTypeDefinition();
            String typeId = connection.addType(type);
            boolean includePropertyDefinition = this.getBooleanParameter(request, "includePropertyDefinitions", false);
            type = connection.getTypeDefinition(typeId, includePropertyDefinition);
            entry = request.getAbdera().getFactory().newEntry();
            this.addEntryDetails(request, entry, request.getResolvedUri(), type);
        }
        catch (InvalidArgumentException iae) {
            return this.createErrorResponse(iae, 400);
        }
        catch (ConstraintException ce) {
            return this.createErrorResponse(ce, 409);
        }
        catch (TypeNotFoundException tnfe) {
            return this.createErrorResponse(tnfe, 404);
        }
        catch (StorageException re) {
            return this.createErrorResponse(re, 500);
        }
        catch (ResponseContextException rce) {
            return rce.getResponseContext();
        }
        HashMap params = new HashMap();
        String link = request.absoluteUrlFor((Object)"ENTRY", params);
        return this.buildCreateEntryResponse(link, entry);
    }

    protected String addEntryDetails(RequestContext request, Entry entry, IRI feedIri, TypeDefinition type) throws ResponseContextException {
        entry.setId(type.getId());
        entry.setTitle(type.getDisplayName());
        entry.setUpdated(AtomUtils.getAtomDate(Calendar.getInstance()));
        entry.setPublished(AtomUtils.getAtomDate(Calendar.getInstance()));
        entry.setSummary("");
        Person p = request.getAbdera().getFactory().newAuthor();
        p.setName(this.getAuthor(request));
        entry.addAuthor(p);
        entry.addLink(this.getServiceLink(request), "service", "application/atomsvc+xml", null, null, -1L);
        String self = this.getObjectTypeLink(this.getId(type), request);
        entry.addLink(self, "self", "application/atom+xml;type=entry", null, null, -1L);
        String parentTypeId = type.getParentId();
        if (parentTypeId != null) {
            String parent = this.getObjectTypeLink(parentTypeId, request);
            entry.addLink(parent, "up", "application/atom+xml;type=entry", null, null, -1L);
        }
        String childrenLink = this.getTypeChildrenLink(type.getId(), request);
        entry.addLink(childrenLink, "down", "application/atom+xml;type=feed", null, null, -1L);
        String descendatsLink = this.getTypeDescendantsLink(type.getId(), request);
        entry.addLink(descendatsLink, "down", "application/cmistree+xml", null, null, -1L);
        TypeDefinitionTypeElement objectElement = new TypeDefinitionTypeElement(request.getAbdera().getFactory(), AtomCMIS.TYPE);
        objectElement.build(type);
        entry.addExtension((Element)objectElement);
        return self;
    }

    protected String getTypeChildrenLink(String typeId, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "types");
        params.put("id", typeId);
        String type = request.absoluteUrlFor((Object)"ENTRY", params);
        return type;
    }

    protected String getTypeDescendantsLink(String typeId, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "typedescendants");
        params.put("id", typeId);
        String type = request.absoluteUrlFor((Object)"ENTRY", params);
        return type;
    }

    @Override
    public void deleteEntry(String typeId, RequestContext request) throws ResponseContextException {
        try {
            Connection connection = this.getConnection(request);
            connection.getStorage().removeType(typeId);
        }
        catch (ConstraintException cve) {
            throw new ResponseContextException(this.createErrorResponse(cve, 409));
        }
        catch (TypeNotFoundException tnfe) {
            throw new ResponseContextException(this.createErrorResponse(tnfe, 404));
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 400));
        }
        catch (StorageException re) {
            throw new ResponseContextException(this.createErrorResponse(re, 500));
        }
    }
}

