/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.abdera.ObjectTypeElement;
import org.xcmis.restatom.collections.CmisObjectCollection;
import org.xcmis.spi.Connection;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.RelationshipDirection;
import org.xcmis.spi.model.impl.IdProperty;

public class RelationshipsCollection
extends CmisObjectCollection {
    public RelationshipsCollection(Connection connection) {
        super(connection);
        this.setHref("/relationships");
    }

    public Iterable<CmisObject> getEntries(RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException("entries");
    }

    public String getTitle(RequestContext request) {
        return "Relationships";
    }

    @Override
    public ResponseContext postEntry(RequestContext request) {
        CmisObject relationship;
        Entry entry;
        try {
            entry = this.getEntryFromRequest(request);
        }
        catch (ResponseContextException rce) {
            return rce.getResponseContext();
        }
        ObjectTypeElement objectElement = (ObjectTypeElement)entry.getFirstChild(AtomCMIS.OBJECT);
        CmisObject object = objectElement.getObject();
        this.updatePropertiesFromEntry(object, entry);
        String typeId = null;
        String sourceId = null;
        String targetId = null;
        Map properties = object.getProperties();
        for (Property p : properties.values()) {
            String pId = p.getId();
            if ("cmis:objectTypeId".equals(pId)) {
                typeId = (String)((IdProperty)p).getValues().get(0);
                continue;
            }
            if ("cmis:sourceId".equals(pId)) {
                sourceId = (String)((IdProperty)p).getValues().get(0);
                continue;
            }
            if (!"cmis:targetId".equals(pId)) continue;
            targetId = (String)((IdProperty)p).getValues().get(0);
        }
        if (typeId == null) {
            return this.createErrorResponse("The cmis:objectTypeId is not specified.", 400);
        }
        if (sourceId == null) {
            return this.createErrorResponse("The cmis:sourceId is not specified.", 400);
        }
        if (targetId == null) {
            return this.createErrorResponse("The cmis:targetId is not specified.", 400);
        }
        List addACL = null;
        List removeACL = null;
        Collection policies = null;
        try {
            Connection connection = this.getConnection(request);
            String relationshipId = connection.createRelationship(properties, addACL, removeACL, policies);
            relationship = connection.getProperties(relationshipId, true, "*");
        }
        catch (ConstraintException cve) {
            return this.createErrorResponse(cve, 409);
        }
        catch (StorageException re) {
            return this.createErrorResponse(re, 500);
        }
        catch (ObjectNotFoundException onfe) {
            return this.createErrorResponse(onfe, 404);
        }
        catch (InvalidArgumentException iae) {
            return this.createErrorResponse(iae, 400);
        }
        catch (Throwable t) {
            return this.createErrorResponse(t, 500);
        }
        entry = request.getAbdera().getFactory().newEntry();
        try {
            this.addEntryDetails(request, entry, request.getResolvedUri(), relationship);
        }
        catch (ResponseContextException rce) {
            return rce.getResponseContext();
        }
        HashMap params = new HashMap();
        String link = request.absoluteUrlFor((Object)"ENTRY", params);
        return this.buildCreateEntryResponse(link, entry);
    }

    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        try {
            RelationshipDirection direction;
            String objectId = this.getId(request);
            String typeId = request.getParameter("typeId");
            String propertyFilter = request.getParameter("filter");
            boolean includeSubRelationship = this.getBooleanParameter(request, "includeSubRelationshipTypes", false);
            boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions", false);
            int maxItems = this.getIntegerParameter(request, "maxItems", Integer.MAX_VALUE);
            int skipCount = this.getIntegerParameter(request, "skipCount", 0);
            try {
                direction = request.getParameter("relationshipDirection") == null || request.getParameter("relationshipDirection").length() == 0 ? RelationshipDirection.EITHER : RelationshipDirection.fromValue((String)"relationshipDirection");
            }
            catch (IllegalArgumentException iae) {
                String msg = "Invalid parameter " + request.getParameter("relationshipDirection");
                throw new ResponseContextException(msg, 400);
            }
            Connection connection = this.getConnection(request);
            ItemsList list = connection.getObjectRelationships(objectId, direction, typeId, includeSubRelationship, includeAllowableActions, true, propertyFilter, maxItems, skipCount);
            if (list.getItems().size() > 0) {
                if (list.getNumItems() != -1) {
                    Element numItems = feed.addExtension(AtomCMIS.NUM_ITEMS);
                    numItems.setText(Integer.toString(list.getNumItems()));
                }
                this.addPageLinks(objectId, feed, "relationships", maxItems, skipCount, list.getNumItems(), list.isHasMoreItems(), request);
                for (CmisObject object : list.getItems()) {
                    Entry e = feed.addEntry();
                    IRI feedIri = new IRI(this.getFeedIriForEntry(object, request));
                    this.addEntryDetails(request, e, feedIri, object);
                }
            }
        }
        catch (FilterNotValidException fe) {
            throw new ResponseContextException(this.createErrorResponse(fe, 400));
        }
        catch (ObjectNotFoundException onfe) {
            throw new ResponseContextException(this.createErrorResponse(onfe, 404));
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 400));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
    }
}

