// $ANTLR 3.2 Sep 23, 2009 14:05:07 org/xcmis/search/parser/CMISSQLTreeWalker.g 2011-04-15 15:26:11

package  org.xcmis.search.parser;

import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.DFA;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.runtime.tree.TreeParser;
//import org.exoplatform.commons.utils.ISO8601;
import org.xcmis.spi.utils.CmisUtils;
import org.xcmis.search.model.Limit;
import org.xcmis.search.model.Query;
import org.xcmis.search.model.column.Column;
import org.xcmis.search.model.column.Column.ScoreFunction;
import org.xcmis.search.model.constraint.And;
import org.xcmis.search.model.constraint.ChildNode;
import org.xcmis.search.model.constraint.Comparison;
import org.xcmis.search.model.constraint.Constraint;
import org.xcmis.search.model.constraint.DescendantNode;
import org.xcmis.search.model.constraint.FullTextSearch;
import org.xcmis.search.model.constraint.Not;
import org.xcmis.search.model.constraint.Operator;
import org.xcmis.search.model.constraint.Or;
import org.xcmis.search.model.constraint.PropertyExistence;
import org.xcmis.search.model.operand.DynamicOperand;
import org.xcmis.search.model.operand.FullTextSearchScore;
import org.xcmis.search.model.operand.Literal;
import org.xcmis.search.model.operand.PropertyValue;
import org.xcmis.search.model.ordering.Order;
import org.xcmis.search.model.ordering.Ordering;
import org.xcmis.search.model.source.Join;
import org.xcmis.search.model.source.Selector;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.model.source.Source;
import org.xcmis.search.model.source.join.EquiJoinCondition;
import org.xcmis.search.model.source.join.JoinCondition;
import org.xcmis.search.model.source.join.JoinType;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;





import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class CMISSQLTreeWalker extends TreeParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "QUERY", "COLUMNS", "COLUMN", "CONSTRAINT", "ORDERINGS", "ASC", "DESC", "JOINCONDITION", "QUALIFIER", "TABLE", "JOIN", "INNER", "LEFT_OUTER", "IS_NULL", "IS_NOT_NULL", "PROPERTY_NAME", "COLUMN_NAME", "TABLE_NAME", "CORRELATION_NAME", "SELECT", "FROM", "WHERE", "ORDER_BY", "ALL", "COMMA", "DOT", "AS", "ON", "LPAR", "RPAR", "T_INNER_JOIN", "T_LEFT_OUTER_JOIN", "EQUAL", "SCORE", "OR", "AND", "NOT", "NOTEQUAL", "LESS", "LESSEQUAL", "MORE", "MOREEQUAL", "ANY", "NUMERIC_LITERAL", "STRING_LITERAL", "TRUE", "FALSE", "TIMESTAMP", "IN", "LIKE", "IS", "NULL", "CONTAINS", "FULLTEXT_EXPRESSION", "IN_FOLDER", "IN_TREE", "T_ASC", "T_DESC", "IDENTIFIER", "S", "E", "L", "C", "T", "F", "R", "O", "M", "W", "H", "D", "WS_SYMBOL", "B", "Y", "A", "N", "I", "UNDERSCORE", "J", "U", "K", "P", "QUOTE", "DQUOTE", "PERCENTAGE", "SLASH", "FULLTEXT_NOT", "ESCAPE_SYMBOLS", "DIDGIT", "WS", "G", "Q", "V", "X", "Z"
    };
    public static final int CONTAINS=56;
    public static final int DQUOTE=87;
    public static final int DIDGIT=92;
    public static final int T_LEFT_OUTER_JOIN=35;
    public static final int NOT=40;
    public static final int EOF=-1;
    public static final int NOTEQUAL=41;
    public static final int TABLE_NAME=21;
    public static final int QUOTE=86;
    public static final int STRING_LITERAL=48;
    public static final int LPAR=32;
    public static final int IS_NULL=17;
    public static final int PROPERTY_NAME=19;
    public static final int LESS=42;
    public static final int ORDERINGS=8;
    public static final int T_INNER_JOIN=34;
    public static final int SELECT=23;
    public static final int D=74;
    public static final int E=64;
    public static final int F=68;
    public static final int G=94;
    public static final int FULLTEXT_EXPRESSION=57;
    public static final int A=78;
    public static final int ESCAPE_SYMBOLS=91;
    public static final int B=76;
    public static final int C=66;
    public static final int ASC=9;
    public static final int L=65;
    public static final int M=71;
    public static final int N=79;
    public static final int O=70;
    public static final int H=73;
    public static final int I=80;
    public static final int NULL=55;
    public static final int J=82;
    public static final int K=84;
    public static final int U=83;
    public static final int T=67;
    public static final int ON=31;
    public static final int W=72;
    public static final int V=96;
    public static final int UNDERSCORE=81;
    public static final int Q=95;
    public static final int JOINCONDITION=11;
    public static final int P=85;
    public static final int S=63;
    public static final int R=69;
    public static final int Y=77;
    public static final int PERCENTAGE=88;
    public static final int X=97;
    public static final int IN_FOLDER=58;
    public static final int Z=98;
    public static final int WS=93;
    public static final int MORE=44;
    public static final int IN_TREE=59;
    public static final int OR=38;
    public static final int QUERY=4;
    public static final int COLUMN_NAME=20;
    public static final int FROM=24;
    public static final int FALSE=50;
    public static final int LESSEQUAL=43;
    public static final int CONSTRAINT=7;
    public static final int TIMESTAMP=51;
    public static final int FULLTEXT_NOT=90;
    public static final int WHERE=25;
    public static final int INNER=15;
    public static final int MOREEQUAL=45;
    public static final int NUMERIC_LITERAL=47;
    public static final int TABLE=13;
    public static final int AND=39;
    public static final int CORRELATION_NAME=22;
    public static final int AS=30;
    public static final int SLASH=89;
    public static final int IN=52;
    public static final int COMMA=28;
    public static final int IS=54;
    public static final int IDENTIFIER=62;
    public static final int EQUAL=36;
    public static final int ALL=27;
    public static final int COLUMN=6;
    public static final int DOT=29;
    public static final int T_ASC=60;
    public static final int LIKE=53;
    public static final int QUALIFIER=12;
    public static final int LEFT_OUTER=16;
    public static final int WS_SYMBOL=75;
    public static final int T_DESC=61;
    public static final int IS_NOT_NULL=18;
    public static final int TRUE=49;
    public static final int JOIN=14;
    public static final int COLUMNS=5;
    public static final int ANY=46;
    public static final int SCORE=37;
    public static final int RPAR=33;
    public static final int DESC=10;
    public static final int ORDER_BY=26;

    // delegates
    // delegators


        public CMISSQLTreeWalker(TreeNodeStream input) {
            this(input, new RecognizerSharedState());
        }
        public CMISSQLTreeWalker(TreeNodeStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return CMISSQLTreeWalker.tokenNames; }
    public String getGrammarFileName() { return "org/xcmis/search/parser/CMISSQLTreeWalker.g"; }


      private static final String MORE_THAN_ONE_STR = "Query contains more than one selector. Set selector name for";
      
      class TreeWalkerException extends RecognitionException {

        private String    message;
        private Throwable cause;

        public TreeWalkerException(String message, Throwable cause) {
          this.message = message;
          this.cause = cause;
        }

        public TreeWalkerException(String message) {
          this.message = message;
        }

        public Throwable getCause() {
          return (cause == this ? null : cause);
        }

        public String getMessage() {
          return message;
        }
      }
      

      /**
       * Map selector name , associated queryName.
       */
      Map<SelectorName, SelectorName> selectors = new HashMap<SelectorName, SelectorName>();

     /**
       * Register queryName and return associated selectorName
       * 
       * @param queryName - String queryname name
       * @return selectorName
       * @throws TreeWalkerException if name already defined
       */
      private SelectorName registerQueryName(SelectorName queryName) throws TreeWalkerException {

        if (selectors.containsValue(queryName)) {
          throw new TreeWalkerException("queryName [" + queryName + "] already defined. Use selector name.");
        } else {
          selectors.put(queryName, queryName);
          return queryName;
        }
      }

      /**
       * Register queryName and return associated selectorName
       * 
       * @param queryName - String queryName name
       * @param selectorName - selector name
       * @return selectorName
       * @throws TreeWalkerException if name already defined
       */
      private SelectorName registerQueryName(SelectorName queryName, SelectorName selectorName) throws TreeWalkerException {
        if (selectors.containsKey(queryName)) {
          throw new TreeWalkerException("There is same table [" + queryName
              + "] without selector name. Set selector name for previous definition.");
        }
        if (selectors.containsKey(selectorName)) {
          throw new TreeWalkerException("Selector name [" + selectorName
              + "] already defined. Use another selector name.");
        }
        selectors.put(selectorName, queryName);
        return selectorName;
      }

      /**
       * Get default selector name. If there is more than one table defined,
       * exception will be thrown.
       * 
       * @return SelectorName selector name
       * @throws TreeWalkerException if there is more than one selector.
       */
      private SelectorName getDefaultSelectorName() throws TreeWalkerException {
        if (selectors.size() == 1) {
          SelectorName selectorName = selectors.keySet().iterator().next();
          return selectorName;
        } else {
          return null;
          //throw new TreeWalkerException("There is more than one table. Use selector or table name.");
        }
      }

      /**
       * Get selector name for qualifer. Qualifier may be selector name or table
       * name. Method returns actual selector name.
       * 
       * @param qualifierName - selector or table name
       * @return selector name
       * @throws TreeWalkerException if there is no such selector or selector name.
       */
      private SelectorName getSelectorName(SelectorName qualifierName) throws TreeWalkerException {
        if (selectors.containsKey(qualifierName)) {
          return qualifierName;
        } else if (selectors.containsValue(qualifierName)) {
          Iterator<SelectorName> it = selectors.keySet().iterator();
          // find selectorName associated with queryName name
           while (it.hasNext()) {
            SelectorName selName = it.next();
            SelectorName ntName = selectors.get(selName);
            if ((!selName.equals(qualifierName)) && (ntName.equals(qualifierName))) {
              return selName;
            }
          }
          throw new TreeWalkerException("queryName name [" + qualifierName + "] has no associated selector name.");
        } else {
          throw new TreeWalkerException("There is no selector name or table name [" + qualifierName + "]");
        }

      }


      private String removeQuotes(String src, char quote) throws TreeWalkerException{
        //check is string quoted
        
        if(src.charAt(0)==quote && src.charAt(src.length()-1)==quote){
          // cut quotes
          src = src.substring(1, src.length()-1);
          src = src.replace(String.valueOf(new char[] { quote, quote }), String.valueOf(quote));
        }
        
        return src;
      }
      
      private void unsupEx(String str){
        throw new UnsupportedOperationException(str);
      }

        
      public String processLiteral(String src) throws TreeWalkerException {

        // cut quotes
        src = src.substring(1, src.length()-1);

        char[] chars = src.toCharArray();

        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (char c : chars) {

          if (escaped) {
            switch (c) {
            case '"':
              sb.append('"');
              break;
            case '\'':
              sb.append('\'');
              break;
            case '\\':
              sb.append('\\');
              break;
            case '%':
              sb.append('%');
              break;
            case '_':
              sb.append('_');
              break;
            default:
              // unknown escape symbol
              sb.append('\\');
              sb.append(c);
              throw new TreeWalkerException("Literal <" + src
                  + "> contains unexpected escape symbol <\\" + c + ">.");
            }
            escaped = false;
          } else {
            if (c == '\\') {
              escaped = true;
            } else {
              sb.append(c);
            }
          }

        }
        if (escaped) {
          throw new TreeWalkerException("Literal <" + src
              + "> ended with not complete escape symbol <\\>, use<\\\\>.");
        }

        return sb.toString();
      }

    public String processLIKELiteral(String src) throws TreeWalkerException {

        // cut quotes
        src = src.substring(1, src.length()-1);

        char[] chars = src.toCharArray();

        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (char c : chars) {

          if (escaped) {
            switch (c) {
            case '"':
              sb.append('"');
              break;
            case '\'':
              sb.append('\'');
              break;
            case '\\':
              sb.append('\\');
              break;
            case '%':
              sb.append('\\');
              sb.append('%');
              break;
            case '_':
              sb.append('\\');
              sb.append('_');
              break;
            default:
              // unknown escape symbol
              sb.append('\\');
              sb.append(c);
              throw new TreeWalkerException("Literal <" + src
                  + "> contains unexpected escape symbol <\\" + c + ">.");
            }
            escaped = false;
          } else {
            if (c == '\\') {
              escaped = true;
            } else {
              sb.append(c);
            }
          }

        }
        if (escaped) {
          throw new TreeWalkerException("Literal <" + src
              + "> ended with not complete escape symbol <\\>, use<\\\\>.");
        }

        return sb.toString();
      }

    public String processFulltextLiteral(String src) throws TreeWalkerException {

        // cut quotes
        src = src.substring(1, src.length()-1);

        char[] chars = src.toCharArray();

        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        
        for (char c: chars) {
          if(escaped){
            switch(c){
            case('"'):
              sb.append('"');
              break;
            case('\''):
              sb.append('\'');
              break;
            case('-'):
              sb.append('\\');
              sb.append('-');
              break;
            case('\\'):
              sb.append('\\');
              break;
            default:
              // unknown escape symbol
              sb.append('\\');
              sb.append(c);
              throw new TreeWalkerException("FulltextExpression <" + src
                  + "> contains unexpected escape symbol <\\" + c + ">.");
            }
            escaped = false;
          }else {
            if(c == '\\'){
              escaped =true;
            }else{
              sb.append(c);
            }
          }
        }
        
        if (escaped) {
          throw new TreeWalkerException("Literal <" + src
              + "> ended with not complete escape symbol <\\>, use<\\\\>.");
        }
        
        //Replase not escaped quotes by doublequote
        chars = sb.toString().toCharArray();

        sb = new StringBuilder();
        escaped = false;
        
        for (char c: chars) {
        
          if(escaped){
            sb.append(c);
            escaped = false;
          }else {
            switch(c){
            case('\\'):
              sb.append(c);
              escaped = true;
              break;
            case('\''):
              sb.append('"');
              break;
            default:
              sb.append(c);
            }
          }
        }


        return sb.toString();
      }





    // $ANTLR start "query"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:385:1: query[] returns [Query q] : ^( QUERY s= source cl= columnList (c= searchCondition )? (o= orderings )? ) ;
    public final Query query() throws RecognitionException {
        Query q = null;

        Source s = null;

        List<Column> cl = null;

        Constraint c = null;

        List<Ordering> o = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:386:3: ( ^( QUERY s= source cl= columnList (c= searchCondition )? (o= orderings )? ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:387:3: ^( QUERY s= source cl= columnList (c= searchCondition )? (o= orderings )? )
            {

            	   	Source src=null;	
            	   	List<Column> col=null;
            	   	Constraint cons=null;
            	   	List<Ordering> ord=null;
            	 	
            match(input,QUERY,FOLLOW_QUERY_in_query68); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_source_in_query72);
            s=source();

            state._fsp--;

            src = s;
            pushFollow(FOLLOW_columnList_in_query78);
            cl=columnList();

            state._fsp--;

            col = cl;
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:395:5: (c= searchCondition )?
            int alt1=2;
            switch ( input.LA(1) ) {
                case CONSTRAINT:
                    {
                    alt1=1;
                    }
                    break;
            }

            switch (alt1) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:396:7: c= searchCondition
                    {
                    pushFollow(FOLLOW_searchCondition_in_query96);
                    c=searchCondition();

                    state._fsp--;

                    cons = c;

                    }
                    break;

            }

            // org/xcmis/search/parser/CMISSQLTreeWalker.g:398:5: (o= orderings )?
            int alt2=2;
            switch ( input.LA(1) ) {
                case ORDERINGS:
                    {
                    alt2=1;
                    }
                    break;
            }

            switch (alt2) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:399:7: o= orderings
                    {
                    pushFollow(FOLLOW_orderings_in_query121);
                    o=orderings();

                    state._fsp--;

                    ord = o;

                    }
                    break;

            }


            match(input, Token.UP, null); 
             
            		q =new Query(src,cons,ord,col,Limit.NONE); 
            		

            }

        }
        catch (RecognitionException e) {

            		throw e;

        }
        finally {
        }
        return q;
    }
    // $ANTLR end "query"


    // $ANTLR start "columnList"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:411:1: columnList returns [List<Column> res] : ( ^( COLUMNS ALL ) | ^( COLUMNS (c= column )+ ) );
    public final List<Column> columnList() throws RecognitionException {
        List<Column> res = null;

        Column c = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:412:3: ( ^( COLUMNS ALL ) | ^( COLUMNS (c= column )+ ) )
            int alt4=2;
            switch ( input.LA(1) ) {
            case COLUMNS:
                {
                switch ( input.LA(2) ) {
                case DOWN:
                    {
                    switch ( input.LA(3) ) {
                    case ALL:
                        {
                        alt4=1;
                        }
                        break;
                    case COLUMN:
                        {
                        alt4=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 4, 2, input);

                        throw nvae;
                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 4, 1, input);

                    throw nvae;
                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;
            }

            switch (alt4) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:413:3: ^( COLUMNS ALL )
                    {
                    match(input,COLUMNS,FOLLOW_COLUMNS_in_columnList166); 

                    match(input, Token.DOWN, null); 
                    match(input,ALL,FOLLOW_ALL_in_columnList168); 

                    match(input, Token.UP, null); 

                       List<Column> l = new ArrayList<Column>();
                       Iterator<SelectorName> it = selectors.keySet().iterator();
                    		
                    		while (it.hasNext()) {
                    		  SelectorName selName = it.next();
                             	  l.add(new Column(selName));
                                    }
                                    
                                    res = l;
                                    

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:425:5: ^( COLUMNS (c= column )+ )
                    {
                     List<Column> l = new ArrayList<Column>();
                    match(input,COLUMNS,FOLLOW_COLUMNS_in_columnList189); 

                    match(input, Token.DOWN, null); 
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:428:5: (c= column )+
                    int cnt3=0;
                    loop3:
                    do {
                        int alt3=2;
                        switch ( input.LA(1) ) {
                        case COLUMN:
                            {
                            alt3=1;
                            }
                            break;

                        }

                        switch (alt3) {
                    	case 1 :
                    	    // org/xcmis/search/parser/CMISSQLTreeWalker.g:429:7: c= column
                    	    {
                    	    pushFollow(FOLLOW_column_in_columnList205);
                    	    c=column();

                    	    state._fsp--;

                    	    l.add(c);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt3 >= 1 ) break loop3;
                                EarlyExitException eee =
                                    new EarlyExitException(3, input);
                                throw eee;
                        }
                        cnt3++;
                    } while (true);


                    match(input, Token.UP, null); 
                    res = l;

                    }
                    break;

            }
        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "columnList"


    // $ANTLR start "column"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:437:1: column returns [Column res] : ( ^( COLUMN q= qualifier ALL ) | ^( COLUMN (q= qualifier )? (p= propertyName ) (cn= columnName )? ) | ( ^( COLUMN cf= columnFunction ) ) );
    public final Column column() throws RecognitionException {
        Column res = null;

        SelectorName q = null;

        String p = null;

        String cn = null;

        Column cf = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:438:3: ( ^( COLUMN q= qualifier ALL ) | ^( COLUMN (q= qualifier )? (p= propertyName ) (cn= columnName )? ) | ( ^( COLUMN cf= columnFunction ) ) )
            int alt7=3;
            alt7 = dfa7.predict(input);
            switch (alt7) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:439:3: ^( COLUMN q= qualifier ALL )
                    {
                    match(input,COLUMN,FOLLOW_COLUMN_in_column246); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_qualifier_in_column250);
                    q=qualifier();

                    state._fsp--;

                    match(input,ALL,FOLLOW_ALL_in_column252); 

                    match(input, Token.UP, null); 
                    res = new Column(q);

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:441:5: ^( COLUMN (q= qualifier )? (p= propertyName ) (cn= columnName )? )
                    {
                    SelectorName qname = null;
                    	 	String pname = null;
                    		String cname = null;
                    match(input,COLUMN,FOLLOW_COLUMN_in_column273); 

                    match(input, Token.DOWN, null); 
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:446:5: (q= qualifier )?
                    int alt5=2;
                    switch ( input.LA(1) ) {
                        case QUALIFIER:
                            {
                            alt5=1;
                            }
                            break;
                    }

                    switch (alt5) {
                        case 1 :
                            // org/xcmis/search/parser/CMISSQLTreeWalker.g:447:7: q= qualifier
                            {
                            pushFollow(FOLLOW_qualifier_in_column289);
                            q=qualifier();

                            state._fsp--;

                            qname=q;

                            }
                            break;

                    }

                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:449:5: (p= propertyName )
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:450:7: p= propertyName
                    {
                    pushFollow(FOLLOW_propertyName_in_column314);
                    p=propertyName();

                    state._fsp--;

                    pname=p;

                    }

                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:452:5: (cn= columnName )?
                    int alt6=2;
                    switch ( input.LA(1) ) {
                        case COLUMN_NAME:
                            {
                            alt6=1;
                            }
                            break;
                    }

                    switch (alt6) {
                        case 1 :
                            // org/xcmis/search/parser/CMISSQLTreeWalker.g:453:7: cn= columnName
                            {
                            pushFollow(FOLLOW_columnName_in_column338);
                            cn=columnName();

                            state._fsp--;

                            cname=cn;

                            }
                            break;

                    }


                    match(input, Token.UP, null); 

                    		SelectorName sname;
                    		if(qname!=null){
                    		  sname = getSelectorName(qname);
                    		}else{
                    		  sname = getDefaultSelectorName();
                    		  if(sname == null)
                    		   throw new TreeWalkerException("There is more than one table. Use selector or table name. Column " + pname);
                    		}
                    		
                    		res= new Column(sname, pname, (cname!=null)?cname:pname);
                    		

                    }
                    break;
                case 3 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:469:3: ( ^( COLUMN cf= columnFunction ) )
                    {
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:469:3: ( ^( COLUMN cf= columnFunction ) )
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:470:5: ^( COLUMN cf= columnFunction )
                    {
                    match(input,COLUMN,FOLLOW_COLUMN_in_column371); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_columnFunction_in_column375);
                    cf=columnFunction();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }

                    res = cf;

                    }
                    break;

            }
        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "column"


    // $ANTLR start "columnFunction"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:478:1: columnFunction returns [Column res] : SCORE (cn= columnName )? ;
    public final Column columnFunction() throws RecognitionException {
        Column res = null;

        String cn = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:479:3: ( SCORE (cn= columnName )? )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:480:3: SCORE (cn= columnName )?
            {
            String columnName = null;
            match(input,SCORE,FOLLOW_SCORE_in_columnFunction411); 
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:481:3: (cn= columnName )?
            int alt8=2;
            switch ( input.LA(1) ) {
                case COLUMN_NAME:
                    {
                    alt8=1;
                    }
                    break;
            }

            switch (alt8) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:482:5: cn= columnName
                    {
                    pushFollow(FOLLOW_columnName_in_columnFunction423);
                    cn=columnName();

                    state._fsp--;

                    columnName = cn;

                    }
                    break;

            }

            	SelectorName sname = getDefaultSelectorName();
            		if(sname == null)
            		  throw new TreeWalkerException("There is more than one table. Use selector or table name. Column SCORE()");
            		res = new Column(new ScoreFunction(), columnName);  
            	

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "columnFunction"


    // $ANTLR start "source"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:497:1: source returns [Source res] : ( (t= table ) | ^( JOIN jt= jointype ls= source rs= source (c= joincondition )? ) );
    public final Source source() throws RecognitionException {
        Source res = null;

        Source t = null;

        JoinType jt = null;

        Source ls = null;

        Source rs = null;

        JoinCondition c = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:498:3: ( (t= table ) | ^( JOIN jt= jointype ls= source rs= source (c= joincondition )? ) )
            int alt10=2;
            switch ( input.LA(1) ) {
            case TABLE:
                {
                alt10=1;
                }
                break;
            case JOIN:
                {
                alt10=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;
            }

            switch (alt10) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:499:3: (t= table )
                    {
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:499:3: (t= table )
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:500:5: t= table
                    {
                    pushFollow(FOLLOW_table_in_source474);
                    t=table();

                    state._fsp--;

                    res = t;

                    }


                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:502:5: ^( JOIN jt= jointype ls= source rs= source (c= joincondition )? )
                    {
                    JoinCondition jc = null;
                    match(input,JOIN,FOLLOW_JOIN_in_source496); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_jointype_in_source500);
                    jt=jointype();

                    state._fsp--;

                    pushFollow(FOLLOW_source_in_source504);
                    ls=source();

                    state._fsp--;

                    pushFollow(FOLLOW_source_in_source508);
                    rs=source();

                    state._fsp--;

                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:505:5: (c= joincondition )?
                    int alt9=2;
                    switch ( input.LA(1) ) {
                        case JOINCONDITION:
                            {
                            alt9=1;
                            }
                            break;
                    }

                    switch (alt9) {
                        case 1 :
                            // org/xcmis/search/parser/CMISSQLTreeWalker.g:506:7: c= joincondition
                            {
                            pushFollow(FOLLOW_joincondition_in_source524);
                            c=joincondition();

                            state._fsp--;

                            jc=c;

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                     
                    		if(jc == null){
                    		  unsupEx("JOIN without join condition not supported.");
                    		}
                    		
                    		res = new Join(ls, jt,rs,  jc);
                    		

                    }
                    break;

            }
        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "source"


    // $ANTLR start "jointype"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:521:1: jointype returns [JoinType res] : ( INNER | LEFT_OUTER ) ;
    public final JoinType jointype() throws RecognitionException {
        JoinType res = null;

        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:522:3: ( ( INNER | LEFT_OUTER ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:523:3: ( INNER | LEFT_OUTER )
            {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:523:3: ( INNER | LEFT_OUTER )
            int alt11=2;
            switch ( input.LA(1) ) {
            case INNER:
                {
                alt11=1;
                }
                break;
            case LEFT_OUTER:
                {
                alt11=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 11, 0, input);

                throw nvae;
            }

            switch (alt11) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:524:5: INNER
                    {
                    match(input,INNER,FOLLOW_INNER_in_jointype573); 
                    res = JoinType.INNER;

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:525:7: LEFT_OUTER
                    {
                    match(input,LEFT_OUTER,FOLLOW_LEFT_OUTER_in_jointype583); 
                    res = JoinType.LEFT_OUTER;

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return res;
    }
    // $ANTLR end "jointype"


    // $ANTLR start "joincondition"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:529:1: joincondition returns [JoinCondition res] : ^( JOINCONDITION (s1= qualifier )? p1= propertyName (s2= qualifier )? p2= propertyName ) ;
    public final JoinCondition joincondition() throws RecognitionException {
        JoinCondition res = null;

        SelectorName s1 = null;

        String p1 = null;

        SelectorName s2 = null;

        String p2 = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:530:3: ( ^( JOINCONDITION (s1= qualifier )? p1= propertyName (s2= qualifier )? p2= propertyName ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:531:3: ^( JOINCONDITION (s1= qualifier )? p1= propertyName (s2= qualifier )? p2= propertyName )
            {

            		SelectorName sn1=null;
            		SelectorName sn2=null;		
            		
            match(input,JOINCONDITION,FOLLOW_JOINCONDITION_in_joincondition618); 

            match(input, Token.DOWN, null); 
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:537:5: (s1= qualifier )?
            int alt12=2;
            switch ( input.LA(1) ) {
                case QUALIFIER:
                    {
                    alt12=1;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:538:7: s1= qualifier
                    {
                    pushFollow(FOLLOW_qualifier_in_joincondition634);
                    s1=qualifier();

                    state._fsp--;

                    sn1=s1;

                    }
                    break;

            }

            pushFollow(FOLLOW_propertyName_in_joincondition651);
            p1=propertyName();

            state._fsp--;

            // org/xcmis/search/parser/CMISSQLTreeWalker.g:541:5: (s2= qualifier )?
            int alt13=2;
            switch ( input.LA(1) ) {
                case QUALIFIER:
                    {
                    alt13=1;
                    }
                    break;
            }

            switch (alt13) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:542:7: s2= qualifier
                    {
                    pushFollow(FOLLOW_qualifier_in_joincondition667);
                    s2=qualifier();

                    state._fsp--;

                    sn2=s2;

                    }
                    break;

            }

            pushFollow(FOLLOW_propertyName_in_joincondition684);
            p2=propertyName();

            state._fsp--;


            match(input, Token.UP, null); 

            		//TODO which one selectorname use if qualifier is not set
            		if( sn1==null || sn2==null){
            		  unsupEx("JoinCondition PROPRTY EQUALITY do not contains qualifiers(selector names). Don't know what to do.");
            		}
            		sn1 = getSelectorName(sn1);
            		sn2 = getSelectorName(sn2);
            		
            		res = new EquiJoinCondition(sn1, p1, sn2, p2);
            		

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "joincondition"


    // $ANTLR start "table"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:561:1: table returns [Source res] : ^( TABLE (t= tableName ) (s= correlationName )? ) ;
    public final Source table() throws RecognitionException {
        Source res = null;

        SelectorName t = null;

        SelectorName s = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:562:3: ( ^( TABLE (t= tableName ) (s= correlationName )? ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:563:3: ^( TABLE (t= tableName ) (s= correlationName )? )
            {

            		SelectorName tname=null;
            		SelectorName sname=null;
            		
            match(input,TABLE,FOLLOW_TABLE_in_table728); 

            match(input, Token.DOWN, null); 
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:569:5: (t= tableName )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:570:7: t= tableName
            {
            pushFollow(FOLLOW_tableName_in_table744);
            t=tableName();

            state._fsp--;

            tname=t;

            }

            // org/xcmis/search/parser/CMISSQLTreeWalker.g:572:5: (s= correlationName )?
            int alt14=2;
            switch ( input.LA(1) ) {
                case CORRELATION_NAME:
                    {
                    alt14=1;
                    }
                    break;
            }

            switch (alt14) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:573:7: s= correlationName
                    {
                    pushFollow(FOLLOW_correlationName_in_table768);
                    s=correlationName();

                    state._fsp--;

                    sname=s;

                    }
                    break;

            }


            match(input, Token.UP, null); 

            		if(sname!=null){
            		  sname = registerQueryName(tname, sname);
            		}else{
            		  sname = registerQueryName(tname);
            		}
            		res = new Selector(tname, sname);
            		

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "table"


    // $ANTLR start "searchCondition"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:589:1: searchCondition returns [Constraint res] : ^( CONSTRAINT c= constraint ) ;
    public final Constraint searchCondition() throws RecognitionException {
        Constraint res = null;

        Constraint c = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:590:3: ( ^( CONSTRAINT c= constraint ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:591:3: ^( CONSTRAINT c= constraint )
            {
            match(input,CONSTRAINT,FOLLOW_CONSTRAINT_in_searchCondition812); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_constraint_in_searchCondition816);
            c=constraint();

            state._fsp--;


            match(input, Token.UP, null); 
            res=c;

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "searchCondition"


    // $ANTLR start "constraint"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:598:1: constraint returns [Constraint res] : (p= predicate | ^( NOT c= constraint ) | ^( OR a= constraint b= constraint ) | ^( AND a= constraint b= constraint ) );
    public final Constraint constraint() throws RecognitionException {
        Constraint res = null;

        Constraint p = null;

        Constraint c = null;

        Constraint a = null;

        Constraint b = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:599:3: (p= predicate | ^( NOT c= constraint ) | ^( OR a= constraint b= constraint ) | ^( AND a= constraint b= constraint ) )
            int alt15=4;
            switch ( input.LA(1) ) {
            case IS_NULL:
            case IS_NOT_NULL:
            case EQUAL:
            case NOTEQUAL:
            case LESS:
            case LESSEQUAL:
            case MORE:
            case MOREEQUAL:
            case IN:
            case LIKE:
            case CONTAINS:
            case IN_FOLDER:
            case IN_TREE:
                {
                alt15=1;
                }
                break;
            case NOT:
                {
                alt15=2;
                }
                break;
            case OR:
                {
                alt15=3;
                }
                break;
            case AND:
                {
                alt15=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 15, 0, input);

                throw nvae;
            }

            switch (alt15) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:600:3: p= predicate
                    {
                    pushFollow(FOLLOW_predicate_in_constraint848);
                    p=predicate();

                    state._fsp--;

                    res = p;

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:602:3: ^( NOT c= constraint )
                    {
                    match(input,NOT,FOLLOW_NOT_in_constraint859); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_constraint_in_constraint863);
                    c=constraint();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    res = new Not(c);

                    }
                    break;
                case 3 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:605:3: ^( OR a= constraint b= constraint )
                    {
                    match(input,OR,FOLLOW_OR_in_constraint877); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_constraint_in_constraint881);
                    a=constraint();

                    state._fsp--;

                    pushFollow(FOLLOW_constraint_in_constraint885);
                    b=constraint();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    res=new Or(a, b);

                    }
                    break;
                case 4 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:608:3: ^( AND a= constraint b= constraint )
                    {
                    match(input,AND,FOLLOW_AND_in_constraint899); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_constraint_in_constraint903);
                    a=constraint();

                    state._fsp--;

                    pushFollow(FOLLOW_constraint_in_constraint907);
                    b=constraint();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    res=new And(a, b);

                    }
                    break;

            }
        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "constraint"


    // $ANTLR start "predicate"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:615:1: predicate returns [Constraint res] : (cp= comparisonPredicate | in= inPredicate | like= likePredicate | n= nullPredicate | qcp= quantifiedComparisonPredicate | qIn= quantifiedInPredicate | full= fulltextsearch | inF= inFolder | inT= inTree );
    public final Constraint predicate() throws RecognitionException {
        Constraint res = null;

        Constraint cp = null;

        Constraint in = null;

        Constraint like = null;

        Constraint n = null;

        Constraint qcp = null;

        Constraint qIn = null;

        Constraint full = null;

        Constraint inF = null;

        Constraint inT = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:616:3: (cp= comparisonPredicate | in= inPredicate | like= likePredicate | n= nullPredicate | qcp= quantifiedComparisonPredicate | qIn= quantifiedInPredicate | full= fulltextsearch | inF= inFolder | inT= inTree )
            int alt16=9;
            alt16 = dfa16.predict(input);
            switch (alt16) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:617:3: cp= comparisonPredicate
                    {
                    pushFollow(FOLLOW_comparisonPredicate_in_predicate939);
                    cp=comparisonPredicate();

                    state._fsp--;

                    res=cp;

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:618:5: in= inPredicate
                    {
                    pushFollow(FOLLOW_inPredicate_in_predicate949);
                    in=inPredicate();

                    state._fsp--;

                    res=in;

                    }
                    break;
                case 3 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:619:5: like= likePredicate
                    {
                    pushFollow(FOLLOW_likePredicate_in_predicate959);
                    like=likePredicate();

                    state._fsp--;

                    res=like;

                    }
                    break;
                case 4 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:620:5: n= nullPredicate
                    {
                    pushFollow(FOLLOW_nullPredicate_in_predicate969);
                    n=nullPredicate();

                    state._fsp--;

                    res=n;

                    }
                    break;
                case 5 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:621:5: qcp= quantifiedComparisonPredicate
                    {
                    pushFollow(FOLLOW_quantifiedComparisonPredicate_in_predicate979);
                    qcp=quantifiedComparisonPredicate();

                    state._fsp--;

                    res=qcp;

                    }
                    break;
                case 6 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:622:5: qIn= quantifiedInPredicate
                    {
                    pushFollow(FOLLOW_quantifiedInPredicate_in_predicate989);
                    qIn=quantifiedInPredicate();

                    state._fsp--;

                    res=qIn;

                    }
                    break;
                case 7 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:623:5: full= fulltextsearch
                    {
                    pushFollow(FOLLOW_fulltextsearch_in_predicate999);
                    full=fulltextsearch();

                    state._fsp--;

                    res=full;

                    }
                    break;
                case 8 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:624:5: inF= inFolder
                    {
                    pushFollow(FOLLOW_inFolder_in_predicate1009);
                    inF=inFolder();

                    state._fsp--;

                    res=inF;

                    }
                    break;
                case 9 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:625:5: inT= inTree
                    {
                    pushFollow(FOLLOW_inTree_in_predicate1019);
                    inT=inTree();

                    state._fsp--;

                    res=inT;

                    }
                    break;

            }
        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "predicate"


    // $ANTLR start "comparisonPredicate"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:631:1: comparisonPredicate returns [Constraint res] : ( ^( EQUAL ve= valueExpression l= literal ) | ^( NOTEQUAL ve= valueExpression l= literal ) | ^( LESS ve= valueExpression l= literal ) | ^( LESSEQUAL ve= valueExpression l= literal ) | ^( MORE ve= valueExpression l= literal ) | ^( MOREEQUAL ve= valueExpression l= literal ) );
    public final Constraint comparisonPredicate() throws RecognitionException {
        Constraint res = null;

        DynamicOperand ve = null;

        Literal l = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:632:3: ( ^( EQUAL ve= valueExpression l= literal ) | ^( NOTEQUAL ve= valueExpression l= literal ) | ^( LESS ve= valueExpression l= literal ) | ^( LESSEQUAL ve= valueExpression l= literal ) | ^( MORE ve= valueExpression l= literal ) | ^( MOREEQUAL ve= valueExpression l= literal ) )
            int alt17=6;
            switch ( input.LA(1) ) {
            case EQUAL:
                {
                alt17=1;
                }
                break;
            case NOTEQUAL:
                {
                alt17=2;
                }
                break;
            case LESS:
                {
                alt17=3;
                }
                break;
            case LESSEQUAL:
                {
                alt17=4;
                }
                break;
            case MORE:
                {
                alt17=5;
                }
                break;
            case MOREEQUAL:
                {
                alt17=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 17, 0, input);

                throw nvae;
            }

            switch (alt17) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:633:3: ^( EQUAL ve= valueExpression l= literal )
                    {
                    match(input,EQUAL,FOLLOW_EQUAL_in_comparisonPredicate1047); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_valueExpression_in_comparisonPredicate1051);
                    ve=valueExpression();

                    state._fsp--;

                    pushFollow(FOLLOW_literal_in_comparisonPredicate1055);
                    l=literal();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    res=new Comparison(ve, Operator.EQUAL_TO, l);

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:636:3: ^( NOTEQUAL ve= valueExpression l= literal )
                    {
                    match(input,NOTEQUAL,FOLLOW_NOTEQUAL_in_comparisonPredicate1070); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_valueExpression_in_comparisonPredicate1074);
                    ve=valueExpression();

                    state._fsp--;

                    pushFollow(FOLLOW_literal_in_comparisonPredicate1078);
                    l=literal();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    res=new Comparison(ve, Operator.NOT_EQUAL_TO, l);

                    }
                    break;
                case 3 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:639:3: ^( LESS ve= valueExpression l= literal )
                    {
                    match(input,LESS,FOLLOW_LESS_in_comparisonPredicate1092); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_valueExpression_in_comparisonPredicate1096);
                    ve=valueExpression();

                    state._fsp--;

                    pushFollow(FOLLOW_literal_in_comparisonPredicate1100);
                    l=literal();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    res=new Comparison(ve, Operator.LESS_THAN, l);

                    }
                    break;
                case 4 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:642:3: ^( LESSEQUAL ve= valueExpression l= literal )
                    {
                    match(input,LESSEQUAL,FOLLOW_LESSEQUAL_in_comparisonPredicate1115); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_valueExpression_in_comparisonPredicate1119);
                    ve=valueExpression();

                    state._fsp--;

                    pushFollow(FOLLOW_literal_in_comparisonPredicate1123);
                    l=literal();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    res=new Comparison(ve, Operator.LESS_THAN_OR_EQUAL_TO, l);

                    }
                    break;
                case 5 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:645:3: ^( MORE ve= valueExpression l= literal )
                    {
                    match(input,MORE,FOLLOW_MORE_in_comparisonPredicate1137); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_valueExpression_in_comparisonPredicate1141);
                    ve=valueExpression();

                    state._fsp--;

                    pushFollow(FOLLOW_literal_in_comparisonPredicate1145);
                    l=literal();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    res=new Comparison(ve, Operator.GREATER_THAN, l);

                    }
                    break;
                case 6 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:648:3: ^( MOREEQUAL ve= valueExpression l= literal )
                    {
                    match(input,MOREEQUAL,FOLLOW_MOREEQUAL_in_comparisonPredicate1159); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_valueExpression_in_comparisonPredicate1163);
                    ve=valueExpression();

                    state._fsp--;

                    pushFollow(FOLLOW_literal_in_comparisonPredicate1167);
                    l=literal();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    res=new Comparison(ve, Operator.GREATER_THAN_OR_EQUAL_TO, l);

                    }
                    break;

            }
        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "comparisonPredicate"


    // $ANTLR start "quantifiedComparisonPredicate"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:656:1: quantifiedComparisonPredicate returns [Constraint res] : ( ^( EQUAL ANY cr= columnReference l= literal ) | ^( NOTEQUAL ANY cr= columnReference l= literal ) | ^( LESS ANY cr= columnReference l= literal ) | ^( MORE ANY cr= columnReference l= literal ) | ^( MOREEQUAL ANY cr= columnReference l= literal ) | ^( LESSEQUAL ANY cr= columnReference l= literal ) );
    public final Constraint quantifiedComparisonPredicate() throws RecognitionException {
        Constraint res = null;

        PropertyValue cr = null;

        Literal l = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:657:3: ( ^( EQUAL ANY cr= columnReference l= literal ) | ^( NOTEQUAL ANY cr= columnReference l= literal ) | ^( LESS ANY cr= columnReference l= literal ) | ^( MORE ANY cr= columnReference l= literal ) | ^( MOREEQUAL ANY cr= columnReference l= literal ) | ^( LESSEQUAL ANY cr= columnReference l= literal ) )
            int alt18=6;
            switch ( input.LA(1) ) {
            case EQUAL:
                {
                alt18=1;
                }
                break;
            case NOTEQUAL:
                {
                alt18=2;
                }
                break;
            case LESS:
                {
                alt18=3;
                }
                break;
            case MORE:
                {
                alt18=4;
                }
                break;
            case MOREEQUAL:
                {
                alt18=5;
                }
                break;
            case LESSEQUAL:
                {
                alt18=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 18, 0, input);

                throw nvae;
            }

            switch (alt18) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:658:3: ^( EQUAL ANY cr= columnReference l= literal )
                    {
                    match(input,EQUAL,FOLLOW_EQUAL_in_quantifiedComparisonPredicate1201); 

                    match(input, Token.DOWN, null); 
                    match(input,ANY,FOLLOW_ANY_in_quantifiedComparisonPredicate1203); 
                    pushFollow(FOLLOW_columnReference_in_quantifiedComparisonPredicate1207);
                    cr=columnReference();

                    state._fsp--;

                    pushFollow(FOLLOW_literal_in_quantifiedComparisonPredicate1211);
                    l=literal();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    unsupEx("Multivalue ANY not supported yet.");

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:661:3: ^( NOTEQUAL ANY cr= columnReference l= literal )
                    {
                    match(input,NOTEQUAL,FOLLOW_NOTEQUAL_in_quantifiedComparisonPredicate1225); 

                    match(input, Token.DOWN, null); 
                    match(input,ANY,FOLLOW_ANY_in_quantifiedComparisonPredicate1227); 
                    pushFollow(FOLLOW_columnReference_in_quantifiedComparisonPredicate1231);
                    cr=columnReference();

                    state._fsp--;

                    pushFollow(FOLLOW_literal_in_quantifiedComparisonPredicate1235);
                    l=literal();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    unsupEx("Multivalue ANY not supported yet.");

                    }
                    break;
                case 3 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:664:3: ^( LESS ANY cr= columnReference l= literal )
                    {
                    match(input,LESS,FOLLOW_LESS_in_quantifiedComparisonPredicate1249); 

                    match(input, Token.DOWN, null); 
                    match(input,ANY,FOLLOW_ANY_in_quantifiedComparisonPredicate1251); 
                    pushFollow(FOLLOW_columnReference_in_quantifiedComparisonPredicate1255);
                    cr=columnReference();

                    state._fsp--;

                    pushFollow(FOLLOW_literal_in_quantifiedComparisonPredicate1259);
                    l=literal();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    unsupEx("Multivalue ANY not supported yet.");

                    }
                    break;
                case 4 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:667:3: ^( MORE ANY cr= columnReference l= literal )
                    {
                    match(input,MORE,FOLLOW_MORE_in_quantifiedComparisonPredicate1273); 

                    match(input, Token.DOWN, null); 
                    match(input,ANY,FOLLOW_ANY_in_quantifiedComparisonPredicate1275); 
                    pushFollow(FOLLOW_columnReference_in_quantifiedComparisonPredicate1279);
                    cr=columnReference();

                    state._fsp--;

                    pushFollow(FOLLOW_literal_in_quantifiedComparisonPredicate1283);
                    l=literal();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    unsupEx("Multivalue ANY not supported yet.");

                    }
                    break;
                case 5 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:670:3: ^( MOREEQUAL ANY cr= columnReference l= literal )
                    {
                    match(input,MOREEQUAL,FOLLOW_MOREEQUAL_in_quantifiedComparisonPredicate1297); 

                    match(input, Token.DOWN, null); 
                    match(input,ANY,FOLLOW_ANY_in_quantifiedComparisonPredicate1299); 
                    pushFollow(FOLLOW_columnReference_in_quantifiedComparisonPredicate1303);
                    cr=columnReference();

                    state._fsp--;

                    pushFollow(FOLLOW_literal_in_quantifiedComparisonPredicate1307);
                    l=literal();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    unsupEx("Multivalue ANY not supported yet.");

                    }
                    break;
                case 6 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:673:3: ^( LESSEQUAL ANY cr= columnReference l= literal )
                    {
                    match(input,LESSEQUAL,FOLLOW_LESSEQUAL_in_quantifiedComparisonPredicate1321); 

                    match(input, Token.DOWN, null); 
                    match(input,ANY,FOLLOW_ANY_in_quantifiedComparisonPredicate1323); 
                    pushFollow(FOLLOW_columnReference_in_quantifiedComparisonPredicate1327);
                    cr=columnReference();

                    state._fsp--;

                    pushFollow(FOLLOW_literal_in_quantifiedComparisonPredicate1331);
                    l=literal();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    unsupEx("Multivalue ANY not supported yet.");

                    }
                    break;

            }
        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "quantifiedComparisonPredicate"


    // $ANTLR start "inPredicate"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:680:1: inPredicate returns [Constraint res] : ^( IN ( NOT )? c= columnReference l= literal (sl= literal )* ) ;
    public final Constraint inPredicate() throws RecognitionException {
        Constraint res = null;

        PropertyValue c = null;

        Literal l = null;

        Literal sl = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:681:3: ( ^( IN ( NOT )? c= columnReference l= literal (sl= literal )* ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:682:3: ^( IN ( NOT )? c= columnReference l= literal (sl= literal )* )
            {
             
            		  PropertyValue pv = null;
            		  boolean isNot = false;
            		  Constraint cons = null;  
            		
            match(input,IN,FOLLOW_IN_in_inPredicate1371); 

            match(input, Token.DOWN, null); 
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:689:5: ( NOT )?
            int alt19=2;
            switch ( input.LA(1) ) {
                case NOT:
                    {
                    alt19=1;
                    }
                    break;
            }

            switch (alt19) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:690:7: NOT
                    {
                    match(input,NOT,FOLLOW_NOT_in_inPredicate1385); 
                    isNot=true;

                    }
                    break;

            }

            pushFollow(FOLLOW_columnReference_in_inPredicate1402);
            c=columnReference();

            state._fsp--;

            pv=c;
            pushFollow(FOLLOW_literal_in_inPredicate1408);
            l=literal();

            state._fsp--;

            cons = new Comparison(pv, ((isNot)?Operator.NOT_EQUAL_TO:Operator.EQUAL_TO), l);
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:693:5: (sl= literal )*
            loop20:
            do {
                int alt20=2;
                switch ( input.LA(1) ) {
                case NUMERIC_LITERAL:
                case STRING_LITERAL:
                case TRUE:
                case FALSE:
                case TIMESTAMP:
                    {
                    alt20=1;
                    }
                    break;

                }

                switch (alt20) {
            	case 1 :
            	    // org/xcmis/search/parser/CMISSQLTreeWalker.g:694:7: sl= literal
            	    {
            	    pushFollow(FOLLOW_literal_in_inPredicate1426);
            	    sl=literal();

            	    state._fsp--;


            	    		if(isNot){
            	    		  cons = new And(cons, new Comparison(pv, Operator.NOT_EQUAL_TO, sl));
            	    		}else{
            	    		  cons = new Or(cons, new Comparison(pv, Operator.EQUAL_TO, sl));
            	    		}
            	    		

            	    }
            	    break;

            	default :
            	    break loop20;
                }
            } while (true);


            		  res = cons;
            		

            match(input, Token.UP, null); 

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "inPredicate"


    // $ANTLR start "quantifiedInPredicate"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:712:1: quantifiedInPredicate returns [Constraint res] : ^( IN ANY ( NOT )? columnReference ( literal )+ ) ;
    public final Constraint quantifiedInPredicate() throws RecognitionException {
        Constraint res = null;

        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:713:3: ( ^( IN ANY ( NOT )? columnReference ( literal )+ ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:714:3: ^( IN ANY ( NOT )? columnReference ( literal )+ )
            {
            match(input,IN,FOLLOW_IN_in_quantifiedInPredicate1473); 

            match(input, Token.DOWN, null); 
            match(input,ANY,FOLLOW_ANY_in_quantifiedInPredicate1475); 
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:714:12: ( NOT )?
            int alt21=2;
            switch ( input.LA(1) ) {
                case NOT:
                    {
                    alt21=1;
                    }
                    break;
            }

            switch (alt21) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:714:12: NOT
                    {
                    match(input,NOT,FOLLOW_NOT_in_quantifiedInPredicate1477); 

                    }
                    break;

            }

            pushFollow(FOLLOW_columnReference_in_quantifiedInPredicate1480);
            columnReference();

            state._fsp--;

            // org/xcmis/search/parser/CMISSQLTreeWalker.g:714:33: ( literal )+
            int cnt22=0;
            loop22:
            do {
                int alt22=2;
                switch ( input.LA(1) ) {
                case NUMERIC_LITERAL:
                case STRING_LITERAL:
                case TRUE:
                case FALSE:
                case TIMESTAMP:
                    {
                    alt22=1;
                    }
                    break;

                }

                switch (alt22) {
            	case 1 :
            	    // org/xcmis/search/parser/CMISSQLTreeWalker.g:714:33: literal
            	    {
            	    pushFollow(FOLLOW_literal_in_quantifiedInPredicate1482);
            	    literal();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    if ( cnt22 >= 1 ) break loop22;
                        EarlyExitException eee =
                            new EarlyExitException(22, input);
                        throw eee;
                }
                cnt22++;
            } while (true);


            match(input, Token.UP, null); 

            	res=null;
            	unsupEx("ANY IN not supported yet.");
            	

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "quantifiedInPredicate"


    // $ANTLR start "likePredicate"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:724:1: likePredicate returns [Constraint res] : ^( LIKE cr= columnReference l= STRING_LITERAL ) ;
    public final Constraint likePredicate() throws RecognitionException {
        Constraint res = null;

        CommonTree l=null;
        PropertyValue cr = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:725:3: ( ^( LIKE cr= columnReference l= STRING_LITERAL ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:726:3: ^( LIKE cr= columnReference l= STRING_LITERAL )
            {
            match(input,LIKE,FOLLOW_LIKE_in_likePredicate1514); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_columnReference_in_likePredicate1518);
            cr=columnReference();

            state._fsp--;

            l=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_likePredicate1522); 

            match(input, Token.UP, null); 

            	String val = l.getText();
            	val = processLIKELiteral(val);
            	res=new Comparison(cr, Operator.LIKE, new Literal(val));
            	

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "likePredicate"


    // $ANTLR start "nullPredicate"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:738:1: nullPredicate returns [Constraint res] : ( ^( IS_NULL (s= qualifier )? p= propertyName ) | ^( IS_NOT_NULL (s= qualifier )? p= propertyName ) ) ;
    public final Constraint nullPredicate() throws RecognitionException {
        Constraint res = null;

        SelectorName s = null;

        String p = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:739:3: ( ( ^( IS_NULL (s= qualifier )? p= propertyName ) | ^( IS_NOT_NULL (s= qualifier )? p= propertyName ) ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:740:3: ( ^( IS_NULL (s= qualifier )? p= propertyName ) | ^( IS_NOT_NULL (s= qualifier )? p= propertyName ) )
            {

            	  SelectorName selName=null;
            	
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:743:3: ( ^( IS_NULL (s= qualifier )? p= propertyName ) | ^( IS_NOT_NULL (s= qualifier )? p= propertyName ) )
            int alt25=2;
            switch ( input.LA(1) ) {
            case IS_NULL:
                {
                alt25=1;
                }
                break;
            case IS_NOT_NULL:
                {
                alt25=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 25, 0, input);

                throw nvae;
            }

            switch (alt25) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:744:5: ^( IS_NULL (s= qualifier )? p= propertyName )
                    {
                    match(input,IS_NULL,FOLLOW_IS_NULL_in_nullPredicate1571); 

                    match(input, Token.DOWN, null); 
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:746:7: (s= qualifier )?
                    int alt23=2;
                    switch ( input.LA(1) ) {
                        case QUALIFIER:
                            {
                            alt23=1;
                            }
                            break;
                    }

                    switch (alt23) {
                        case 1 :
                            // org/xcmis/search/parser/CMISSQLTreeWalker.g:747:9: s= qualifier
                            {
                            pushFollow(FOLLOW_qualifier_in_nullPredicate1591);
                            s=qualifier();

                            state._fsp--;

                            selName=s;

                            }
                            break;

                    }

                    pushFollow(FOLLOW_propertyName_in_nullPredicate1612);
                    p=propertyName();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    		
                    		if(selName!=null){
                    		  selName = getSelectorName(selName);
                    		}else{
                    		  selName = getDefaultSelectorName();
                    		  if(selName == null)
                    		    throw new TreeWalkerException("There is more than one table. Use selector or table name. IS NULL " + p);
                    		}
                    		res = new Not(new PropertyExistence(selName,p));
                    		

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:763:5: ^( IS_NOT_NULL (s= qualifier )? p= propertyName )
                    {
                    match(input,IS_NOT_NULL,FOLLOW_IS_NOT_NULL_in_nullPredicate1645); 

                    match(input, Token.DOWN, null); 
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:765:7: (s= qualifier )?
                    int alt24=2;
                    switch ( input.LA(1) ) {
                        case QUALIFIER:
                            {
                            alt24=1;
                            }
                            break;
                    }

                    switch (alt24) {
                        case 1 :
                            // org/xcmis/search/parser/CMISSQLTreeWalker.g:766:9: s= qualifier
                            {
                            pushFollow(FOLLOW_qualifier_in_nullPredicate1665);
                            s=qualifier();

                            state._fsp--;

                            selName=s;

                            }
                            break;

                    }

                    pushFollow(FOLLOW_propertyName_in_nullPredicate1686);
                    p=propertyName();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    		if(selName!=null){
                    		  selName = getSelectorName(selName);
                    		}else{
                    		  selName = getDefaultSelectorName();
                    		}
                    		res = new PropertyExistence(selName,p);
                    		

                    }
                    break;

            }


            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "nullPredicate"


    // $ANTLR start "fulltextsearch"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:785:1: fulltextsearch returns [Constraint res] : ^( CONTAINS (q= qualifier )? ( (fe= FULLTEXT_EXPRESSION ) | (sl= STRING_LITERAL ) ) ) ;
    public final Constraint fulltextsearch() throws RecognitionException {
        Constraint res = null;

        CommonTree fe=null;
        CommonTree sl=null;
        SelectorName q = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:786:3: ( ^( CONTAINS (q= qualifier )? ( (fe= FULLTEXT_EXPRESSION ) | (sl= STRING_LITERAL ) ) ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:787:3: ^( CONTAINS (q= qualifier )? ( (fe= FULLTEXT_EXPRESSION ) | (sl= STRING_LITERAL ) ) )
            {

            		SelectorName selName=null;
            		String expr = null;
            		
            match(input,CONTAINS,FOLLOW_CONTAINS_in_fulltextsearch1739); 

            match(input, Token.DOWN, null); 
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:793:5: (q= qualifier )?
            int alt26=2;
            switch ( input.LA(1) ) {
                case QUALIFIER:
                    {
                    alt26=1;
                    }
                    break;
            }

            switch (alt26) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:794:7: q= qualifier
                    {
                    pushFollow(FOLLOW_qualifier_in_fulltextsearch1755);
                    q=qualifier();

                    state._fsp--;

                    selName=q;

                    }
                    break;

            }

            // org/xcmis/search/parser/CMISSQLTreeWalker.g:796:5: ( (fe= FULLTEXT_EXPRESSION ) | (sl= STRING_LITERAL ) )
            int alt27=2;
            switch ( input.LA(1) ) {
            case FULLTEXT_EXPRESSION:
                {
                alt27=1;
                }
                break;
            case STRING_LITERAL:
                {
                alt27=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 27, 0, input);

                throw nvae;
            }

            switch (alt27) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:797:7: (fe= FULLTEXT_EXPRESSION )
                    {
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:797:7: (fe= FULLTEXT_EXPRESSION )
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:798:9: fe= FULLTEXT_EXPRESSION
                    {
                    fe=(CommonTree)match(input,FULLTEXT_EXPRESSION,FOLLOW_FULLTEXT_EXPRESSION_in_fulltextsearch1790); 
                    expr = processFulltextLiteral(fe.getText());

                    }


                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:801:7: (sl= STRING_LITERAL )
                    {
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:801:7: (sl= STRING_LITERAL )
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:802:9: sl= STRING_LITERAL
                    {
                    sl=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_fulltextsearch1828); 
                    expr = processLiteral(sl.getText());

                    }


                    }
                    break;

            }


            match(input, Token.UP, null); 

            		
            		//TODO contains may search by all nodes
            		if(selName!=null){
            		  selName = getSelectorName(selName);
            		}else{
            		  selName = getDefaultSelectorName();
            		  if(selName == null)
              		    throw new TreeWalkerException("There is more than one table. Use selector or table name. CONTAINS..");
            		}
            		//String expr = processFulltextLiteral(sl.getText());
            		
            		res = new FullTextSearch(selName, null , expr);
            		

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "fulltextsearch"


    // $ANTLR start "inFolder"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:826:1: inFolder returns [Constraint res] : ^( IN_FOLDER (q= qualifier )? STRING_LITERAL ) ;
    public final Constraint inFolder() throws RecognitionException {
        Constraint res = null;

        CommonTree STRING_LITERAL1=null;
        SelectorName q = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:827:3: ( ^( IN_FOLDER (q= qualifier )? STRING_LITERAL ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:828:3: ^( IN_FOLDER (q= qualifier )? STRING_LITERAL )
            {
            SelectorName selName = null;
            match(input,IN_FOLDER,FOLLOW_IN_FOLDER_in_inFolder1889); 

            match(input, Token.DOWN, null); 
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:831:5: (q= qualifier )?
            int alt28=2;
            switch ( input.LA(1) ) {
                case QUALIFIER:
                    {
                    alt28=1;
                    }
                    break;
            }

            switch (alt28) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:832:7: q= qualifier
                    {
                    pushFollow(FOLLOW_qualifier_in_inFolder1905);
                    q=qualifier();

                    state._fsp--;

                    selName=q;

                    }
                    break;

            }

            STRING_LITERAL1=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_inFolder1920); 

            match(input, Token.UP, null); 

            		
            		//strip quotes
            		String uuid = STRING_LITERAL1.getText();
            		//uuidbasd path  3.4.4.1.2
            		StringBuilder builder = new StringBuilder();
            		builder.append('[');
            		builder.append(uuid.substring(1, uuid.length()-1));
            		builder.append(']');
            		
            		if(selName!=null){
            		  selName = getSelectorName(selName);
            		}else{
            		  selName = getDefaultSelectorName();
            		  if(selName == null)
            		    throw new TreeWalkerException("There is more than one table. Use selector or table name. IN_FOLDER(..");
            		}
                            res = new ChildNode(selName, builder.toString());
            		

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "inFolder"


    // $ANTLR start "inTree"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:861:1: inTree returns [Constraint res] : ^( IN_TREE (q= qualifier )? STRING_LITERAL ) ;
    public final Constraint inTree() throws RecognitionException {
        Constraint res = null;

        CommonTree STRING_LITERAL2=null;
        SelectorName q = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:862:3: ( ^( IN_TREE (q= qualifier )? STRING_LITERAL ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:863:3: ^( IN_TREE (q= qualifier )? STRING_LITERAL )
            {
            SelectorName selName = null;
            match(input,IN_TREE,FOLLOW_IN_TREE_in_inTree1965); 

            match(input, Token.DOWN, null); 
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:866:5: (q= qualifier )?
            int alt29=2;
            switch ( input.LA(1) ) {
                case QUALIFIER:
                    {
                    alt29=1;
                    }
                    break;
            }

            switch (alt29) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:867:7: q= qualifier
                    {
                    pushFollow(FOLLOW_qualifier_in_inTree1981);
                    q=qualifier();

                    state._fsp--;

                    selName=q;

                    }
                    break;

            }

            STRING_LITERAL2=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_inTree1996); 

            match(input, Token.UP, null); 

            		//strip quotes
            		String uuid = STRING_LITERAL2.getText();
            		
            		    //uuidbasd path  3.4.4.1.2
                StringBuilder builder = new StringBuilder();
                builder.append('[');
                builder.append(uuid.substring(1, uuid.length()-1));
                builder.append(']');
            		
            		
            		if(selName!=null){
            		  selName = getSelectorName(selName);
            		}else{
            		  selName = getDefaultSelectorName();
            		  if(selName==null)
            		    throw new TreeWalkerException("There is more than one table. Use selector or table name. IN_TREE..");
            		}
                            res = new DescendantNode(selName, builder.toString());
            		

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "inTree"


    // $ANTLR start "valueExpression"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:898:1: valueExpression returns [DynamicOperand res] : cr= columnReference ;
    public final DynamicOperand valueExpression() throws RecognitionException {
        DynamicOperand res = null;

        PropertyValue cr = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:899:3: (cr= columnReference )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:900:3: cr= columnReference
            {
            pushFollow(FOLLOW_columnReference_in_valueExpression2034);
            cr=columnReference();

            state._fsp--;

            res = cr;

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "valueExpression"


    // $ANTLR start "columnReference"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:916:1: columnReference returns [PropertyValue res] : (p= propertyName | s= qualifier p= propertyName );
    public final PropertyValue columnReference() throws RecognitionException {
        PropertyValue res = null;

        String p = null;

        SelectorName s = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:917:3: (p= propertyName | s= qualifier p= propertyName )
            int alt30=2;
            switch ( input.LA(1) ) {
            case PROPERTY_NAME:
                {
                alt30=1;
                }
                break;
            case QUALIFIER:
                {
                alt30=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 30, 0, input);

                throw nvae;
            }

            switch (alt30) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:918:3: p= propertyName
                    {
                    pushFollow(FOLLOW_propertyName_in_columnReference2087);
                    p=propertyName();

                    state._fsp--;


                    		SelectorName selName = getDefaultSelectorName();
                    		if(selName == null)
                    		  throw new TreeWalkerException("There is more than one table. Use selector or table name.");
                    		res=new PropertyValue(selName,p);
                    		

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:924:5: s= qualifier p= propertyName
                    {
                    pushFollow(FOLLOW_qualifier_in_columnReference2097);
                    s=qualifier();

                    state._fsp--;

                    pushFollow(FOLLOW_propertyName_in_columnReference2101);
                    p=propertyName();

                    state._fsp--;


                    		SelectorName selName = getSelectorName(s);
                    		res=new PropertyValue(selName , p);
                    		

                    }
                    break;

            }
        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "columnReference"


    // $ANTLR start "orderings"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:935:1: orderings returns [List<Ordering> res] : ^( ORDERINGS (o= ordering )+ ) ;
    public final List<Ordering> orderings() throws RecognitionException {
        List<Ordering> res = null;

        Ordering o = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:936:3: ( ^( ORDERINGS (o= ordering )+ ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:937:3: ^( ORDERINGS (o= ordering )+ )
            {
             List<Ordering> l = new ArrayList<Ordering>();
            match(input,ORDERINGS,FOLLOW_ORDERINGS_in_orderings2140); 

            match(input, Token.DOWN, null); 
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:940:5: (o= ordering )+
            int cnt31=0;
            loop31:
            do {
                int alt31=2;
                switch ( input.LA(1) ) {
                case ASC:
                case DESC:
                    {
                    alt31=1;
                    }
                    break;

                }

                switch (alt31) {
            	case 1 :
            	    // org/xcmis/search/parser/CMISSQLTreeWalker.g:941:7: o= ordering
            	    {
            	    pushFollow(FOLLOW_ordering_in_orderings2156);
            	    o=ordering();

            	    state._fsp--;

            	    l.add(o);

            	    }
            	    break;

            	default :
            	    if ( cnt31 >= 1 ) break loop31;
                        EarlyExitException eee =
                            new EarlyExitException(31, input);
                        throw eee;
                }
                cnt31++;
            } while (true);


            match(input, Token.UP, null); 

            		res = l;
            		

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "orderings"


    // $ANTLR start "ordering"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:952:1: ordering returns [Ordering res] : (pv= propertyval | of= orderfunc );
    public final Ordering ordering() throws RecognitionException {
        Ordering res = null;

        Ordering pv = null;

        Ordering of = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:953:3: (pv= propertyval | of= orderfunc )
            int alt32=2;
            switch ( input.LA(1) ) {
            case ASC:
                {
                switch ( input.LA(2) ) {
                case DOWN:
                    {
                    switch ( input.LA(3) ) {
                    case SCORE:
                        {
                        alt32=2;
                        }
                        break;
                    case COLUMN_NAME:
                        {
                        alt32=1;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 32, 3, input);

                        throw nvae;
                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 32, 1, input);

                    throw nvae;
                }

                }
                break;
            case DESC:
                {
                switch ( input.LA(2) ) {
                case DOWN:
                    {
                    switch ( input.LA(3) ) {
                    case SCORE:
                        {
                        alt32=2;
                        }
                        break;
                    case COLUMN_NAME:
                        {
                        alt32=1;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 32, 4, input);

                        throw nvae;
                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 32, 2, input);

                    throw nvae;
                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 32, 0, input);

                throw nvae;
            }

            switch (alt32) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:954:3: pv= propertyval
                    {
                    pushFollow(FOLLOW_propertyval_in_ordering2201);
                    pv=propertyval();

                    state._fsp--;


                    		res = pv;
                    		

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:957:5: of= orderfunc
                    {
                    pushFollow(FOLLOW_orderfunc_in_ordering2211);
                    of=orderfunc();

                    state._fsp--;


                    		res = of;
                    		

                    }
                    break;

            }
        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "ordering"


    // $ANTLR start "propertyval"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:965:1: propertyval returns [Ordering res] : ( ^( ASC n= columnName ) | ^( DESC n= columnName ) );
    public final Ordering propertyval() throws RecognitionException {
        Ordering res = null;

        String n = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:966:3: ( ^( ASC n= columnName ) | ^( DESC n= columnName ) )
            int alt33=2;
            switch ( input.LA(1) ) {
            case ASC:
                {
                alt33=1;
                }
                break;
            case DESC:
                {
                alt33=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 33, 0, input);

                throw nvae;
            }

            switch (alt33) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:967:3: ^( ASC n= columnName )
                    {
                    match(input,ASC,FOLLOW_ASC_in_propertyval2239); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_columnName_in_propertyval2243);
                    n=columnName();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    		SelectorName selName = getDefaultSelectorName();
                    		if(selName == null)
                    		  //throw new TreeWalkerException("There is more than one table. Use selector or table name.");
                    		  unsupEx("Ordering with Joined virtual tables not supported yet.");
                    		  
                    		res = new Ordering(new PropertyValue(selName, n), Order.ASCENDING);
                    		

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:977:3: ^( DESC n= columnName )
                    {
                    match(input,DESC,FOLLOW_DESC_in_propertyval2257); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_columnName_in_propertyval2261);
                    n=columnName();

                    state._fsp--;


                    match(input, Token.UP, null); 

                            	SelectorName selName = getDefaultSelectorName();
                    		if(selName == null)
                    		  //throw new TreeWalkerException("There is more than one table. Use selector or table name.");
                    		  unsupEx("Ordering with Joined virtual tables not supported yet.");
                    		  
                    		res = new Ordering(new PropertyValue(selName, n), Order.DESCENDING);
                    		

                    }
                    break;

            }
        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "propertyval"


    // $ANTLR start "orderfunc"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:991:1: orderfunc returns [Ordering res] : ( ^( ASC SCORE ) | ^( DESC SCORE ) );
    public final Ordering orderfunc() throws RecognitionException {
        Ordering res = null;

        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:992:3: ( ^( ASC SCORE ) | ^( DESC SCORE ) )
            int alt34=2;
            switch ( input.LA(1) ) {
            case ASC:
                {
                alt34=1;
                }
                break;
            case DESC:
                {
                alt34=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 34, 0, input);

                throw nvae;
            }

            switch (alt34) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:993:3: ^( ASC SCORE )
                    {
                    match(input,ASC,FOLLOW_ASC_in_orderfunc2292); 

                    match(input, Token.DOWN, null); 
                    match(input,SCORE,FOLLOW_SCORE_in_orderfunc2294); 

                    match(input, Token.UP, null); 

                    		SelectorName selName = getDefaultSelectorName();
                    		if(selName == null)
                    		  //throw new TreeWalkerException("There is more than one table. Use selector or table name.");
                    		  unsupEx("Ordering with Joined virtual tables not supported yet.");
                    		  
                    		res = new Ordering(new FullTextSearchScore(selName), Order.ASCENDING);
                    		

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1003:3: ^( DESC SCORE )
                    {
                    match(input,DESC,FOLLOW_DESC_in_orderfunc2308); 

                    match(input, Token.DOWN, null); 
                    match(input,SCORE,FOLLOW_SCORE_in_orderfunc2310); 

                    match(input, Token.UP, null); 

                            	SelectorName selName = getDefaultSelectorName();
                    		if(selName == null)
                    		  //throw new TreeWalkerException("There is more than one table. Use selector or table name.");
                    		  unsupEx("Ordering with Joined virtual tables not supported yet.");
                    		  
                    		res = new Ordering(new FullTextSearchScore(selName), Order.DESCENDING);
                    		

                    }
                    break;

            }
        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "orderfunc"


    // $ANTLR start "literal"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1017:1: literal returns [Literal res] : (sl= stringLiteral | nl= numericLiteral | bl= booleanLiteral | dl= dateTimeLiteral );
    public final Literal literal() throws RecognitionException {
        Literal res = null;

        Literal sl = null;

        Literal nl = null;

        Literal bl = null;

        Literal dl = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1018:3: (sl= stringLiteral | nl= numericLiteral | bl= booleanLiteral | dl= dateTimeLiteral )
            int alt35=4;
            switch ( input.LA(1) ) {
            case STRING_LITERAL:
                {
                alt35=1;
                }
                break;
            case NUMERIC_LITERAL:
                {
                alt35=2;
                }
                break;
            case TRUE:
            case FALSE:
                {
                alt35=3;
                }
                break;
            case TIMESTAMP:
                {
                alt35=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 35, 0, input);

                throw nvae;
            }

            switch (alt35) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1019:3: sl= stringLiteral
                    {
                    pushFollow(FOLLOW_stringLiteral_in_literal2342);
                    sl=stringLiteral();

                    state._fsp--;

                    res=sl;

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1020:5: nl= numericLiteral
                    {
                    pushFollow(FOLLOW_numericLiteral_in_literal2352);
                    nl=numericLiteral();

                    state._fsp--;

                    res=nl;

                    }
                    break;
                case 3 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1021:5: bl= booleanLiteral
                    {
                    pushFollow(FOLLOW_booleanLiteral_in_literal2362);
                    bl=booleanLiteral();

                    state._fsp--;

                    res=bl;

                    }
                    break;
                case 4 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1022:5: dl= dateTimeLiteral
                    {
                    pushFollow(FOLLOW_dateTimeLiteral_in_literal2372);
                    dl=dateTimeLiteral();

                    state._fsp--;

                    res =dl;

                    }
                    break;

            }
        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "literal"


    // $ANTLR start "stringLiteral"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1028:1: stringLiteral returns [Literal res] : l= STRING_LITERAL ;
    public final Literal stringLiteral() throws RecognitionException {
        Literal res = null;

        CommonTree l=null;

        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1029:3: (l= STRING_LITERAL )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1030:3: l= STRING_LITERAL
            {
            l=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_stringLiteral2401); 

            		String val = l.getText();
            		val = processLiteral(val);
            		//val = removeQuotes(val,'\'');
            		res = new Literal(val);
            		

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "stringLiteral"


    // $ANTLR start "numericLiteral"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1041:1: numericLiteral returns [Literal res] : l= NUMERIC_LITERAL ;
    public final Literal numericLiteral() throws RecognitionException {
        Literal res = null;

        CommonTree l=null;

        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1042:3: (l= NUMERIC_LITERAL )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1043:3: l= NUMERIC_LITERAL
            {
            l=(CommonTree)match(input,NUMERIC_LITERAL,FOLLOW_NUMERIC_LITERAL_in_numericLiteral2430); 

            		String val = l.getText();
            		val = removeQuotes(val,'\'');
            		res = new Literal(Double.parseDouble(val));
            		

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "numericLiteral"


    // $ANTLR start "booleanLiteral"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1053:1: booleanLiteral returns [Literal res] : ( TRUE | FALSE );
    public final Literal booleanLiteral() throws RecognitionException {
        Literal res = null;

        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1054:3: ( TRUE | FALSE )
            int alt36=2;
            switch ( input.LA(1) ) {
            case TRUE:
                {
                alt36=1;
                }
                break;
            case FALSE:
                {
                alt36=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 36, 0, input);

                throw nvae;
            }

            switch (alt36) {
                case 1 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1055:3: TRUE
                    {
                    match(input,TRUE,FOLLOW_TRUE_in_booleanLiteral2457); 
                    res = new Literal(new Boolean(true));

                    }
                    break;
                case 2 :
                    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1056:5: FALSE
                    {
                    match(input,FALSE,FOLLOW_FALSE_in_booleanLiteral2465); 
                    res = new Literal(new Boolean(false));

                    }
                    break;

            }
        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "booleanLiteral"


    // $ANTLR start "dateTimeLiteral"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1062:1: dateTimeLiteral returns [Literal res] : TIMESTAMP sl= STRING_LITERAL ;
    public final Literal dateTimeLiteral() throws RecognitionException {
        Literal res = null;

        CommonTree sl=null;

        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1063:3: ( TIMESTAMP sl= STRING_LITERAL )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1064:3: TIMESTAMP sl= STRING_LITERAL
            {
            match(input,TIMESTAMP,FOLLOW_TIMESTAMP_in_dateTimeLiteral2492); 
            sl=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_dateTimeLiteral2496); 

            		String date = processLiteral(sl.getText());
            //		{res =  new Literal(ISO8601.parse(date));}
                  {res =  new Literal(CmisUtils.parseCalendar(date));}
            	

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "dateTimeLiteral"


    // $ANTLR start "qualifier"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1074:1: qualifier returns [SelectorName res] : ^( QUALIFIER i= id ) ;
    public final SelectorName qualifier() throws RecognitionException {
        SelectorName res = null;

        String i = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1075:3: ( ^( QUALIFIER i= id ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1076:3: ^( QUALIFIER i= id )
            {
            match(input,QUALIFIER,FOLLOW_QUALIFIER_in_qualifier2524); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_id_in_qualifier2528);
            i=id();

            state._fsp--;


            match(input, Token.UP, null); 
            res=new SelectorName(i);

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "qualifier"


    // $ANTLR start "tableName"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1083:1: tableName returns [SelectorName res] : ^( TABLE_NAME i= id ) ;
    public final SelectorName tableName() throws RecognitionException {
        SelectorName res = null;

        String i = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1084:3: ( ^( TABLE_NAME i= id ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1085:3: ^( TABLE_NAME i= id )
            {
            match(input,TABLE_NAME,FOLLOW_TABLE_NAME_in_tableName2559); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_id_in_tableName2563);
            i=id();

            state._fsp--;


            match(input, Token.UP, null); 
            res=new SelectorName(i);

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "tableName"


    // $ANTLR start "correlationName"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1092:1: correlationName returns [SelectorName res] : ^( CORRELATION_NAME i= id ) ;
    public final SelectorName correlationName() throws RecognitionException {
        SelectorName res = null;

        String i = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1093:3: ( ^( CORRELATION_NAME i= id ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1094:3: ^( CORRELATION_NAME i= id )
            {
            match(input,CORRELATION_NAME,FOLLOW_CORRELATION_NAME_in_correlationName2594); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_id_in_correlationName2598);
            i=id();

            state._fsp--;


            match(input, Token.UP, null); 
            res=new SelectorName(i);

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "correlationName"


    // $ANTLR start "propertyName"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1101:1: propertyName returns [String res] : ^( PROPERTY_NAME i= id ) ;
    public final String propertyName() throws RecognitionException {
        String res = null;

        String i = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1102:3: ( ^( PROPERTY_NAME i= id ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1103:3: ^( PROPERTY_NAME i= id )
            {
            match(input,PROPERTY_NAME,FOLLOW_PROPERTY_NAME_in_propertyName2629); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_id_in_propertyName2633);
            i=id();

            state._fsp--;


            match(input, Token.UP, null); 
            res=i;

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "propertyName"


    // $ANTLR start "columnName"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1110:1: columnName returns [String res] : ^( COLUMN_NAME i= id ) ;
    public final String columnName() throws RecognitionException {
        String res = null;

        String i = null;


        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1111:3: ( ^( COLUMN_NAME i= id ) )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1112:3: ^( COLUMN_NAME i= id )
            {
            match(input,COLUMN_NAME,FOLLOW_COLUMN_NAME_in_columnName2664); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_id_in_columnName2668);
            i=id();

            state._fsp--;


            match(input, Token.UP, null); 
            res=i;

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "columnName"


    // $ANTLR start "id"
    // org/xcmis/search/parser/CMISSQLTreeWalker.g:1119:1: id returns [String res] : i= IDENTIFIER ;
    public final String id() throws RecognitionException {
        String res = null;

        CommonTree i=null;

        try {
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1120:3: (i= IDENTIFIER )
            // org/xcmis/search/parser/CMISSQLTreeWalker.g:1121:3: i= IDENTIFIER
            {
            i=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_id2700); 

            		String val = i.getText();
            		//res = removeQuotes(val,'"');
            		res = val;
            		

            }

        }
        catch (RecognitionException e) {

                      throw e;

        }
        finally {
        }
        return res;
    }
    // $ANTLR end "id"

    // Delegated rules


    protected DFA7 dfa7 = new DFA7(this);
    protected DFA16 dfa16 = new DFA16(this);
    static final String DFA7_eotS =
        "\12\uffff";
    static final String DFA7_eofS =
        "\12\uffff";
    static final String DFA7_minS =
        "\1\6\1\2\1\14\1\uffff\1\2\1\uffff\1\76\1\3\1\23\1\uffff";
    static final String DFA7_maxS =
        "\1\6\1\2\1\45\1\uffff\1\2\1\uffff\1\76\1\3\1\33\1\uffff";
    static final String DFA7_acceptS =
        "\3\uffff\1\3\1\uffff\1\2\3\uffff\1\1";
    static final String DFA7_specialS =
        "\12\uffff}>";
    static final String[] DFA7_transitionS = {
            "\1\1",
            "\1\2",
            "\1\4\6\uffff\1\5\21\uffff\1\3",
            "",
            "\1\6",
            "",
            "\1\7",
            "\1\10",
            "\1\5\7\uffff\1\11",
            ""
    };

    static final short[] DFA7_eot = DFA.unpackEncodedString(DFA7_eotS);
    static final short[] DFA7_eof = DFA.unpackEncodedString(DFA7_eofS);
    static final char[] DFA7_min = DFA.unpackEncodedStringToUnsignedChars(DFA7_minS);
    static final char[] DFA7_max = DFA.unpackEncodedStringToUnsignedChars(DFA7_maxS);
    static final short[] DFA7_accept = DFA.unpackEncodedString(DFA7_acceptS);
    static final short[] DFA7_special = DFA.unpackEncodedString(DFA7_specialS);
    static final short[][] DFA7_transition;

    static {
        int numStates = DFA7_transitionS.length;
        DFA7_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA7_transition[i] = DFA.unpackEncodedString(DFA7_transitionS[i]);
        }
    }

    class DFA7 extends DFA {

        public DFA7(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 7;
            this.eot = DFA7_eot;
            this.eof = DFA7_eof;
            this.min = DFA7_min;
            this.max = DFA7_max;
            this.accept = DFA7_accept;
            this.special = DFA7_special;
            this.transition = DFA7_transition;
        }
        public String getDescription() {
            return "437:1: column returns [Column res] : ( ^( COLUMN q= qualifier ALL ) | ^( COLUMN (q= qualifier )? (p= propertyName ) (cn= columnName )? ) | ( ^( COLUMN cf= columnFunction ) ) );";
        }
    }
    static final String DFA16_eotS =
        "\30\uffff";
    static final String DFA16_eofS =
        "\30\uffff";
    static final String DFA16_minS =
        "\1\21\7\2\5\uffff\7\14\4\uffff";
    static final String DFA16_maxS =
        "\1\73\7\2\5\uffff\7\56\4\uffff";
    static final String DFA16_acceptS =
        "\10\uffff\1\3\1\4\1\7\1\10\1\11\7\uffff\1\5\1\1\1\6\1\2";
    static final String DFA16_specialS =
        "\30\uffff}>";
    static final String[] DFA16_transitionS = {
            "\2\11\21\uffff\1\1\4\uffff\1\2\1\3\1\4\1\5\1\6\6\uffff\1\7\1"+
            "\10\2\uffff\1\12\1\uffff\1\13\1\14",
            "\1\15",
            "\1\16",
            "\1\17",
            "\1\20",
            "\1\21",
            "\1\22",
            "\1\23",
            "",
            "",
            "",
            "",
            "",
            "\1\25\6\uffff\1\25\32\uffff\1\24",
            "\1\25\6\uffff\1\25\32\uffff\1\24",
            "\1\25\6\uffff\1\25\32\uffff\1\24",
            "\1\25\6\uffff\1\25\32\uffff\1\24",
            "\1\25\6\uffff\1\25\32\uffff\1\24",
            "\1\25\6\uffff\1\25\32\uffff\1\24",
            "\1\27\6\uffff\1\27\24\uffff\1\27\5\uffff\1\26",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA16_eot = DFA.unpackEncodedString(DFA16_eotS);
    static final short[] DFA16_eof = DFA.unpackEncodedString(DFA16_eofS);
    static final char[] DFA16_min = DFA.unpackEncodedStringToUnsignedChars(DFA16_minS);
    static final char[] DFA16_max = DFA.unpackEncodedStringToUnsignedChars(DFA16_maxS);
    static final short[] DFA16_accept = DFA.unpackEncodedString(DFA16_acceptS);
    static final short[] DFA16_special = DFA.unpackEncodedString(DFA16_specialS);
    static final short[][] DFA16_transition;

    static {
        int numStates = DFA16_transitionS.length;
        DFA16_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA16_transition[i] = DFA.unpackEncodedString(DFA16_transitionS[i]);
        }
    }

    class DFA16 extends DFA {

        public DFA16(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 16;
            this.eot = DFA16_eot;
            this.eof = DFA16_eof;
            this.min = DFA16_min;
            this.max = DFA16_max;
            this.accept = DFA16_accept;
            this.special = DFA16_special;
            this.transition = DFA16_transition;
        }
        public String getDescription() {
            return "615:1: predicate returns [Constraint res] : (cp= comparisonPredicate | in= inPredicate | like= likePredicate | n= nullPredicate | qcp= quantifiedComparisonPredicate | qIn= quantifiedInPredicate | full= fulltextsearch | inF= inFolder | inT= inTree );";
        }
    }
 

    public static final BitSet FOLLOW_QUERY_in_query68 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_source_in_query72 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_columnList_in_query78 = new BitSet(new long[]{0x0000000000000188L});
    public static final BitSet FOLLOW_searchCondition_in_query96 = new BitSet(new long[]{0x0000000000000108L});
    public static final BitSet FOLLOW_orderings_in_query121 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_COLUMNS_in_columnList166 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALL_in_columnList168 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_COLUMNS_in_columnList189 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_column_in_columnList205 = new BitSet(new long[]{0x0000000000000048L});
    public static final BitSet FOLLOW_COLUMN_in_column246 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_qualifier_in_column250 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_ALL_in_column252 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_COLUMN_in_column273 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_qualifier_in_column289 = new BitSet(new long[]{0x0000000000080000L});
    public static final BitSet FOLLOW_propertyName_in_column314 = new BitSet(new long[]{0x0000000000100008L});
    public static final BitSet FOLLOW_columnName_in_column338 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_COLUMN_in_column371 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_columnFunction_in_column375 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SCORE_in_columnFunction411 = new BitSet(new long[]{0x0000000000100002L});
    public static final BitSet FOLLOW_columnName_in_columnFunction423 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_table_in_source474 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_JOIN_in_source496 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_jointype_in_source500 = new BitSet(new long[]{0x0000000000006000L});
    public static final BitSet FOLLOW_source_in_source504 = new BitSet(new long[]{0x0000000000006000L});
    public static final BitSet FOLLOW_source_in_source508 = new BitSet(new long[]{0x0000000000000808L});
    public static final BitSet FOLLOW_joincondition_in_source524 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INNER_in_jointype573 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LEFT_OUTER_in_jointype583 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_JOINCONDITION_in_joincondition618 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_qualifier_in_joincondition634 = new BitSet(new long[]{0x0000000000080000L});
    public static final BitSet FOLLOW_propertyName_in_joincondition651 = new BitSet(new long[]{0x0000000000081000L});
    public static final BitSet FOLLOW_qualifier_in_joincondition667 = new BitSet(new long[]{0x0000000000080000L});
    public static final BitSet FOLLOW_propertyName_in_joincondition684 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_TABLE_in_table728 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_tableName_in_table744 = new BitSet(new long[]{0x0000000000400008L});
    public static final BitSet FOLLOW_correlationName_in_table768 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CONSTRAINT_in_searchCondition812 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_constraint_in_searchCondition816 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_predicate_in_constraint848 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_constraint859 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_constraint_in_constraint863 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_OR_in_constraint877 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_constraint_in_constraint881 = new BitSet(new long[]{0x0D303FD000060000L});
    public static final BitSet FOLLOW_constraint_in_constraint885 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_AND_in_constraint899 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_constraint_in_constraint903 = new BitSet(new long[]{0x0D303FD000060000L});
    public static final BitSet FOLLOW_constraint_in_constraint907 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_comparisonPredicate_in_predicate939 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_inPredicate_in_predicate949 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_likePredicate_in_predicate959 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_nullPredicate_in_predicate969 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_quantifiedComparisonPredicate_in_predicate979 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_quantifiedInPredicate_in_predicate989 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_fulltextsearch_in_predicate999 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_inFolder_in_predicate1009 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_inTree_in_predicate1019 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EQUAL_in_comparisonPredicate1047 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_comparisonPredicate1051 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_comparisonPredicate1055 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOTEQUAL_in_comparisonPredicate1070 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_comparisonPredicate1074 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_comparisonPredicate1078 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LESS_in_comparisonPredicate1092 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_comparisonPredicate1096 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_comparisonPredicate1100 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LESSEQUAL_in_comparisonPredicate1115 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_comparisonPredicate1119 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_comparisonPredicate1123 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MORE_in_comparisonPredicate1137 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_comparisonPredicate1141 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_comparisonPredicate1145 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MOREEQUAL_in_comparisonPredicate1159 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_comparisonPredicate1163 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_comparisonPredicate1167 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EQUAL_in_quantifiedComparisonPredicate1201 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ANY_in_quantifiedComparisonPredicate1203 = new BitSet(new long[]{0x0000000000081000L});
    public static final BitSet FOLLOW_columnReference_in_quantifiedComparisonPredicate1207 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_quantifiedComparisonPredicate1211 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOTEQUAL_in_quantifiedComparisonPredicate1225 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ANY_in_quantifiedComparisonPredicate1227 = new BitSet(new long[]{0x0000000000081000L});
    public static final BitSet FOLLOW_columnReference_in_quantifiedComparisonPredicate1231 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_quantifiedComparisonPredicate1235 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LESS_in_quantifiedComparisonPredicate1249 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ANY_in_quantifiedComparisonPredicate1251 = new BitSet(new long[]{0x0000000000081000L});
    public static final BitSet FOLLOW_columnReference_in_quantifiedComparisonPredicate1255 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_quantifiedComparisonPredicate1259 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MORE_in_quantifiedComparisonPredicate1273 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ANY_in_quantifiedComparisonPredicate1275 = new BitSet(new long[]{0x0000000000081000L});
    public static final BitSet FOLLOW_columnReference_in_quantifiedComparisonPredicate1279 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_quantifiedComparisonPredicate1283 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MOREEQUAL_in_quantifiedComparisonPredicate1297 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ANY_in_quantifiedComparisonPredicate1299 = new BitSet(new long[]{0x0000000000081000L});
    public static final BitSet FOLLOW_columnReference_in_quantifiedComparisonPredicate1303 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_quantifiedComparisonPredicate1307 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LESSEQUAL_in_quantifiedComparisonPredicate1321 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ANY_in_quantifiedComparisonPredicate1323 = new BitSet(new long[]{0x0000000000081000L});
    public static final BitSet FOLLOW_columnReference_in_quantifiedComparisonPredicate1327 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_quantifiedComparisonPredicate1331 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IN_in_inPredicate1371 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NOT_in_inPredicate1385 = new BitSet(new long[]{0x0000000000081000L});
    public static final BitSet FOLLOW_columnReference_in_inPredicate1402 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_inPredicate1408 = new BitSet(new long[]{0x000F800000000008L});
    public static final BitSet FOLLOW_literal_in_inPredicate1426 = new BitSet(new long[]{0x000F800000000008L});
    public static final BitSet FOLLOW_IN_in_quantifiedInPredicate1473 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ANY_in_quantifiedInPredicate1475 = new BitSet(new long[]{0x0000010000081000L});
    public static final BitSet FOLLOW_NOT_in_quantifiedInPredicate1477 = new BitSet(new long[]{0x0000000000081000L});
    public static final BitSet FOLLOW_columnReference_in_quantifiedInPredicate1480 = new BitSet(new long[]{0x000F800000000000L});
    public static final BitSet FOLLOW_literal_in_quantifiedInPredicate1482 = new BitSet(new long[]{0x000F800000000008L});
    public static final BitSet FOLLOW_LIKE_in_likePredicate1514 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_columnReference_in_likePredicate1518 = new BitSet(new long[]{0x0001000000000000L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_likePredicate1522 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IS_NULL_in_nullPredicate1571 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_qualifier_in_nullPredicate1591 = new BitSet(new long[]{0x0000000000080000L});
    public static final BitSet FOLLOW_propertyName_in_nullPredicate1612 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IS_NOT_NULL_in_nullPredicate1645 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_qualifier_in_nullPredicate1665 = new BitSet(new long[]{0x0000000000080000L});
    public static final BitSet FOLLOW_propertyName_in_nullPredicate1686 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CONTAINS_in_fulltextsearch1739 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_qualifier_in_fulltextsearch1755 = new BitSet(new long[]{0x0201000000000000L});
    public static final BitSet FOLLOW_FULLTEXT_EXPRESSION_in_fulltextsearch1790 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_fulltextsearch1828 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IN_FOLDER_in_inFolder1889 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_qualifier_in_inFolder1905 = new BitSet(new long[]{0x0001000000000000L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_inFolder1920 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IN_TREE_in_inTree1965 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_qualifier_in_inTree1981 = new BitSet(new long[]{0x0001000000000000L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_inTree1996 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_columnReference_in_valueExpression2034 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_propertyName_in_columnReference2087 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_qualifier_in_columnReference2097 = new BitSet(new long[]{0x0000000000080000L});
    public static final BitSet FOLLOW_propertyName_in_columnReference2101 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ORDERINGS_in_orderings2140 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ordering_in_orderings2156 = new BitSet(new long[]{0x0000000000000608L});
    public static final BitSet FOLLOW_propertyval_in_ordering2201 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_orderfunc_in_ordering2211 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ASC_in_propertyval2239 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_columnName_in_propertyval2243 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DESC_in_propertyval2257 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_columnName_in_propertyval2261 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ASC_in_orderfunc2292 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_SCORE_in_orderfunc2294 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DESC_in_orderfunc2308 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_SCORE_in_orderfunc2310 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_stringLiteral_in_literal2342 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_numericLiteral_in_literal2352 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_booleanLiteral_in_literal2362 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dateTimeLiteral_in_literal2372 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_stringLiteral2401 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NUMERIC_LITERAL_in_numericLiteral2430 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TRUE_in_booleanLiteral2457 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FALSE_in_booleanLiteral2465 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TIMESTAMP_in_dateTimeLiteral2492 = new BitSet(new long[]{0x0001000000000000L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_dateTimeLiteral2496 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUALIFIER_in_qualifier2524 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_id_in_qualifier2528 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_TABLE_NAME_in_tableName2559 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_id_in_tableName2563 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CORRELATION_NAME_in_correlationName2594 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_id_in_correlationName2598 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PROPERTY_NAME_in_propertyName2629 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_id_in_propertyName2633 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_COLUMN_NAME_in_columnName2664 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_id_in_columnName2668 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IDENTIFIER_in_id2700 = new BitSet(new long[]{0x0000000000000002L});

}