/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.search.config.IndexConfigurationException;
import org.xcmis.search.lucene.IndexRecoveryTool;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.index.IndexTransaction;
import org.xcmis.search.lucene.index.IndexTransactionException;
import org.xcmis.search.lucene.index.IndexTransactionModificationReport;
import org.xcmis.search.lucene.index.LuceneIndexingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartableIndexingService
extends LuceneIndexingService {
    private static final String REINDEX_RUN = "reindexProcessing";
    private List<IndexTransaction<Document>> changesLogBuffer = new ArrayList<IndexTransaction<Document>>();
    private final File indexDir;
    private final IndexRecoveryTool indexRecoveryTool;
    private boolean isStarted = false;
    private static final Log LOG = ExoLogger.getLogger(StartableIndexingService.class);

    public StartableIndexingService(IndexConfiguration configuration, IndexRecoveryTool indexRecoveryTool) throws IndexConfigurationException, IndexException {
        super(configuration, indexRecoveryTool);
        this.indexRecoveryTool = indexRecoveryTool;
        this.indexDir = new File(configuration.getIndexDir());
        if (!this.indexDir.exists() && !this.indexDir.mkdirs()) {
            throw new IndexException("Fail to create index directory : " + this.indexDir.getAbsolutePath());
        }
    }

    @Override
    public IndexTransactionModificationReport save(IndexTransaction<Document> changes) throws IndexException, IndexTransactionException {
        if (this.isStarted) {
            return super.save(changes);
        }
        this.changesLogBuffer.add(changes);
        return null;
    }

    @Override
    public void start() {
        super.start();
        this.isStarted = true;
        try {
            for (IndexTransaction<Document> bufferedChangesLog : this.changesLogBuffer) {
                super.save(bufferedChangesLog);
            }
            if (this.needIndexRestore()) {
                try {
                    this.restoreIndex();
                }
                catch (IOException e) {
                    LOG.error((Object)("Restore IOException occures " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (IndexException e) {
            e.printStackTrace();
        }
        this.changesLogBuffer.clear();
        this.changesLogBuffer = null;
    }

    @Override
    public void stop() {
        super.stop();
    }

    private boolean needIndexRestore() throws IndexException {
        if (this.getDocumentCount() == 0L) {
            return true;
        }
        File flag = new File(this.indexDir, REINDEX_RUN);
        return flag.exists();
    }

    private void restoreIndex() throws IOException, IndexException {
        File flag;
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)"Restore index started.");
        }
        if (!(flag = new File(this.indexDir, REINDEX_RUN)).exists() && !flag.createNewFile()) {
            throw new IOException("Reindex flag file was not created.");
        }
        this.softCleanIndex();
        this.indexRecoveryTool.recoverAll();
        if (!flag.delete()) {
            throw new IOException("Can't remove reindex flag.");
        }
        this.changesLogBuffer.clear();
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)"Restore index finished.");
        }
    }
}

