/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.query.validate;

import java.util.HashMap;
import java.util.Map;
import org.xcmis.search.InvalidQueryException;
import org.xcmis.search.VisitException;
import org.xcmis.search.Visitors;
import org.xcmis.search.content.Schema;
import org.xcmis.search.content.TableDoesntExistException;
import org.xcmis.search.model.Query;
import org.xcmis.search.model.column.Column;
import org.xcmis.search.model.constraint.ChildNode;
import org.xcmis.search.model.constraint.Comparison;
import org.xcmis.search.model.constraint.DescendantNode;
import org.xcmis.search.model.constraint.FullTextSearch;
import org.xcmis.search.model.constraint.Operator;
import org.xcmis.search.model.constraint.PropertyExistence;
import org.xcmis.search.model.constraint.SameNode;
import org.xcmis.search.model.operand.DynamicOperand;
import org.xcmis.search.model.operand.FullTextSearchScore;
import org.xcmis.search.model.operand.Length;
import org.xcmis.search.model.operand.LowerCase;
import org.xcmis.search.model.operand.NodeDepth;
import org.xcmis.search.model.operand.NodeLocalName;
import org.xcmis.search.model.operand.NodeName;
import org.xcmis.search.model.operand.PropertyValue;
import org.xcmis.search.model.operand.UpperCase;
import org.xcmis.search.model.ordering.Ordering;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.model.source.join.ChildNodeJoinCondition;
import org.xcmis.search.model.source.join.DescendantNodeJoinCondition;
import org.xcmis.search.model.source.join.EquiJoinCondition;
import org.xcmis.search.model.source.join.SameNodeJoinCondition;
import org.xcmis.search.query.QueryExecutionContext;
import org.xcmis.search.query.QueryExecutionExceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator
extends Visitors.AbstractModelVisitor {
    private final QueryExecutionContext context;
    private final QueryExecutionExceptions problems;
    private final Map<SelectorName, Schema.Table> selectorsByNameOrAlias;
    private final Map<SelectorName, Schema.Table> selectorsByName;
    private final Map<String, Schema.Column> columnsByAlias;
    private final boolean validateColumnExistence;

    public Validator(QueryExecutionContext context, Map<SelectorName, Schema.Table> selectorsByName) {
        this.context = context;
        this.problems = this.context.getExecutionExceptions();
        this.selectorsByNameOrAlias = selectorsByName;
        this.selectorsByName = new HashMap<SelectorName, Schema.Table>();
        for (Schema.Table table : selectorsByName.values()) {
            this.selectorsByName.put(table.getName(), table);
        }
        this.columnsByAlias = new HashMap<String, Schema.Column>();
        this.validateColumnExistence = true;
    }

    public Schema.Table checkSelectorExistance(SelectorName selectorName) {
        Schema.Table table = this.selectorsByNameOrAlias.get(selectorName);
        if (table == null) {
            table = this.selectorsByName.get(selectorName);
        }
        if (table == null) {
            this.problems.addException(new TableDoesntExistException("Table " + selectorName.getName() + " doesnt exist"));
        }
        return table;
    }

    public Schema.Column checkTableAndColumnExistance(SelectorName selectorName, String propertyName, boolean columnIsRequired) {
        Schema.Table table = this.checkSelectorExistance(selectorName);
        if (table != null && !propertyName.equals("*")) {
            Schema.Column column = table.getColumn(propertyName);
            if (column == null && (column = this.columnsByAlias.get(propertyName)) == null && columnIsRequired) {
                this.problems.addException((Throwable)new InvalidQueryException("Column " + propertyName + " doesnt exist on table " + selectorName.getName() + " or not allowed for search"));
            }
            return column;
        }
        return null;
    }

    public void visit(ChildNode node) throws VisitException {
        this.checkSelectorExistance(node.getSelectorName());
    }

    public void visit(ChildNodeJoinCondition node) throws VisitException {
        this.checkSelectorExistance(node.getChildSelectorName());
        this.checkSelectorExistance(node.getParentSelectorName());
        if (node.getChildSelectorName().equals((Object)node.getParentSelectorName())) {
            this.problems.addException((Throwable)new InvalidQueryException(node.getChildSelectorName() + " is the same as " + node.getParentSelectorName()));
        }
    }

    public void visit(Column node) throws VisitException {
        if (!node.isFunction()) {
            this.checkTableAndColumnExistance(node.getSelectorName(), node.getPropertyName(), true);
        }
    }

    public void visit(Comparison node) throws VisitException {
        super.visit(node);
        DynamicOperand dynamicOperand = node.getOperand1();
        if (dynamicOperand instanceof PropertyValue) {
            Schema.Column column;
            PropertyValue propertyValueOperand = (PropertyValue)dynamicOperand;
            Schema.Table table = this.checkSelectorExistance(propertyValueOperand.getSelectorName());
            String propertyName = propertyValueOperand.getPropertyName();
            if (table != null && !propertyName.equals("*") && (column = table.getColumn(propertyName)) != null) {
                boolean isAvaileable = false;
                for (Operator operator : column.getAvailableQueryOperators()) {
                    if (!node.getOperator().equals((Object)operator)) continue;
                    isAvaileable = true;
                    break;
                }
                if (!isAvaileable) {
                    throw new VisitException("Operator :" + node.getOperator() + " is not availeble query operator for property '" + propertyValueOperand.getPropertyName() + "' of the table  '" + propertyValueOperand.getSelectorName() + "'");
                }
            }
        } else if (dynamicOperand instanceof Length || dynamicOperand instanceof NodeName || dynamicOperand instanceof NodeLocalName) {
            // empty if block
        }
    }

    public void visit(DescendantNode node) throws VisitException {
        this.checkSelectorExistance(node.getSelectorName());
    }

    public void visit(DescendantNodeJoinCondition node) throws VisitException {
        this.checkSelectorExistance(node.getAncestorSelectorName());
        this.checkSelectorExistance(node.getDescendantSelectorName());
    }

    public void visit(EquiJoinCondition node) throws VisitException {
        this.checkTableAndColumnExistance(node.getSelector1Name(), node.getProperty1Name(), true);
        this.checkTableAndColumnExistance(node.getSelector2Name(), node.getProperty2Name(), true);
        if (node.getSelector1Name().equals((Object)node.getSelector2Name())) {
            this.problems.addException((Throwable)new InvalidQueryException(node.getSelector1Name() + " is the same as " + node.getSelector2Name()));
        }
    }

    public void visit(FullTextSearch node) throws VisitException {
        SelectorName selectorName = node.getSelectorName();
        if (node.getPropertyName() != null) {
            Schema.Column column = this.checkTableAndColumnExistance(selectorName, node.getPropertyName(), this.validateColumnExistence);
            if (column != null && !column.isFullTextSearchable()) {
                this.problems.addException((Throwable)new InvalidQueryException("Column " + column.getName() + " on table " + selectorName + " does not support full-text searching"));
            }
        } else {
            Schema.Table table = this.checkSelectorExistance(selectorName);
            if (table != null) {
                boolean searchable = false;
                for (Schema.Column column : table.getColumns()) {
                    if (!column.isFullTextSearchable()) continue;
                    searchable = true;
                    break;
                }
                if (!searchable) {
                    this.problems.addException((Throwable)new InvalidQueryException("Table '" + selectorName + "' has no columns that support full-text searching"));
                }
            }
        }
    }

    public void visit(FullTextSearchScore node) throws VisitException {
        this.checkSelectorExistance(node.getSelectorName());
    }

    public void visit(Length node) throws VisitException {
        this.checkSelectorExistance(node.getSelectorName());
    }

    public void visit(LowerCase node) throws VisitException {
        this.checkSelectorExistance(node.getSelectorName());
    }

    public void visit(NodeDepth depth) throws VisitException {
        this.checkSelectorExistance(depth.getSelectorName());
    }

    public void visit(NodeLocalName node) throws VisitException {
        this.checkSelectorExistance(node.getSelectorName());
    }

    public void visit(NodeName node) throws VisitException {
        this.checkSelectorExistance(node.getSelectorName());
    }

    public void visit(PropertyExistence node) throws VisitException {
        this.checkTableAndColumnExistance(node.getSelectorName(), node.getPropertyName(), true);
    }

    public void visit(PropertyValue node) throws VisitException {
        this.checkTableAndColumnExistance(node.getSelectorName(), node.getPropertyName(), true);
    }

    public void visit(Query node) throws VisitException {
        this.columnsByAlias.clear();
        for (Column column : node.getColumns()) {
            Schema.Column tableColumn;
            Schema.Table table;
            if (column.isFunction() || (table = this.checkSelectorExistance(column.getSelectorName())) == null || (tableColumn = table.getColumn(column.getPropertyName())) == null) continue;
            this.columnsByAlias.put(column.getColumnName(), tableColumn);
        }
        super.visit(node);
    }

    public void visit(Ordering node) throws VisitException {
    }

    public void visit(SameNode node) throws VisitException {
        this.checkSelectorExistance(node.getSelectorName());
    }

    public void visit(SameNodeJoinCondition node) throws VisitException {
        this.checkSelectorExistance(node.getSelector1Name());
        this.checkSelectorExistance(node.getSelector2Name());
        if (node.getSelector1Name().equals((Object)node.getSelector2Name())) {
            this.problems.addException((Throwable)new InvalidQueryException(node.getSelector1Name() + " is the same as " + node.getSelector2Name()));
        }
    }

    public void visit(UpperCase node) throws VisitException {
        this.checkSelectorExistance(node.getSelectorName());
    }
}

