/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene;

import java.io.IOException;
import org.apache.commons.lang.Validate;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.search.config.SearchServiceConfiguration;
import org.xcmis.search.lucene.AbstractLuceneQueryableIndexStorage;
import org.xcmis.search.lucene.IndexRecoveryTool;
import org.xcmis.search.lucene.index.FieldNames;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.index.IndexTransactionException;
import org.xcmis.search.lucene.index.LuceneIndexTransaction;
import org.xcmis.search.lucene.index.StartableIndexingService;

public class LuceneQueryableIndexStorage
extends AbstractLuceneQueryableIndexStorage {
    private static final Log LOG = ExoLogger.getLogger(LuceneQueryableIndexStorage.class);
    private final StartableIndexingService indexDataManager;

    public LuceneQueryableIndexStorage(SearchServiceConfiguration serviceConfuguration) throws IndexException {
        super(serviceConfuguration);
        Validate.notNull((Object)serviceConfuguration.getIndexConfuguration().getIndexDir(), (String)"The IndexDir may not be null in IndexConfiguration");
        this.indexDataManager = new StartableIndexingService(serviceConfuguration.getIndexConfuguration(), new IndexRecoveryTool(this, this.nodeIndexer, serviceConfuguration.getIndexConfuguration()));
    }

    public void start() {
        super.start();
        this.indexDataManager.start();
    }

    public void stop() {
        super.stop();
        this.indexDataManager.stop();
    }

    protected IndexReader getIndexReader() throws IndexException {
        return this.indexDataManager.getIndexReader();
    }

    protected Document getDocument(String uuid, IndexReader reader) throws IndexException {
        try {
            TermDocs termDocs;
            if (reader != null && (termDocs = reader.termDocs(new Term(FieldNames.UUID, uuid))).next()) {
                Document document = reader.document(termDocs.doc());
                if (termDocs.next()) {
                    throw new IndexException("More then one document found for uuid:" + uuid);
                }
                return document;
            }
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        return null;
    }

    protected Object save(LuceneIndexTransaction indexTransaction) throws IndexException, IndexTransactionException {
        return this.indexDataManager.save(indexTransaction);
    }
}

