/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.inmemory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xcmis.sp.inmemory.Value;

public class ByteArrayValue
extends Value {
    private final byte[] values;

    public ByteArrayValue(byte[] a) {
        this.values = new byte[a.length];
        System.arraycopy(a, 0, this.values, 0, a.length);
    }

    @Override
    public byte[] getBytes() {
        return this.values;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    public static ByteArrayValue fromStream(InputStream stream) throws IOException {
        if (stream == null) {
            return new ByteArrayValue(new byte[0]);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int r = -1;
        while ((r = stream.read(buf)) != -1) {
            bout.write(buf, 0, r);
        }
        stream.close();
        byte[] bytes = bout.toByteArray();
        return new ByteArrayValue(bytes);
    }
}

