/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo;

import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.xcmis.sp.jcr.exo.BaseObjectData;
import org.xcmis.sp.jcr.exo.FolderDataImpl;
import org.xcmis.sp.jcr.exo.JcrNodeEntry;
import org.xcmis.sp.jcr.exo.PWC;
import org.xcmis.sp.jcr.exo.StorageImpl;
import org.xcmis.sp.jcr.exo.index.IndexListener;
import org.xcmis.spi.BaseContentStream;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.utils.MimeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocumentDataImpl
extends BaseObjectData
implements DocumentData {
    protected static final Set<String> CHECKOUT_SKIP = new HashSet<String>();
    protected final RenditionManager renditionManager;

    public DocumentDataImpl(JcrNodeEntry jcrEntry, IndexListener indexListener, RenditionManager renditionManager) {
        super(jcrEntry, indexListener);
        this.renditionManager = renditionManager;
    }

    public void cancelCheckout() throws VersioningException, UpdateConflictException, StorageException {
        try {
            Session session = this.getNode().getSession();
            Node pwcNode = ((ExtendedSession)session).getNodeByIdentifier(this.getVersionSeriesCheckedOutId());
            PWC pwc = new PWC(new JcrNodeEntry(pwcNode), this.indexListener, this.renditionManager, this);
            pwc.delete();
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable cancel checkout. " + re.getMessage(), (Throwable)re);
        }
    }

    public DocumentData checkin(boolean major, String checkinComment, Map<String, Property<?>> properties, ContentStream content, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws NameConstraintViolationException, UpdateConflictException, StorageException {
        throw new CmisRuntimeException("Current object is not Private Working Copy.");
    }

    public DocumentData checkout() throws VersioningException, UpdateConflictException, StorageException {
        if (this.isVersionSeriesCheckedOut()) {
            throw new VersioningException("Version series already checked-out. Not allowed have more then one PWC for version series at a time.");
        }
        try {
            Session session = this.getNode().getSession();
            String name = this.getName();
            TypeDefinition type = this.getTypeDefinition();
            Node workingCopies = (Node)session.getItem("/xcmis:system/xcmis:workingCopyStore");
            Node wc = workingCopies.addNode(this.getObjectId(), "xcmis:workingCopy");
            Node pwcNode = wc.addNode(name, type.getLocalName());
            if (!pwcNode.isNodeType("cmis:document")) {
                pwcNode.addMixin("cmis:document");
            }
            if (pwcNode.canAddMixin("mix:versionable")) {
                pwcNode.addMixin("mix:versionable");
            }
            JcrNodeEntry pwcNodeEntry = new JcrNodeEntry(pwcNode);
            pwcNodeEntry.setValue("cmis:objectTypeId", type.getId());
            pwcNodeEntry.setValue("cmis:baseTypeId", type.getBaseId().value());
            String userId = session.getUserID();
            pwcNodeEntry.setValue("cmis:createdBy", userId);
            pwcNodeEntry.setValue("cmis:lastModifiedBy", userId);
            Calendar cal = Calendar.getInstance();
            pwcNodeEntry.setValue("cmis:creationDate", cal);
            pwcNodeEntry.setValue("cmis:lastModificationDate", cal);
            pwcNodeEntry.setValue("cmis:versionSeriesId", this.getVersionSeriesId());
            pwcNodeEntry.setValue("cmis:isLatestVersion", true);
            pwcNodeEntry.setValue("cmis:isMajorVersion", false);
            pwcNodeEntry.setValue("cmis:versionLabel", StorageImpl.PWC_LABEL);
            pwcNodeEntry.setValue("cmis:isVersionSeriesCheckedOut", true);
            pwcNodeEntry.setValue("cmis:versionSeriesCheckedOutId", pwcNodeEntry.getId());
            pwcNodeEntry.setValue("cmis:versionSeriesCheckedOutBy", session.getUserID());
            pwcNodeEntry.setValue("xcmis:latestVersionId", this.getObjectId());
            pwcNodeEntry.setContentStream(this.getContentStream());
            try {
                for (PropertyDefinition def : type.getPropertyDefinitions()) {
                    String pId = def.getId();
                    if (CHECKOUT_SKIP.contains(pId)) continue;
                    pwcNodeEntry.setProperty(this.getProperty(pId));
                }
            }
            catch (NameConstraintViolationException never) {
                throw new CmisRuntimeException(never.getMessage(), (Throwable)never);
            }
            this.jcrEntry.setValue("cmis:isLatestVersion", false);
            this.jcrEntry.setValue("cmis:isVersionSeriesCheckedOut", true);
            this.jcrEntry.setValue("cmis:versionSeriesCheckedOutId", pwcNodeEntry.getId());
            this.jcrEntry.setValue("cmis:versionSeriesCheckedOutBy", userId);
            session.save();
            PWC pwc = new PWC(pwcNodeEntry, this.indexListener, this.renditionManager, this);
            return pwc;
        }
        catch (IOException ioe) {
            throw new CmisRuntimeException("Unable checkout. " + ioe.getMessage(), (Throwable)ioe);
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable checkout. " + re.getMessage(), (Throwable)re);
        }
    }

    public ContentStream getContentStream() throws IOException {
        return this.jcrEntry.getContentStream();
    }

    public ContentStream getContentStream(String streamId) throws IOException {
        if (streamId == null) {
            return this.getContentStream();
        }
        if (streamId.equals(this.jcrEntry.getString("cmis:contentStreamId"))) {
            return this.getContentStream();
        }
        try {
            Node rendition = this.getNode().getNode(streamId);
            javax.jcr.Property renditionContent = rendition.getProperty("xcmis:renditionStream");
            MimeType mimeType = MimeType.fromString((String)rendition.getProperty("xcmis:renditionMimeType").getString());
            if (rendition.hasProperty("xcmis:renditionEncoding")) {
                mimeType.getParameters().put("charset", rendition.getProperty("xcmis:renditionEncoding").getString());
            }
            return new BaseContentStream(renditionContent.getStream(), renditionContent.getLength(), null, mimeType);
        }
        catch (PathNotFoundException pnfe) {
            if (this.renditionManager != null) {
                return this.renditionManager.getStream((ObjectData)this, streamId);
            }
            return null;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get rendition stream. " + re.getMessage(), (Throwable)re);
        }
    }

    public String getContentStreamMimeType() {
        String mimeType = this.jcrEntry.getString("cmis:contentStreamMimeType");
        if (mimeType != null) {
            return mimeType;
        }
        try {
            return this.getNode().getProperty("jcr:content/jcr:mimeType").getString();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get content stream mime type. " + re.getMessage(), (Throwable)re);
        }
    }

    public FolderData getParent() throws ConstraintException {
        Collection<FolderData> parents = this.getParents();
        if (parents.size() > 1) {
            throw new ConstraintException("Object has more then one parent.");
        }
        if (parents.size() == 0) {
            return null;
        }
        return parents.iterator().next();
    }

    public Collection<FolderData> getParents() {
        try {
            Node node = this.getNode();
            HashSet<FolderData> parents = new HashSet<FolderData>();
            PropertyIterator iterator = node.getReferences();
            while (iterator.hasNext()) {
                Node link = iterator.nextProperty().getParent();
                if (!link.isNodeType("nt:linkedFile")) continue;
                Node parent = link.getParent();
                parents.add(new FolderDataImpl(new JcrNodeEntry(parent), this.indexListener, this.renditionManager));
            }
            if (!node.getParent().isNodeType("xcmis:unfiledObject")) {
                Node parent = node.getParent();
                parents.add(new FolderDataImpl(new JcrNodeEntry(parent), this.indexListener, this.renditionManager));
            }
            return parents;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get object parent. " + re.getMessage(), (Throwable)re);
        }
    }

    public String getVersionLabel() {
        return this.jcrEntry.getString("cmis:versionLabel");
    }

    public String getVersionSeriesCheckedOutBy() {
        return this.jcrEntry.getString("cmis:versionSeriesCheckedOutBy");
    }

    public String getVersionSeriesCheckedOutId() {
        return this.jcrEntry.getString("cmis:versionSeriesCheckedOutId");
    }

    public String getVersionSeriesId() {
        return this.jcrEntry.getString("cmis:versionSeriesId");
    }

    public boolean hasContent() {
        return this.jcrEntry.hasContent();
    }

    public boolean isLatestMajorVersion() {
        return this.isLatestVersion() && this.isMajorVersion();
    }

    public boolean isLatestVersion() {
        Boolean latest = this.jcrEntry.getBoolean("cmis:isLatestVersion");
        return latest == null ? true : latest;
    }

    public boolean isMajorVersion() {
        Boolean major = this.jcrEntry.getBoolean("cmis:isMajorVersion");
        return major == null ? false : major;
    }

    public boolean isPWC() {
        return false;
    }

    public boolean isVersionSeriesCheckedOut() {
        Boolean checkout = this.jcrEntry.getBoolean("cmis:isVersionSeriesCheckedOut");
        return checkout == null ? false : checkout;
    }

    public void setContentStream(ContentStream contentStream) throws IOException, VersioningException, UpdateConflictException, StorageException {
        this.jcrEntry.setContentStream(contentStream);
        this.save();
    }

    protected long getContentStreamLength() {
        Long length = this.jcrEntry.getLong("cmis:contentStreamLength");
        if (length != null) {
            return length;
        }
        try {
            return this.getNode().getProperty("jcr:content/jcr:data").getLength();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get content stream length. " + re.getMessage(), (Throwable)re);
        }
    }

    @Override
    protected void delete() throws StorageException {
        String objectId = this.getObjectId();
        try {
            Node node = this.getNode();
            Session session = node.getSession();
            PropertyIterator references = node.getReferences();
            while (references.hasNext()) {
                Node next = references.nextProperty().getParent();
                if (!next.isNodeType("nt:linkedFile")) continue;
                next.remove();
            }
            String pwcId = this.getVersionSeriesCheckedOutId();
            if (pwcId != null) {
                Node pwcNode = ((ExtendedSession)session).getNodeByIdentifier(pwcId);
                pwcNode.getParent().remove();
            }
            if (this.getParents().size() == 0) {
                node.getParent().remove();
            } else {
                node.remove();
            }
            session.save();
        }
        catch (ReferentialIntegrityException rie) {
            throw new StorageException("Object can't be deleted cause to storage referential integrity. Probably this object is source or target at least one Relationship. Those Relationship should be deleted before.");
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable delete object. " + re.getMessage(), (Throwable)re);
        }
        if (this.indexListener != null) {
            HashSet<String> removed = new HashSet<String>();
            removed.add(objectId);
            this.indexListener.removed(removed);
        }
    }

    void unfile() {
        this.jcrEntry.unfile();
        if (this.indexListener != null) {
            this.indexListener.updated(this);
        }
    }

    static {
        CHECKOUT_SKIP.add("cmis:name");
        CHECKOUT_SKIP.add("cmis:objectId");
        CHECKOUT_SKIP.add("cmis:objectTypeId");
        CHECKOUT_SKIP.add("cmis:baseTypeId");
        CHECKOUT_SKIP.add("cmis:createdBy");
        CHECKOUT_SKIP.add("cmis:creationDate");
        CHECKOUT_SKIP.add("cmis:lastModifiedBy");
        CHECKOUT_SKIP.add("cmis:lastModificationDate");
        CHECKOUT_SKIP.add("cmis:changeToken");
        CHECKOUT_SKIP.add("cmis:isImmutable");
        CHECKOUT_SKIP.add("cmis:versionSeriesId");
        CHECKOUT_SKIP.add("cmis:isLatestVersion");
        CHECKOUT_SKIP.add("cmis:isMajorVersion");
        CHECKOUT_SKIP.add("cmis:isLatestMajorVersion");
        CHECKOUT_SKIP.add("cmis:versionLabel");
        CHECKOUT_SKIP.add("cmis:checkinComment");
        CHECKOUT_SKIP.add("cmis:isVersionSeriesCheckedOut");
        CHECKOUT_SKIP.add("cmis:versionSeriesCheckedOutId");
        CHECKOUT_SKIP.add("cmis:versionSeriesCheckedOutBy");
        CHECKOUT_SKIP.add("cmis:contentStreamFileName");
        CHECKOUT_SKIP.add("cmis:contentStreamId");
        CHECKOUT_SKIP.add("cmis:contentStreamLength");
        CHECKOUT_SKIP.add("cmis:contentStreamMimeType");
        CHECKOUT_SKIP.add("xcmis:latestVersionId");
    }
}

