/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.xcmis.sp.jcr.exo.DocumentDataImpl;
import org.xcmis.sp.jcr.exo.JcrNodeEntry;
import org.xcmis.sp.jcr.exo.JcrTypeHelper;
import org.xcmis.sp.jcr.exo.index.IndexListener;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.RelationshipDirection;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.utils.CmisUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentVersion
extends DocumentDataImpl {
    private DocumentData document;

    public DocumentVersion(JcrNodeEntry jcrEntry, IndexListener indexListener, RenditionManager renditionManager) {
        super(jcrEntry, indexListener, renditionManager);
    }

    @Override
    public void applyPolicy(PolicyData policy) {
        throw new CmisRuntimeException("Not supported for non current version of document.");
    }

    @Override
    public void cancelCheckout() throws VersioningException, StorageException {
        throw new VersioningException("Not supported for non current version of document.");
    }

    @Override
    public DocumentData checkin(boolean major, String checkinComment, Map<String, Property<?>> properties, ContentStream content, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws StorageException {
        throw new CmisRuntimeException("Not supported for non current version of document.");
    }

    @Override
    public DocumentData checkout() throws VersioningException, StorageException {
        throw new VersioningException("Not supported for non current version of document.");
    }

    @Override
    public List<AccessControlEntry> getACL(boolean onlyBasicPermissions) {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return this.getLatestVersion().getName();
    }

    @Override
    public FolderData getParent() throws ConstraintException {
        return this.getLatestVersion().getParent();
    }

    @Override
    public Collection<FolderData> getParents() {
        return this.getLatestVersion().getParents();
    }

    @Override
    public Collection<PolicyData> getPolicies() {
        return Collections.emptyList();
    }

    @Override
    public ItemsIterator<RelationshipData> getRelationships(RelationshipDirection direction, TypeDefinition type, boolean includeSubRelationshipTypes) {
        return CmisUtils.emptyItemsIterator();
    }

    @Override
    public String getVersionLabel() {
        try {
            return this.getNode().getParent().getName();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get version label. " + re.getMessage(), (Throwable)re);
        }
    }

    @Override
    public String getVersionSeriesCheckedOutBy() {
        return this.getLatestVersion().getVersionSeriesCheckedOutBy();
    }

    @Override
    public String getVersionSeriesCheckedOutId() {
        return this.getLatestVersion().getVersionSeriesCheckedOutId();
    }

    @Override
    public boolean isLatestVersion() {
        return false;
    }

    @Override
    public void removePolicy(PolicyData policy) {
        throw new CmisRuntimeException("Not supported for non current version of document.");
    }

    @Override
    public void setACL(List<AccessControlEntry> aces) {
        throw new CmisRuntimeException("Not supported for non current version of document.");
    }

    @Override
    public void setContentStream(ContentStream contentStream) throws IOException, VersioningException, StorageException {
        throw new VersioningException("Not supported for non current version of document.");
    }

    @Override
    public void setProperties(Map<String, Property<?>> properties) throws NameConstraintViolationException, VersioningException {
        throw new VersioningException("Not supported for non current version of document.");
    }

    @Override
    public void setProperty(Property<?> property) throws VersioningException {
        throw new VersioningException("Not supported for non current version of document.");
    }

    private DocumentData getLatestVersion() {
        if (this.document == null) {
            try {
                Node node = this.getNode();
                Session session = node.getSession();
                Version version = (Version)node.getParent();
                VersionHistory versionHistory = version.getContainingHistory();
                Node latest = ((ExtendedSession)session).getNodeByIdentifier(versionHistory.getVersionableUUID());
                this.document = new DocumentDataImpl(new JcrNodeEntry(latest, JcrTypeHelper.getTypeDefinition(latest.getPrimaryNodeType(), true)), this.indexListener, this.renditionManager);
            }
            catch (RepositoryException re) {
                throw new CmisRuntimeException("Unexpected error. " + re.getMessage(), (Throwable)re);
            }
        }
        return this.document;
    }

    @Override
    protected void delete() throws StorageException {
        throw new CmisRuntimeException("Not supported for non current version of document.");
    }

    @Override
    protected void save() {
        throw new CmisRuntimeException("Not supported for non current version of document.");
    }

    @Override
    void unfile() {
        throw new CmisRuntimeException("Not supported for non current version of document.");
    }
}

