/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo;

import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.xcmis.sp.jcr.exo.DocumentDataImpl;
import org.xcmis.sp.jcr.exo.JcrNodeEntry;
import org.xcmis.sp.jcr.exo.index.IndexListener;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.Updatability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PWC
extends DocumentDataImpl {
    private DocumentDataImpl document;

    public PWC(JcrNodeEntry jcrNodeEntry, IndexListener indexListener, RenditionManager renditionManager) {
        super(jcrNodeEntry, indexListener, renditionManager);
    }

    public PWC(JcrNodeEntry jcrEntry, IndexListener indexListener, RenditionManager renditionManager, DocumentDataImpl document) {
        super(jcrEntry, indexListener, renditionManager);
        this.document = document;
    }

    @Override
    public void cancelCheckout() throws StorageException {
        DocumentDataImpl latestVersion = this.getLatestVersion();
        JcrNodeEntry latestNodeAdapter = latestVersion.getNodeEntry();
        latestNodeAdapter.setValue("cmis:isLatestVersion", true);
        latestNodeAdapter.setValue("cmis:isVersionSeriesCheckedOut", false);
        latestNodeAdapter.setValue("cmis:versionSeriesCheckedOutId", (Value)null);
        latestNodeAdapter.setValue("cmis:versionSeriesCheckedOutBy", (Value)null);
        try {
            Node node = this.getNode();
            Session session = node.getSession();
            node.getParent().remove();
            session.save();
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable cancel checkout Document. " + re.getMessage(), (Throwable)re);
        }
    }

    @Override
    public DocumentData checkin(boolean major, String checkinComment, Map<String, Property<?>> properties, ContentStream content, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws NameConstraintViolationException, StorageException {
        try {
            DocumentDataImpl latestVersion = this.getLatestVersion();
            JcrNodeEntry latestNodeAdapter = latestVersion.getNodeEntry();
            Node latestNode = latestNodeAdapter.getNode();
            Session session = latestNode.getSession();
            latestNode.checkin();
            latestNode.checkout();
            latestNodeAdapter.setValue("cmis:isLatestVersion", true);
            latestNodeAdapter.setValue("cmis:isVersionSeriesCheckedOut", false);
            latestNodeAdapter.setValue("cmis:versionSeriesCheckedOutId", (Value)null);
            latestNodeAdapter.setValue("cmis:versionSeriesCheckedOutBy", (Value)null);
            String userId = session.getUserID();
            latestNodeAdapter.setValue("cmis:createdBy", userId);
            latestNodeAdapter.setValue("cmis:lastModifiedBy", userId);
            Calendar cal = Calendar.getInstance();
            latestNodeAdapter.setValue("cmis:creationDate", cal);
            latestNodeAdapter.setValue("cmis:lastModificationDate", cal);
            latestNodeAdapter.setValue("cmis:isMajorVersion", major);
            if (checkinComment != null) {
                latestNodeAdapter.setValue("cmis:checkinComment", checkinComment);
            }
            for (PropertyDefinition definition : this.getTypeDefinition().getPropertyDefinitions()) {
                Updatability updatability = definition.getUpdatability();
                String id = definition.getId();
                if (updatability == Updatability.READWRITE) {
                    if (properties != null && properties.containsKey(id)) {
                        latestNodeAdapter.setProperty(properties.get(id));
                        continue;
                    }
                    latestNodeAdapter.setProperty(this.getProperty(id));
                    continue;
                }
                if (updatability != Updatability.WHENCHECKEDOUT || properties == null || !properties.containsKey(id)) continue;
                latestNodeAdapter.setProperty(properties.get(id));
            }
            try {
                if (content != null) {
                    latestNodeAdapter.setContentStream(content);
                } else if (this.getContentStream() != null) {
                    latestNodeAdapter.setContentStream(this.getContentStream());
                }
            }
            catch (IOException ioe) {
                throw new CmisRuntimeException("Unable copy content for new document. " + ioe.getMessage(), (Throwable)ioe);
            }
            if (acl != null && acl.size() > 0) {
                latestNodeAdapter.setACL(acl);
            }
            if (policies != null && policies.size() > 0) {
                for (PolicyData aPolicy : policies) {
                    latestNodeAdapter.applyPolicy(aPolicy);
                }
            }
            Node node = this.getNode();
            node.getParent().remove();
            session.save();
            return latestVersion;
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable checkin Document. " + re.getMessage(), (Throwable)re);
        }
    }

    @Override
    protected void delete() throws StorageException {
        this.cancelCheckout();
    }

    @Override
    public FolderData getParent() throws ConstraintException {
        return this.getLatestVersion().getParent();
    }

    @Override
    public Collection<FolderData> getParents() {
        return this.getLatestVersion().getParents();
    }

    @Override
    public boolean isPWC() {
        return true;
    }

    private DocumentDataImpl getLatestVersion() {
        if (this.document == null) {
            try {
                Node node = this.getNode();
                Session session = node.getSession();
                String latestVersion = node.getProperty("xcmis:latestVersionId").getString();
                Node latestNode = ((ExtendedSession)session).getNodeByIdentifier(latestVersion);
                this.document = new DocumentDataImpl(new JcrNodeEntry(latestNode), this.indexListener, this.renditionManager);
            }
            catch (RepositoryException re) {
                throw new CmisRuntimeException("Unexpected error. " + re.getMessage(), (Throwable)re);
            }
        }
        return this.document;
    }
}

