/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.xcmis.sp.jcr.exo.BaseObjectData;
import org.xcmis.sp.jcr.exo.JcrNodeEntry;
import org.xcmis.sp.jcr.exo.index.IndexListener;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.StorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RelationshipDataImpl
extends BaseObjectData
implements RelationshipData {
    public RelationshipDataImpl(JcrNodeEntry jcrEntry, IndexListener indexListener) {
        super(jcrEntry, indexListener);
    }

    public String getSourceId() {
        return this.jcrEntry.getString("cmis:sourceId");
    }

    public String getTargetId() {
        return this.jcrEntry.getString("cmis:targetId");
    }

    public ContentStream getContentStream(String streamId) {
        return null;
    }

    public FolderData getParent() throws ConstraintException {
        return null;
    }

    public Collection<FolderData> getParents() {
        return Collections.emptyList();
    }

    @Override
    protected void delete() throws StorageException {
        String objectId = this.getObjectId();
        try {
            Node node = this.getNode();
            Session session = node.getSession();
            node.remove();
            session.save();
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable delete object. " + re.getMessage(), (Throwable)re);
        }
        if (this.indexListener != null) {
            HashSet<String> removed = new HashSet<String>();
            removed.add(objectId);
            this.indexListener.removed(removed);
        }
    }
}

