/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.spi.BaseContentStream;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.RenditionContentStream;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.utils.MimeType;

public class RenditionsUpdateListener
implements EventListener {
    private static final Log LOG = ExoLogger.getLogger((String)RenditionsUpdateListener.class.getName());
    private final RenditionManager renditionManager;
    private final String workspace;
    private final Repository repository;

    public RenditionsUpdateListener(Repository repository, String workspace, RenditionManager renditionManager) {
        this.repository = repository;
        this.workspace = workspace;
        this.renditionManager = renditionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator eventIterator) {
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession(this.workspace, (ManageableRepository)this.repository);
            while (eventIterator.hasNext()) {
                RenditionContentStream renditionContentStream;
                Event event = eventIterator.nextEvent();
                String path = event.getPath();
                if (path.contains("xcmis:system")) {
                    return;
                }
                if (!event.getPath().endsWith("jcr:content") && !event.getPath().endsWith("jcr:data")) continue;
                Node node = null;
                Item item = session.getItem(path);
                node = item.isNode() ? session.getItem(path).getParent() : session.getItem(path).getParent().getParent();
                Node contentNode = node.getNode("jcr:content");
                Property fileContent = contentNode.getProperty("jcr:data");
                int length = fileContent.getStream().available();
                if (length == 0) {
                    NodeIterator iter = node.getNodes();
                    while (iter.hasNext()) {
                        Node tmp = iter.nextNode();
                        if (!tmp.isNodeType("xcmis:rendition")) continue;
                        tmp.remove();
                        node.save();
                    }
                    continue;
                }
                MimeType mimeType = MimeType.fromString((String)contentNode.getProperty("jcr:mimeType").getString());
                if (contentNode.hasProperty("jcr:encoding")) {
                    mimeType.getParameters().put("charset", contentNode.getProperty("jcr:encoding").getString());
                }
                if ((renditionContentStream = this.renditionManager.getStream((ContentStream)new BaseContentStream(fileContent.getStream(), (long)length, null, mimeType), mimeType)) == null) continue;
                String id = IdGenerator.generate();
                Node rendition = node.addNode(id, "xcmis:rendition");
                rendition.setProperty("xcmis:renditionStream", renditionContentStream.getStream());
                rendition.setProperty("xcmis:renditionMimeType", renditionContentStream.getMediaType().getBaseType());
                rendition.setProperty("xcmis:renditionEncoding", renditionContentStream.getMediaType().getParameter("charset"));
                rendition.setProperty("xcmis:renditionKind", renditionContentStream.getKind());
                rendition.setProperty("xcmis:renditionHeight", (long)renditionContentStream.getHeight());
                rendition.setProperty("xcmis:renditionWidth", (long)renditionContentStream.getWidth());
                session.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Creating rendition on event failed. ", (Throwable)e);
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }
}

