/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xcmis.search.content.InMemoryColumn;
import org.xcmis.search.content.Schema;
import org.xcmis.search.model.constraint.Operator;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.value.PropertyType;
import org.xcmis.spi.TypeManager;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.TypeDefinition;

public class CmisSchema
implements Schema {
    public static Map<org.xcmis.spi.model.PropertyType, PropertyType> PROPERTY_TYPES_MAP = new HashMap<org.xcmis.spi.model.PropertyType, PropertyType>();
    public static Map<org.xcmis.spi.model.PropertyType, Operator[]> AVAILABLE_QUERY_OPERATORS;
    private final TypeManager typeManager;

    public CmisSchema(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public Schema.Table getTable(SelectorName name) {
        try {
            TypeDefinition typeDefinition = this.typeManager.getTypeDefinition(name.getName(), true);
            return new CmisTableDefinition(name, typeDefinition);
        }
        catch (TypeNotFoundException tnfe) {
            return null;
        }
    }

    static {
        PROPERTY_TYPES_MAP.put(org.xcmis.spi.model.PropertyType.BOOLEAN, PropertyType.BOOLEAN);
        PROPERTY_TYPES_MAP.put(org.xcmis.spi.model.PropertyType.ID, PropertyType.STRING);
        PROPERTY_TYPES_MAP.put(org.xcmis.spi.model.PropertyType.INTEGER, PropertyType.LONG);
        PROPERTY_TYPES_MAP.put(org.xcmis.spi.model.PropertyType.DATETIME, PropertyType.DATE);
        PROPERTY_TYPES_MAP.put(org.xcmis.spi.model.PropertyType.DECIMAL, PropertyType.DOUBLE);
        PROPERTY_TYPES_MAP.put(org.xcmis.spi.model.PropertyType.HTML, PropertyType.STRING);
        PROPERTY_TYPES_MAP.put(org.xcmis.spi.model.PropertyType.STRING, PropertyType.STRING);
        PROPERTY_TYPES_MAP.put(org.xcmis.spi.model.PropertyType.URI, PropertyType.STRING);
        AVAILABLE_QUERY_OPERATORS = new HashMap<org.xcmis.spi.model.PropertyType, Operator[]>();
        AVAILABLE_QUERY_OPERATORS.put(org.xcmis.spi.model.PropertyType.BOOLEAN, new Operator[]{Operator.EQUAL_TO});
        AVAILABLE_QUERY_OPERATORS.put(org.xcmis.spi.model.PropertyType.ID, new Operator[]{Operator.EQUAL_TO, Operator.NOT_EQUAL_TO});
        AVAILABLE_QUERY_OPERATORS.put(org.xcmis.spi.model.PropertyType.INTEGER, new Operator[]{Operator.EQUAL_TO, Operator.GREATER_THAN, Operator.GREATER_THAN_OR_EQUAL_TO, Operator.LESS_THAN, Operator.LESS_THAN_OR_EQUAL_TO, Operator.NOT_EQUAL_TO});
        AVAILABLE_QUERY_OPERATORS.put(org.xcmis.spi.model.PropertyType.DATETIME, new Operator[]{Operator.EQUAL_TO, Operator.GREATER_THAN, Operator.GREATER_THAN_OR_EQUAL_TO, Operator.LESS_THAN, Operator.LESS_THAN_OR_EQUAL_TO, Operator.NOT_EQUAL_TO});
        AVAILABLE_QUERY_OPERATORS.put(org.xcmis.spi.model.PropertyType.DECIMAL, new Operator[]{Operator.EQUAL_TO, Operator.GREATER_THAN, Operator.GREATER_THAN_OR_EQUAL_TO, Operator.LESS_THAN, Operator.LESS_THAN_OR_EQUAL_TO, Operator.NOT_EQUAL_TO});
        AVAILABLE_QUERY_OPERATORS.put(org.xcmis.spi.model.PropertyType.HTML, new Operator[]{Operator.EQUAL_TO, Operator.GREATER_THAN, Operator.LIKE, Operator.NOT_EQUAL_TO});
        AVAILABLE_QUERY_OPERATORS.put(org.xcmis.spi.model.PropertyType.STRING, new Operator[]{Operator.EQUAL_TO, Operator.GREATER_THAN, Operator.LIKE, Operator.NOT_EQUAL_TO});
        AVAILABLE_QUERY_OPERATORS.put(org.xcmis.spi.model.PropertyType.URI, new Operator[]{Operator.EQUAL_TO, Operator.NOT_EQUAL_TO, Operator.LIKE});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CmisTableDefinition
    implements Schema.Table {
        private final SelectorName name;
        private final TypeDefinition typeDefinition;

        public CmisTableDefinition(SelectorName name, TypeDefinition typeDefinition) {
            this.name = name;
            this.typeDefinition = typeDefinition;
        }

        public Schema.Column getColumn(String name) {
            PropertyDefinition propertyDefinition = this.typeDefinition.getPropertyDefinition(name);
            if (propertyDefinition != null) {
                org.xcmis.spi.model.PropertyType propertyType = propertyDefinition.getPropertyType();
                return new InMemoryColumn(name, PROPERTY_TYPES_MAP.get(propertyType), true, AVAILABLE_QUERY_OPERATORS.get(propertyType));
            }
            return null;
        }

        public List<Schema.Column> getColumns() {
            Collection props = this.typeDefinition.getPropertyDefinitions();
            ArrayList<Schema.Column> result = new ArrayList<Schema.Column>(props.size());
            for (PropertyDefinition propertyDefinition : props) {
                org.xcmis.spi.model.PropertyType propertyType = propertyDefinition.getPropertyType();
                result.add((Schema.Column)new InMemoryColumn(propertyDefinition.getQueryName(), PROPERTY_TYPES_MAP.get(propertyType), true, AVAILABLE_QUERY_OPERATORS.get(propertyType)));
            }
            return result;
        }

        public Map<String, Schema.Column> getColumnsByName() {
            Collection props = this.typeDefinition.getPropertyDefinitions();
            HashMap<String, Schema.Column> result = new HashMap<String, Schema.Column>(props.size());
            for (PropertyDefinition propertyDefinition : props) {
                org.xcmis.spi.model.PropertyType propertyType = propertyDefinition.getPropertyType();
                result.put(propertyDefinition.getQueryName(), (Schema.Column)new InMemoryColumn(propertyDefinition.getQueryName(), PROPERTY_TYPES_MAP.get(propertyType), true, AVAILABLE_QUERY_OPERATORS.get(propertyType)));
            }
            return result;
        }

        public SelectorName getName() {
            return this.name;
        }
    }
}

