/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.sp.jcr.exo.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.search.SearchService;
import org.xcmis.search.content.ContentEntry;
import org.xcmis.search.content.IndexModificationException;
import org.xcmis.search.content.Property;
import org.xcmis.search.value.PropertyType;
import org.xcmis.sp.jcr.exo.index.CmisSchema;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.Storage;
import org.xcmis.spi.model.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexListener {
    private static final Log LOG = ExoLogger.getLogger(IndexListener.class);
    private final SearchService searchService;
    private final Storage storage;
    private ContentEntryAdapter contentEntryAdapter;

    public IndexListener(Storage storage, SearchService searchService) {
        Validate.notNull((Object)searchService, (String)"The searchService argument may not be null");
        this.storage = storage;
        this.searchService = searchService;
        this.contentEntryAdapter = new ContentEntryAdapter();
    }

    public void created(ObjectData object) {
        try {
            this.searchService.update(this.contentEntryAdapter.createEntry(object), null);
        }
        catch (IndexModificationException e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
    }

    public void removed(Set<String> removed) {
        try {
            this.searchService.update(Collections.EMPTY_LIST, removed);
        }
        catch (IndexModificationException e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
    }

    public void updated(ObjectData object) {
        try {
            this.searchService.update(this.contentEntryAdapter.createEntry(object), object.getObjectId());
        }
        catch (IndexModificationException e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage());
        }
    }

    private static class MockContentEntry {
        List<String> tableNames = new ArrayList<String>();
        String name;
        List<String> parentIdentifiers = new ArrayList<String>();
        String identifier;
        List<org.xcmis.search.content.Property> properties = new ArrayList<org.xcmis.search.content.Property>();

        MockContentEntry() {
        }

        public String[] getTableNames() {
            return this.tableNames.toArray(new String[this.tableNames.size()]);
        }

        public String[] getParentIdentifiers() {
            return this.parentIdentifiers.toArray(new String[this.parentIdentifiers.size()]);
        }

        public org.xcmis.search.content.Property[] getProperties() {
            return this.properties.toArray(new org.xcmis.search.content.Property[this.properties.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContentEntryAdapter {
        public ContentEntry createEntry(ObjectData objectData) throws IOException {
            if (objectData != null) {
                switch (objectData.getBaseType()) {
                    case DOCUMENT: {
                        return this.createFromDocument((DocumentData)objectData);
                    }
                    case FOLDER: {
                        return this.createFromFolder((FolderData)objectData);
                    }
                    case POLICY: {
                        return this.createFromPolicy((PolicyData)objectData);
                    }
                    case RELATIONSHIP: {
                        return this.createFromRelationship((RelationshipData)objectData);
                    }
                }
                throw new UnsupportedOperationException(objectData.getBaseType().toString() + " is not supported for indexing");
            }
            return null;
        }

        private ContentEntry createFromRelationship(RelationshipData objectData) {
            MockContentEntry mockEntry = this.fillCommonInformation((ObjectData)objectData);
            mockEntry.parentIdentifiers.add("");
            return new ContentEntry(mockEntry.name, mockEntry.getTableNames(), mockEntry.identifier, mockEntry.getParentIdentifiers(), mockEntry.getProperties());
        }

        private ContentEntry createFromPolicy(PolicyData objectData) {
            MockContentEntry mockEntry = this.fillCommonInformation((ObjectData)objectData);
            mockEntry.parentIdentifiers.add("");
            return new ContentEntry(mockEntry.name, mockEntry.getTableNames(), mockEntry.identifier, mockEntry.getParentIdentifiers(), mockEntry.getProperties());
        }

        private MockContentEntry fillCommonInformation(ObjectData objectData) {
            MockContentEntry contentEntry = new MockContentEntry();
            contentEntry.tableNames.add(objectData.getTypeDefinition().getQueryName());
            contentEntry.identifier = objectData.getObjectId();
            contentEntry.name = objectData.getName();
            for (FolderData folder : objectData.getParents()) {
                contentEntry.parentIdentifiers.add(folder.getObjectId());
            }
            for (Property property : objectData.getProperties().values()) {
                if (property.getValues().size() <= 0) continue;
                contentEntry.properties.add(this.convertProperty(property));
            }
            return contentEntry;
        }

        private <G> org.xcmis.search.content.Property<G> convertProperty(Property<G> property) {
            ArrayList<Property.SimpleValue> value = new ArrayList<Property.SimpleValue>();
            for (Object contentValue : property.getValues()) {
                value.add(new Property.SimpleValue(contentValue));
            }
            return new org.xcmis.search.content.Property(CmisSchema.PROPERTY_TYPES_MAP.get(property.getType()), property.getQueryName(), value);
        }

        private ContentEntry createFromFolder(FolderData objectData) {
            MockContentEntry mockEntry = this.fillCommonInformation((ObjectData)objectData);
            return new ContentEntry(mockEntry.name, mockEntry.getTableNames(), mockEntry.identifier, mockEntry.getParentIdentifiers(), mockEntry.getProperties());
        }

        private ContentEntry createFromDocument(DocumentData objectData) throws IOException {
            MockContentEntry mockEntry = this.fillCommonInformation((ObjectData)objectData);
            ContentStream cs = objectData.getContentStream();
            if (cs != null) {
                ArrayList<Property.BinaryValue> vals = new ArrayList<Property.BinaryValue>(1);
                vals.add(new Property.BinaryValue(cs.getStream(), cs.getMediaType().getBaseType(), cs.getMediaType().getParameter("charset"), cs.length()));
                mockEntry.properties.add(new org.xcmis.search.content.Property(PropertyType.BINARY, "content", vals));
            }
            return new ContentEntry(mockEntry.name, mockEntry.getTableNames(), mockEntry.identifier, mockEntry.getParentIdentifiers(), mockEntry.getProperties());
        }
    }
}

