/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.tck;

import java.util.HashMap;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.NotSupportedException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.AccessControlPropagation;
import org.xcmis.spi.model.CapabilityACL;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.tck.BaseTest;
import org.xcmis.spi.utils.CmisUtils;

public class ACLTest
extends BaseTest {
    private static String testRootFolderId;
    private static TypeDefinition controllableAclType;
    private static TypeDefinition notControllableAclType;
    private static String controllableAclObject;
    private static String notControllableAclObject;
    private static String principal;

    @BeforeClass
    public static void start() throws Exception {
        String targetId;
        String sourceId;
        testRootFolderId = ACLTest.createFolder(rootFolderID, "cmis:folder", "acl_testroot", null, null, null);
        List allTypes = connection.getTypeDescendants(null, -1, true);
        controllableAclType = ACLTest.getControllableAclType(allTypes);
        notControllableAclType = ACLTest.getNotControllableAclType(allTypes);
        if (controllableAclType != null) {
            switch (controllableAclType.getBaseId()) {
                case DOCUMENT: {
                    controllableAclObject = ACLTest.createDocument(testRootFolderId, controllableAclType.getId(), ACLTest.generateName(controllableAclType, null), null, null, null, null, null);
                    break;
                }
                case FOLDER: {
                    controllableAclObject = ACLTest.createFolder(testRootFolderId, controllableAclType.getId(), ACLTest.generateName(controllableAclType, null), null, null, null);
                    break;
                }
                case POLICY: {
                    controllableAclObject = ACLTest.createPolicy(testRootFolderId, controllableAclType.getId(), ACLTest.generateName(controllableAclType, null), null, null, null, null);
                    break;
                }
                case RELATIONSHIP: {
                    sourceId = ACLTest.createDocument(testRootFolderId, "cmis:document", ACLTest.generateName(connection.getTypeDefinition("cmis:document"), null), null, null, null, null, null);
                    targetId = ACLTest.createDocument(testRootFolderId, "cmis:document", ACLTest.generateName(connection.getTypeDefinition("cmis:document"), null), null, null, null, null, null);
                    controllableAclObject = ACLTest.createRelationship(controllableAclType.getId(), ACLTest.generateName(controllableAclType, null), sourceId, targetId, null, null, null);
                }
            }
        }
        if (notControllableAclType != null) {
            switch (notControllableAclType.getBaseId()) {
                case DOCUMENT: {
                    notControllableAclObject = ACLTest.createDocument(testRootFolderId, notControllableAclType.getId(), ACLTest.generateName(notControllableAclType, null), null, null, null, null, null);
                    break;
                }
                case FOLDER: {
                    notControllableAclObject = ACLTest.createFolder(testRootFolderId, notControllableAclType.getId(), ACLTest.generateName(notControllableAclType, null), null, null, null);
                    break;
                }
                case POLICY: {
                    notControllableAclObject = ACLTest.createPolicy(testRootFolderId, notControllableAclType.getId(), ACLTest.generateName(notControllableAclType, null), null, null, null, null);
                    break;
                }
                case RELATIONSHIP: {
                    sourceId = ACLTest.createDocument(testRootFolderId, "cmis:document", ACLTest.generateName(connection.getTypeDefinition("cmis:document"), null), null, null, null, null, null);
                    targetId = ACLTest.createDocument(testRootFolderId, "cmis:document", ACLTest.generateName(connection.getTypeDefinition("cmis:document"), null), null, null, null, null, null);
                    notControllableAclObject = ACLTest.createRelationship(notControllableAclType.getId(), ACLTest.generateName(notControllableAclType, null), sourceId, targetId, null, null, null);
                }
            }
        }
        System.out.println("Running ACL Service tests");
    }

    @AfterClass
    public static void stop() throws Exception {
        if (testRootFolderId != null) {
            ACLTest.clear(testRootFolderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApplyACL_Add() throws Exception {
        if (controllableAclObject == null) {
            return;
        }
        if (capabilities.getCapabilityACL() == CapabilityACL.MANAGE) {
            List<AccessControlEntry> acl = ACLTest.createACL(principal, "cmis:write");
            try {
                connection.applyACL(controllableAclObject, acl, null, aclCapability.getPropagation());
                List actualACL = connection.getACL(controllableAclObject, false);
                this.validateACL(acl);
                this.checkACL(acl, actualACL);
            }
            finally {
                connection.applyACL(controllableAclObject, null, acl, aclCapability.getPropagation());
            }
        }
    }

    @Test
    public void testApplyACL_ConstraintException_ACLNotMatch() throws Exception {
        if (notControllableAclObject == null) {
            return;
        }
        if (capabilities.getCapabilityACL() == CapabilityACL.MANAGE) {
            List<AccessControlEntry> acl = ACLTest.createACL(principal, "cmis:unknown");
            try {
                connection.applyACL(notControllableAclObject, acl, null, aclCapability.getPropagation());
                Assert.fail((String)"ConstraintException must be thrown since type is not controllable by ACL.");
            }
            catch (ConstraintException constraintException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testApplyACL_ConstraintException_ACLPropagation() throws Exception {
        if (controllableAclObject == null) {
            return;
        }
        if (capabilities.getCapabilityACL() == CapabilityACL.MANAGE) {
            int l = AccessControlPropagation.values().length;
            AccessControlPropagation propagation = aclCapability.getPropagation();
            int ord = propagation.ordinal();
            int p = ord == l - 1 ? ord - 1 : ord + 1;
            AccessControlPropagation propagation1 = AccessControlPropagation.values()[p];
            if (propagation != AccessControlPropagation.REPOSITORYDETERMINED) {
                try {
                    connection.applyACL(controllableAclObject, ACLTest.createACL(principal, "cmis:write"), null, propagation1);
                }
                catch (ConstraintException e) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testApplyACL_ConstraintException_NotControllable() throws Exception {
        if (notControllableAclObject == null) {
            return;
        }
        if (capabilities.getCapabilityACL() == CapabilityACL.MANAGE) {
            List<AccessControlEntry> acl = ACLTest.createACL(principal, "cmis:write");
            try {
                connection.applyACL(notControllableAclObject, acl, null, aclCapability.getPropagation());
                Assert.fail((String)"ConstraintException must be thrown since type is not controllable by ACL.");
            }
            catch (ConstraintException constraintException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testApplyACL_NotSupportedException() throws Exception {
        if (controllableAclObject != null && capabilities.getCapabilityACL() != CapabilityACL.MANAGE) {
            List<AccessControlEntry> acl = ACLTest.createACL(principal, "cmis:write");
            try {
                connection.applyACL(controllableAclObject, acl, null, aclCapability.getPropagation());
                Assert.fail((String)"NotSupportedException must be thrown since managing of ACL is not supported.");
            }
            catch (NotSupportedException notSupportedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetACL() throws Exception {
        if (capabilities.getCapabilityACL() == CapabilityACL.NONE || controllableAclObject == null) {
            return;
        }
        List actualACL = connection.getACL(controllableAclObject, false);
        if (actualACL.size() > 0) {
            HashMap m1 = new HashMap();
            CmisUtils.addAclToPermissionMap(m1, (List)actualACL);
            this.validateACL(actualACL);
        } else if (capabilities.getCapabilityACL() == CapabilityACL.MANAGE) {
            List<AccessControlEntry> acl = ACLTest.createACL(principal, "cmis:write");
            try {
                connection.applyACL(controllableAclObject, acl, null, aclCapability.getPropagation());
                actualACL = connection.getACL(controllableAclObject, false);
                this.validateACL(actualACL);
                this.checkACL(acl, actualACL);
            }
            finally {
                connection.applyACL(controllableAclObject, null, acl, aclCapability.getPropagation());
            }
        }
    }

    static {
        principal = "root";
    }
}

