/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.tck;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xcmis.spi.ChangeTokenHolder;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.NotSupportedException;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.ObjectParent;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.Updatability;
import org.xcmis.spi.model.impl.IdProperty;
import org.xcmis.spi.model.impl.StringProperty;
import org.xcmis.spi.tck.BaseTest;

public class MultifilingTest
extends BaseTest {
    private static String testRootFolderId;

    @BeforeClass
    public static void start() throws Exception {
        testRootFolderId = MultifilingTest.createFolder(rootFolderID, "cmis:folder", "acl_testroot", null, null, null);
        System.out.println("Running Multifiling Service tests");
    }

    @AfterClass
    public static void stop() throws Exception {
        if (testRootFolderId != null) {
            MultifilingTest.clear(testRootFolderId);
        }
    }

    @Test
    public void testAddObjectToFolder() throws Exception {
        if (!capabilities.isCapabilityMultifiling()) {
            return;
        }
        TypeDefinition documentType = connection.getTypeDefinition("cmis:document");
        TypeDefinition folderType = connection.getTypeDefinition("cmis:folder");
        String folder0 = MultifilingTest.createFolder(testRootFolderId, folderType.getId(), MultifilingTest.generateName(folderType, null), null, null, null);
        String document0 = MultifilingTest.createDocument(testRootFolderId, documentType.getId(), MultifilingTest.generateName(documentType, null), null, null, null, null, null);
        connection.addObjectToFolder(document0, folder0, true);
        List parents = connection.getObjectParents(document0, false, IncludeRelationships.NONE, true, true, null, "cmis:none");
        HashSet<String> parentIDs = new HashSet<String>(parents.size());
        for (ObjectParent item : parents) {
            CmisObject o = item.getObject();
            parentIDs.add(o.getObjectInfo().getId());
        }
        Assert.assertEquals((long)2L, (long)parentIDs.size());
        Assert.assertTrue((String)"Expected parent not found. ", (boolean)parentIDs.contains(folder0));
        Assert.assertTrue((String)"Expected parent not found. ", (boolean)parentIDs.contains(testRootFolderId));
        ItemsList children = connection.getChildren(folder0, false, IncludeRelationships.NONE, true, true, null, "cmis:none", null, -1, 0);
        HashSet<String> childrenIDs = new HashSet<String>(children.getItems().size());
        for (CmisObject child : children.getItems()) {
            childrenIDs.add(child.getObjectInfo().getId());
        }
        Assert.assertEquals((long)1L, (long)childrenIDs.size());
        Assert.assertTrue((String)"Expected child not found. ", (boolean)childrenIDs.contains(document0));
    }

    @Test
    public void testAddObjectToFolder_ConstraintException() throws Exception {
        if (!capabilities.isCapabilityMultifiling()) {
            return;
        }
        TypeDefinition folderType = connection.getTypeDefinition("cmis:folder");
        TypeDefinition documentType = connection.getTypeDefinition("cmis:document");
        String folder0 = MultifilingTest.createFolder(testRootFolderId, folderType.getId(), MultifilingTest.generateName(folderType, null), null, null, null);
        StringBuilder filter = new StringBuilder();
        filter.append("cmis:allowedChildObjectTypeIds").append(',').append("cmis:changeToken");
        Map folderProperties = connection.getProperties(folder0, true, filter.toString()).getProperties();
        StringProperty changeTokenProperty = (StringProperty)folderProperties.get("cmis:changeToken");
        TypeDefinition fileableTypeDefinition = null;
        PropertyDefinition childIdPropertyDefinition = folderType.getPropertyDefinition("cmis:allowedChildObjectTypeIds");
        Updatability updatability = childIdPropertyDefinition.getUpdatability();
        if (updatability == Updatability.READWRITE) {
            ChangeTokenHolder holder = new ChangeTokenHolder();
            if (changeTokenProperty != null && changeTokenProperty.getValues().size() > 0) {
                holder.setValue(changeTokenProperty.getValues().get(0));
            }
            HashMap<String, IdProperty> properties = new HashMap<String, IdProperty>();
            properties.put(childIdPropertyDefinition.getId(), new IdProperty(childIdPropertyDefinition.getId(), childIdPropertyDefinition.getQueryName(), childIdPropertyDefinition.getLocalName(), childIdPropertyDefinition.getDisplayName(), folderType.getId()));
            connection.updateProperties(folder0, holder, properties);
            fileableTypeDefinition = documentType;
        }
        if (fileableTypeDefinition == null) {
            return;
        }
        String documentO = MultifilingTest.createDocument(testRootFolderId, documentType.getId(), MultifilingTest.generateName(documentType, null), null, null, null, null, null);
        try {
            connection.addObjectToFolder(documentO, folder0, true);
            Assert.fail((String)"ConstraintException must be thrown since type 'cmis:document' is not allowed as child.");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
    }

    @Test
    public void testAddObjectToFolder_NotSupported() throws Exception {
        if (capabilities.isCapabilityMultifiling()) {
            return;
        }
        TypeDefinition documentType = connection.getTypeDefinition("cmis:document");
        TypeDefinition folderType = connection.getTypeDefinition("cmis:folder");
        String folder0 = MultifilingTest.createFolder(testRootFolderId, folderType.getId(), MultifilingTest.generateName(folderType, null), null, null, null);
        String documentO = MultifilingTest.createDocument(testRootFolderId, documentType.getId(), MultifilingTest.generateName(documentType, null), null, null, null, null, null);
        try {
            connection.addObjectToFolder(documentO, folder0, true);
        }
        catch (NotSupportedException e) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveObjectFromFolder() throws Exception {
        if (!capabilities.isCapabilityUnfiling()) {
            return;
        }
        TypeDefinition documentType = connection.getTypeDefinition("cmis:document");
        String document0 = MultifilingTest.createDocument(testRootFolderId, documentType.getId(), MultifilingTest.generateName(documentType, null), null, null, null, null, null);
        connection.removeObjectFromFolder(document0, testRootFolderId);
        List parents = connection.getObjectParents(document0, false, IncludeRelationships.NONE, true, true, null, "cmis:none");
        Assert.assertTrue((String)"Parents list must be empty. ", (boolean)parents.isEmpty());
        ItemsList children = connection.getChildren(testRootFolderId, false, IncludeRelationships.NONE, true, true, null, "cmis:none", null, -1, 0);
        HashSet<String> childrenIDs = new HashSet<String>(children.getItems().size());
        for (CmisObject child : children.getItems()) {
            childrenIDs.add(child.getObjectInfo().getId());
        }
        Assert.assertTrue((String)"Object must be removed from folder. ", (!childrenIDs.contains(document0) ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveObjectFromFolder2() throws Exception {
        if (!capabilities.isCapabilityMultifiling()) {
            return;
        }
        TypeDefinition documentType = connection.getTypeDefinition("cmis:document");
        TypeDefinition folderType = connection.getTypeDefinition("cmis:folder");
        String folder0 = MultifilingTest.createFolder(testRootFolderId, folderType.getId(), MultifilingTest.generateName(folderType, null), null, null, null);
        String document0 = MultifilingTest.createDocument(testRootFolderId, documentType.getId(), MultifilingTest.generateName(documentType, null), null, null, null, null, null);
        connection.addObjectToFolder(document0, folder0, true);
        List parents = connection.getObjectParents(document0, false, IncludeRelationships.NONE, true, true, null, "cmis:none");
        Assert.assertEquals((long)2L, (long)parents.size());
        ItemsList children = connection.getChildren(folder0, false, IncludeRelationships.NONE, true, true, null, "cmis:none", null, -1, 0);
        Assert.assertEquals((long)1L, (long)children.getItems().size());
        connection.removeObjectFromFolder(document0, folder0);
        parents = connection.getObjectParents(document0, false, IncludeRelationships.NONE, true, true, null, "cmis:none");
        Assert.assertEquals((long)1L, (long)parents.size());
        children = connection.getChildren(folder0, false, IncludeRelationships.NONE, true, true, null, "cmis:none", null, -1, 0);
        Assert.assertTrue((String)"Object must be removed from folder. ", (boolean)children.getItems().isEmpty());
    }

    @Test
    public void testUnfile() throws Exception {
        if (!capabilities.isCapabilityUnfiling()) {
            return;
        }
        TypeDefinition documentType = connection.getTypeDefinition("cmis:document");
        String document0 = MultifilingTest.createDocument(testRootFolderId, documentType.getId(), MultifilingTest.generateName(documentType, null), null, null, null, null, null);
        String folder0 = null;
        if (capabilities.isCapabilityMultifiling()) {
            TypeDefinition folderType = connection.getTypeDefinition("cmis:folder");
            folder0 = MultifilingTest.createFolder(testRootFolderId, folderType.getId(), MultifilingTest.generateName(folderType, null), null, null, null);
            connection.addObjectToFolder(document0, folder0, true);
        }
        connection.removeObjectFromFolder(document0, null);
        List parents = connection.getObjectParents(document0, false, IncludeRelationships.NONE, true, true, null, "cmis:none");
        Assert.assertTrue((String)"Parents list must be empty. ", (boolean)parents.isEmpty());
        ItemsList children = connection.getChildren(testRootFolderId, false, IncludeRelationships.NONE, true, true, null, "cmis:none", null, -1, 0);
        HashSet<String> childrenIDs = new HashSet<String>(children.getItems().size());
        for (CmisObject child : children.getItems()) {
            childrenIDs.add(child.getObjectInfo().getId());
        }
        Assert.assertTrue((String)"Object must be removed from folder. ", (!childrenIDs.contains(document0) ? 1 : 0) != 0);
        if (folder0 != null) {
            children = connection.getChildren(folder0, false, IncludeRelationships.NONE, true, true, null, "cmis:none", null, -1, 0);
            Assert.assertTrue((String)"Object must be removed from folder. ", (boolean)children.getItems().isEmpty());
        }
    }
}

