/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.tck;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.xcmis.spi.BaseContentStream;
import org.xcmis.spi.ChangeTokenHolder;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentAlreadyExistsException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.StreamNotSupportedException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.AllowableActions;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.CapabilityACL;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.ContentStreamAllowed;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.ObjectParent;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.UnfileObject;
import org.xcmis.spi.model.VersioningState;
import org.xcmis.spi.model.impl.IdProperty;
import org.xcmis.spi.model.impl.StringProperty;
import org.xcmis.spi.tck.BaseTest;
import org.xcmis.spi.utils.MimeType;

public class ObjectTest
extends BaseTest {
    private static String testRootFolderId;
    private static TypeDefinition folderType;
    private static TypeDefinition documentType;
    private static TypeDefinition folderTypeControllableAcl;
    private static TypeDefinition folderTypeNotControllableAcl;
    private static TypeDefinition folderTypeControllablePolicy;
    private static TypeDefinition folderTypeNotControllablePolicy;
    private static TypeDefinition documentTypeStreamNotSupported;
    private static TypeDefinition documentTypeStreamRequired;
    private static TypeDefinition documentTypeControllableAcl;
    private static TypeDefinition documentTypeNotControllableAcl;
    private static TypeDefinition documentTypeControllablePolicy;
    private static TypeDefinition documentTypeNotControllablePolicy;
    private static TypeDefinition documentTypeVersionable;
    private static TypeDefinition documentTypeNotVersionable;
    private static TypeDefinition policyType;
    private static TypeDefinition policyTypeControllableAcl;
    private static TypeDefinition policyTypeNotControllableAcl;
    private static TypeDefinition policyTypeControllablePolicy;
    private static TypeDefinition policyTypeNotControllablePolicy;
    private static TypeDefinition relationshipType;
    private static TypeDefinition relationshipTypeControllableAcl;
    private static TypeDefinition relationshipTypeNotControllableAcl;
    private static TypeDefinition relationshipTypeControllablePolicy;
    private static TypeDefinition relationshipTypeNotControllablePolicy;
    private String principal = "root";

    @BeforeClass
    public static void start() throws Exception {
        folderType = connection.getTypeDefinition("cmis:folder");
        List allFolders = connection.getTypeDescendants(folderType.getId(), -1, true);
        if (folderType.isControllableACL()) {
            folderTypeControllableAcl = folderType;
        } else {
            folderTypeNotControllableAcl = folderType;
        }
        if (folderTypeControllableAcl == null) {
            folderTypeControllableAcl = ObjectTest.getControllableAclType(allFolders);
        }
        if (folderTypeNotControllableAcl == null) {
            folderTypeNotControllableAcl = ObjectTest.getNotControllableAclType(allFolders);
        }
        if (folderType.isControllablePolicy()) {
            folderTypeControllablePolicy = folderType;
        } else {
            folderTypeNotControllablePolicy = folderType;
        }
        if (folderTypeControllablePolicy == null) {
            folderTypeControllablePolicy = ObjectTest.getControllablePolicyType(allFolders);
        }
        if (folderTypeNotControllablePolicy == null) {
            folderTypeNotControllablePolicy = ObjectTest.getNotControllablePolicyType(allFolders);
        }
        documentType = connection.getTypeDefinition("cmis:document");
        List allDocs = connection.getTypeDescendants(documentType.getId(), -1, true);
        if (documentType.isControllableACL()) {
            documentTypeControllableAcl = documentType;
        } else {
            documentTypeNotControllableAcl = documentType;
        }
        if (documentTypeControllableAcl == null) {
            documentTypeControllableAcl = ObjectTest.getControllableAclType(allDocs);
        }
        if (documentTypeNotControllableAcl == null) {
            documentTypeNotControllableAcl = ObjectTest.getNotControllableAclType(allDocs);
        }
        if (documentType.isControllablePolicy()) {
            documentTypeControllablePolicy = documentType;
        } else {
            documentTypeNotControllablePolicy = documentType;
        }
        if (documentTypeControllablePolicy == null) {
            documentTypeControllablePolicy = ObjectTest.getControllablePolicyType(allDocs);
        }
        if (documentTypeNotControllablePolicy == null) {
            documentTypeNotControllablePolicy = ObjectTest.getNotControllablePolicyType(allDocs);
        }
        if (documentType.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED) {
            documentTypeStreamNotSupported = documentType;
        }
        if (documentTypeStreamNotSupported == null) {
            documentTypeStreamNotSupported = ObjectTest.getStreamNotSupportedDocType(allDocs);
        }
        if (documentType.getContentStreamAllowed() == ContentStreamAllowed.REQUIRED) {
            documentTypeStreamRequired = documentType;
        }
        if (documentTypeStreamRequired == null) {
            documentTypeStreamRequired = ObjectTest.getStreamNotSupportedDocType(allDocs);
        }
        if (!documentType.isVersionable()) {
            documentTypeNotVersionable = documentType;
        } else {
            documentTypeVersionable = documentType;
        }
        if (documentTypeNotVersionable == null) {
            documentTypeNotVersionable = ObjectTest.getNotVersionableDocType(allDocs);
        }
        if (documentTypeVersionable == null) {
            documentTypeVersionable = ObjectTest.getVersionableDocType(allDocs);
        }
        if (isPoliciesSupported) {
            policyType = connection.getTypeDefinition("cmis:policy");
            List allPolicies = connection.getTypeDescendants(policyType.getId(), -1, true);
            if (policyType.isControllableACL()) {
                policyTypeControllableAcl = policyType;
            } else {
                policyTypeNotControllableAcl = policyType;
            }
            if (policyTypeControllableAcl == null) {
                policyTypeControllableAcl = ObjectTest.getControllableAclType(allPolicies);
            }
            if (policyTypeNotControllableAcl == null) {
                policyTypeNotControllableAcl = ObjectTest.getNotControllableAclType(allPolicies);
            }
            if (policyType.isControllablePolicy()) {
                policyTypeControllablePolicy = policyType;
            } else {
                policyTypeNotControllablePolicy = policyType;
            }
            if (policyTypeControllablePolicy == null) {
                policyTypeControllablePolicy = ObjectTest.getControllablePolicyType(allPolicies);
            }
            if (policyTypeNotControllablePolicy == null) {
                policyTypeNotControllablePolicy = ObjectTest.getNotControllablePolicyType(allPolicies);
            }
        }
        if (isRelationshipsSupported) {
            relationshipType = connection.getTypeDefinition("cmis:relationship");
            List allRelationships = connection.getTypeDescendants(relationshipType.getId(), -1, true);
            if (relationshipType.isControllableACL()) {
                relationshipTypeControllableAcl = relationshipType;
            } else {
                relationshipTypeNotControllableAcl = relationshipType;
            }
            if (relationshipTypeControllableAcl == null) {
                relationshipTypeControllableAcl = ObjectTest.getControllableAclType(allRelationships);
            }
            if (relationshipTypeNotControllableAcl == null) {
                relationshipTypeNotControllableAcl = ObjectTest.getNotControllableAclType(allRelationships);
            }
            if (relationshipType.isControllablePolicy()) {
                relationshipTypeControllablePolicy = relationshipType;
            } else {
                relationshipTypeNotControllablePolicy = relationshipType;
            }
            if (relationshipTypeControllablePolicy == null) {
                relationshipTypeControllablePolicy = ObjectTest.getControllablePolicyType(allRelationships);
            }
            if (relationshipTypeNotControllablePolicy == null) {
                relationshipTypeNotControllablePolicy = ObjectTest.getNotControllablePolicyType(allRelationships);
            }
        }
        testRootFolderId = ObjectTest.createFolder(rootFolderID, folderType.getId(), "object_testroot", null, null, null);
        System.out.println("Running Object Service tests");
    }

    @AfterClass
    public static void stop() throws Exception {
        if (testRootFolderId != null) {
            ObjectTest.clear(testRootFolderId);
        }
    }

    @Test
    public void testCreateDocument_Content() throws Exception {
        Map<String, Property<?>> properties;
        StringProperty nameProperty;
        String template = "1234567890aBcDE";
        BaseContentStream content = null;
        if (documentType.getContentStreamAllowed() != ContentStreamAllowed.NOT_ALLOWED) {
            byte[] before = template.getBytes();
            content = new BaseContentStream(before, null, new MimeType("text", "plain"));
        }
        if ((nameProperty = (StringProperty)(properties = ObjectTest.createPropertyMap(documentType)).get("cmis:name")) != null) {
            nameProperty.getValues().add("testCreateDocument_CheckContent.txt");
        }
        String docId = connection.createDocument(testRootFolderId, properties, (ContentStream)content, null, null, null, documentType.isVersionable() ? VersioningState.MAJOR : VersioningState.NONE);
        if (content != null) {
            ContentStream content1 = connection.getContentStream(docId, null);
            Assert.assertEquals((Object)content.getMediaType(), (Object)content1.getMediaType());
            byte[] buf = new byte[1024];
            int read = content1.getStream().read(buf);
            Assert.assertEquals((Object)template, (Object)new String(buf, 0, read));
        } else {
            try {
                connection.getContentStream(docId, null);
                Assert.fail((String)"ConstraintException must be throw, content stream not allowed. ");
            }
            catch (ConstraintException e) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateDocument_ApplyPolicy() throws Exception {
        if (documentTypeControllablePolicy == null) {
            return;
        }
        String policyId = ObjectTest.createPolicy(policyType.isFileable() ? testRootFolderId : null, policyType.getId(), ObjectTest.generateName(policyType, null), "policy1", null, null, null);
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(documentTypeControllablePolicy);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateDocument_ApplyPolicy");
        }
        String docId = connection.createDocument(testRootFolderId, properties, documentTypeControllablePolicy.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : BaseTest.TEST_CONTENT_STREAM, null, null, Arrays.asList(policyId), documentTypeControllablePolicy.isVersionable() ? VersioningState.MAJOR : VersioningState.NONE);
        List policies = connection.getAppliedPolicies(docId, true, null);
        Assert.assertEquals((long)1L, (long)policies.size());
        Assert.assertEquals((Object)policyId, (Object)((CmisObject)policies.get(0)).getObjectInfo().getId());
    }

    @Test
    public void testCreateDocument_ApplyACL() throws Exception {
        if (documentTypeControllableAcl == null || capabilities.getCapabilityACL() != CapabilityACL.MANAGE) {
            return;
        }
        List<AccessControlEntry> acl = ObjectTest.createACL(this.principal, "cmis:all");
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(documentTypeControllableAcl);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateDocument_ApplyACL");
        }
        String docId = connection.createDocument(testRootFolderId, properties, documentTypeControllableAcl.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : BaseTest.TEST_CONTENT_STREAM, acl, null, null, documentTypeControllableAcl.isVersionable() ? VersioningState.MAJOR : VersioningState.NONE);
        List actualACL = connection.getACL(docId, false);
        this.validateACL(actualACL);
        this.checkACL(acl, actualACL);
    }

    @Test
    public void testCreateDocument_NameConstraintViolationException() throws Exception {
        String name = "testCreateDocument_NameConstraintViolationException";
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(documentType);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add(name);
        }
        connection.createDocument(testRootFolderId, properties, documentType.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : BaseTest.TEST_CONTENT_STREAM, null, null, null, documentType.isVersionable() ? VersioningState.MAJOR : VersioningState.NONE);
        try {
            String docId2 = connection.createDocument(testRootFolderId, properties, documentType.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : BaseTest.TEST_CONTENT_STREAM, null, null, null, documentType.isVersionable() ? VersioningState.MAJOR : VersioningState.NONE);
            CmisObject doc2 = connection.getObject(docId2, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
            String name2 = doc2.getObjectInfo().getName();
            Assert.assertFalse((String)"NameConstraintViolationException must be throw or different name chosen. ", (boolean)name.equals(name2));
        }
        catch (NameConstraintViolationException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreateDocument_StreamNotSupportedException() throws Exception {
        if (documentTypeStreamNotSupported == null) {
            return;
        }
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(documentTypeStreamNotSupported);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateDocument_StreamNotSupportedException");
        }
        try {
            connection.createDocument(testRootFolderId, properties, BaseTest.TEST_CONTENT_STREAM, null, null, null, documentTypeStreamNotSupported.isVersionable() ? VersioningState.MAJOR : VersioningState.NONE);
            Assert.fail((String)"StreamNotSupportedException must be thrown. ");
        }
        catch (StreamNotSupportedException streamNotSupportedException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateDocument_ConstraintException_ObjectType() throws Exception {
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(documentType);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateDocument_ConstraintException_ObjectType");
        }
        IdProperty property = (IdProperty)properties.get("cmis:objectTypeId");
        property.getValues().clear();
        property.getValues().add(folderType.getId());
        try {
            connection.createDocument(testRootFolderId, properties, documentType.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : BaseTest.TEST_CONTENT_STREAM, null, null, null, documentType.isVersionable() ? VersioningState.MAJOR : VersioningState.NONE);
            Assert.fail((String)"ConstraintException must be thrown.");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreateDocument_ConstraintException_ContentRequired() throws Exception {
        if (documentTypeStreamRequired == null) {
            return;
        }
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(documentTypeStreamRequired);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateDocument_ConstraintException_ContentRequired");
        }
        try {
            connection.createDocument(testRootFolderId, properties, null, null, null, null, documentTypeStreamRequired.isVersionable() ? VersioningState.MAJOR : VersioningState.NONE);
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateDocument_ConstraintException_Versionable() throws Exception {
        if (documentTypeVersionable == null) {
            return;
        }
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(documentTypeVersionable);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateDocument_ConstraintException_Versionable");
        }
        try {
            connection.createDocument(testRootFolderId, properties, documentTypeVersionable.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : BaseTest.TEST_CONTENT_STREAM, null, null, null, VersioningState.NONE);
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    @Ignore
    public void testCreateDocument_ConstraintException_NonVersionable() throws Exception {
        if (documentTypeNotVersionable == null) {
            return;
        }
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(documentTypeNotVersionable);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateDocument_ConstraintException_NonVersionable");
        }
        try {
            connection.createDocument(testRootFolderId, properties, documentTypeNotVersionable.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : BaseTest.TEST_CONTENT_STREAM, null, null, null, VersioningState.MAJOR);
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateDocument_ConstraintException_NotControllablePolicy() throws Exception {
        if (!isPoliciesSupported || documentTypeNotControllablePolicy == null) {
            return;
        }
        String policy = ObjectTest.createPolicy(testRootFolderId, policyType.getId(), ObjectTest.generateName(policyType, null), "__TEST_POLICY__", null, null, null);
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(documentTypeNotControllablePolicy);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateDocument_ConstraintException_NotControllablePolicy");
        }
        try {
            connection.createDocument(testRootFolderId, properties, documentTypeNotControllablePolicy.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : BaseTest.TEST_CONTENT_STREAM, null, null, Arrays.asList(policy), documentTypeNotControllablePolicy.isVersionable() ? VersioningState.MAJOR : VersioningState.NONE);
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreateDocument_ConstraintException_NotControllableACL() throws Exception {
        if (!capabilities.getCapabilityACL().equals((Object)CapabilityACL.MANAGE) || documentTypeNotControllableAcl == null) {
            return;
        }
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(documentTypeNotControllableAcl);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateDocument_ConstraintException_NotControllableACL");
        }
        try {
            connection.createDocument(testRootFolderId, properties, documentTypeNotControllableAcl.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : BaseTest.TEST_CONTENT_STREAM, ObjectTest.createACL(this.principal, "cmis:all"), null, null, documentTypeNotControllableAcl.isVersionable() ? VersioningState.MAJOR : VersioningState.NONE);
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateDocument_ConstraintException_ACENotSupported() throws Exception {
        if (!capabilities.getCapabilityACL().equals((Object)CapabilityACL.MANAGE) || documentTypeControllableAcl == null) {
            return;
        }
        if (documentTypeControllableAcl != null) {
            Map<String, Property<?>> properties = ObjectTest.createPropertyMap(documentTypeControllableAcl);
            StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
            if (nameProperty != null) {
                nameProperty.getValues().add("testCreateDocument_ConstraintException_ACENotSupported");
            }
            try {
                List<AccessControlEntry> acl = ObjectTest.createACL(this.principal, "cmis:unknown");
                connection.createDocument(testRootFolderId, properties, documentTypeControllableAcl.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : BaseTest.TEST_CONTENT_STREAM, acl, null, null, documentTypeControllableAcl.isVersionable() ? VersioningState.MAJOR : VersioningState.NONE);
                Assert.fail((String)"ConstraintException must be thrown. ");
            }
            catch (ConstraintException constraintException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateDocumentFromSource_Content() throws Exception {
        String name = ObjectTest.generateName(documentType, null);
        String document = ObjectTest.createDocument(testRootFolderId, documentType.getId(), name, documentType.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED ? null : BaseTest.TEST_CONTENT_STREAM, null, null, null, null);
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(documentType);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add(name + "_copy");
        }
        String documentCopy = connection.createDocumentFromSource(document, testRootFolderId, properties, null, null, null, documentType.isVersionable() ? VersioningState.MAJOR : VersioningState.NONE);
        try {
            connection.getObject(documentCopy, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        }
        catch (ObjectNotFoundException e) {
            Assert.fail((String)"Can't get newly created object. ");
        }
        if (documentType.getContentStreamAllowed() != ContentStreamAllowed.NOT_ALLOWED) {
            ContentStream content = connection.getContentStream(documentCopy, null);
            byte[] buf = new byte[1024];
            int read = content.getStream().read(buf);
            byte[] res = new byte[read];
            System.arraycopy(buf, 0, res, 0, read);
            Assert.assertArrayEquals((byte[])TEST_CONTENT, (byte[])res);
        } else {
            try {
                connection.getContentStream(documentCopy, null);
                Assert.fail((String)"ConstraintException must be throw, content stream not allowed. ");
            }
            catch (ConstraintException e) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateFolder() throws Exception {
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(folderType);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateFolder");
        }
        String folderId = connection.createFolder(testRootFolderId, properties, null, null, null);
        try {
            connection.getObject(folderId, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        }
        catch (ObjectNotFoundException e) {
            Assert.fail((String)"Unable get newly create folder by id. ");
        }
        String path = "/object_testroot/testCreateFolder";
        try {
            connection.getObjectByPath(path, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        }
        catch (ObjectNotFoundException e) {
            Assert.fail((String)"Unable get newly create folder by path. ");
        }
    }

    @Test
    public void testCreateFolder_ApplyPolicy() throws Exception {
        if (folderTypeControllablePolicy == null || !isPoliciesSupported) {
            return;
        }
        String policyId = ObjectTest.createPolicy(policyType.isFileable() ? testRootFolderId : null, policyType.getId(), ObjectTest.generateName(policyType, null), "policy1", null, null, null);
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(folderTypeControllablePolicy);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateFolder_ApplyPolicy");
        }
        String folderId = connection.createFolder(testRootFolderId, properties, null, null, Arrays.asList(policyId));
        List policies = connection.getAppliedPolicies(folderId, true, null);
        Assert.assertEquals((long)1L, (long)policies.size());
        Assert.assertEquals((Object)policyId, (Object)((CmisObject)policies.get(0)).getObjectInfo().getId());
    }

    @Test
    public void testCreateFolder_ApplyACL() throws Exception {
        if (folderTypeControllableAcl == null || capabilities.getCapabilityACL() != CapabilityACL.MANAGE) {
            return;
        }
        List<AccessControlEntry> acl = ObjectTest.createACL(this.principal, "cmis:all");
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(folderTypeControllableAcl);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateFolder_ApplyACL");
        }
        String folderId = connection.createFolder(testRootFolderId, properties, acl, null, null);
        List actualACL = connection.getACL(folderId, false);
        this.validateACL(actualACL);
        this.checkACL(acl, actualACL);
    }

    @Test
    public void testCreateFolder_NameConstraintViolationException() throws Exception {
        String name = "testCreateFolder_NameConstraintViolationException";
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(folderType);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add(name);
        }
        connection.createFolder(testRootFolderId, properties, null, null, null);
        try {
            String folderId2 = connection.createFolder(testRootFolderId, properties, null, null, null);
            CmisObject folder2 = connection.getObject(folderId2, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
            String name2 = folder2.getObjectInfo().getName();
            Assert.assertFalse((String)"NameConstraintViolationException must be throw or different name chosen. ", (boolean)name.equals(name2));
        }
        catch (NameConstraintViolationException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFolder_ConstraintException_ObjectType() throws Exception {
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(folderType);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateFolder_ConstraintException_ObjectType");
        }
        IdProperty property = (IdProperty)properties.get("cmis:objectTypeId");
        property.getValues().clear();
        property.getValues().add(documentType.getId());
        try {
            connection.createFolder(testRootFolderId, properties, null, null, null);
            Assert.fail((String)"ConstraintException must be thrown.");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFolder_ConstraintException_NotControllablePolicy() throws Exception {
        if (!isPoliciesSupported || folderTypeNotControllablePolicy == null) {
            return;
        }
        if (folderTypeNotControllablePolicy != null) {
            String policy = ObjectTest.createPolicy(testRootFolderId, policyType.getId(), ObjectTest.generateName(policyType, null), "__TEST_POLICY__", null, null, null);
            Map<String, Property<?>> properties = ObjectTest.createPropertyMap(folderTypeNotControllablePolicy);
            StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
            if (nameProperty != null) {
                nameProperty.getValues().add("testCreateFolder_ConstraintException_NotControllablePolicy");
            }
            try {
                connection.createFolder(testRootFolderId, properties, null, null, Arrays.asList(policy));
                Assert.fail((String)"ConstraintException must be thrown. ");
            }
            catch (ConstraintException e) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateFolder_ConstraintException_ACENotSupported() throws Exception {
        if (!capabilities.getCapabilityACL().equals((Object)CapabilityACL.MANAGE) || folderTypeControllableAcl == null) {
            return;
        }
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(folderTypeControllableAcl);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateFolder_ConstraintException_ACENotSupported");
        }
        try {
            List<AccessControlEntry> acl = ObjectTest.createACL(this.principal, "cmis:unknown");
            connection.createFolder(testRootFolderId, properties, acl, null, null);
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateFolder_ConstraintException_NotControllableACL() throws Exception {
        if (!capabilities.getCapabilityACL().equals((Object)CapabilityACL.MANAGE) || folderTypeNotControllableAcl == null) {
            return;
        }
        if (folderTypeNotControllableAcl != null) {
            Map<String, Property<?>> properties = ObjectTest.createPropertyMap(folderTypeNotControllableAcl);
            StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
            if (nameProperty != null) {
                nameProperty.getValues().add("testCreateFolder_ConstraintException_NotControllableACL");
            }
            try {
                connection.createFolder(testRootFolderId, properties, ObjectTest.createACL(this.principal, "cmis:all"), null, null);
                Assert.fail((String)"ConstraintException must be thrown. ");
            }
            catch (ConstraintException constraintException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateRelationship() throws Exception {
        IdProperty targetIdProperty;
        IdProperty sourceIdProperty;
        if (!isRelationshipsSupported) {
            return;
        }
        String source = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        String target = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(relationshipType);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateRelationship");
        }
        if ((sourceIdProperty = (IdProperty)properties.get("cmis:sourceId")) != null) {
            sourceIdProperty.getValues().add(source);
        }
        if ((targetIdProperty = (IdProperty)properties.get("cmis:targetId")) != null) {
            targetIdProperty.getValues().add(target);
        }
        String relationshipId = connection.createRelationship(properties, null, null, null);
        try {
            connection.getObject(relationshipId, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        }
        catch (ObjectNotFoundException e) {
            Assert.fail((String)"Unable get newly create relationship. ");
        }
    }

    @Test
    public void testCreateRelationship_ApplyPolicy() throws Exception {
        IdProperty targetIdProperty;
        IdProperty sourceIdProperty;
        if (!isRelationshipsSupported || !isPoliciesSupported || relationshipTypeControllablePolicy == null) {
            return;
        }
        String source = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        String target = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        String policy = ObjectTest.createPolicy(policyType.isFileable() ? testRootFolderId : null, policyType.getId(), ObjectTest.generateName(policyType, null), "policy1", null, null, null);
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(relationshipTypeControllablePolicy);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateRelationship_ApplyPolicy");
        }
        if ((sourceIdProperty = (IdProperty)properties.get("cmis:sourceId")) != null) {
            sourceIdProperty.getValues().add(source);
        }
        if ((targetIdProperty = (IdProperty)properties.get("cmis:targetId")) != null) {
            targetIdProperty.getValues().add(target);
        }
        String relationshipId = connection.createRelationship(properties, null, null, Arrays.asList(policy));
        List policies = connection.getAppliedPolicies(relationshipId, true, null);
        Assert.assertEquals((long)1L, (long)policies.size());
        Assert.assertEquals((Object)policy, (Object)((CmisObject)policies.get(0)).getObjectInfo().getId());
    }

    @Test
    public void testCreateRelationship_ApplyACL() throws Exception {
        IdProperty targetIdProperty;
        IdProperty sourceIdProperty;
        if (!isRelationshipsSupported || relationshipTypeControllableAcl == null || capabilities.getCapabilityACL() != CapabilityACL.MANAGE) {
            return;
        }
        String source = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        String target = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        List<AccessControlEntry> acl = ObjectTest.createACL(this.principal, "cmis:all");
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(relationshipTypeControllableAcl);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateRelationship_ApplyACL");
        }
        if ((sourceIdProperty = (IdProperty)properties.get("cmis:sourceId")) != null) {
            sourceIdProperty.getValues().add(source);
        }
        if ((targetIdProperty = (IdProperty)properties.get("cmis:targetId")) != null) {
            targetIdProperty.getValues().add(target);
        }
        String relationshipId = connection.createRelationship(properties, acl, null, null);
        List actualACL = connection.getACL(relationshipId, false);
        this.validateACL(actualACL);
        this.checkACL(acl, actualACL);
    }

    @Test
    @Ignore
    public void testCreateRelationship_NameConstraintViolationException() throws Exception {
        IdProperty targetIdProperty;
        IdProperty sourceIdProperty;
        if (!isRelationshipsSupported) {
            return;
        }
        String name = "testCreateRelationship_NameConstraintViolationException";
        String source = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        String target = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(relationshipType);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add(name);
        }
        if ((sourceIdProperty = (IdProperty)properties.get("cmis:sourceId")) != null) {
            sourceIdProperty.getValues().add(source);
        }
        if ((targetIdProperty = (IdProperty)properties.get("cmis:targetId")) != null) {
            targetIdProperty.getValues().add(target);
        }
        connection.createRelationship(properties, null, null, null);
        try {
            String relationshipId2 = connection.createRelationship(properties, null, null, null);
            CmisObject relationship2 = connection.getObject(relationshipId2, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
            String name2 = relationship2.getObjectInfo().getName();
            Assert.assertFalse((String)"NameConstraintViolationException must be throw or different name chosen. ", (boolean)name.equals(name2));
        }
        catch (NameConstraintViolationException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreateRelationship_ConstraintException_ObjectType() throws Exception {
        IdProperty targetIdProperty;
        IdProperty sourceIdProperty;
        if (!isRelationshipsSupported) {
            return;
        }
        String name = "testCreateRelationship_ConstraintException_ObjectType";
        String source = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        String target = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(relationshipType);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add(name);
        }
        if ((sourceIdProperty = (IdProperty)properties.get("cmis:sourceId")) != null) {
            sourceIdProperty.getValues().add(source);
        }
        if ((targetIdProperty = (IdProperty)properties.get("cmis:targetId")) != null) {
            targetIdProperty.getValues().add(target);
        }
        IdProperty property = (IdProperty)properties.get("cmis:objectTypeId");
        property.getValues().clear();
        property.getValues().add(documentType.getId());
        try {
            connection.createRelationship(properties, null, null, null);
            Assert.fail((String)"ConstraintException must be thrown.");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreateRelationship_ConstraintException_NotControllablePolicy() throws Exception {
        IdProperty targetIdProperty;
        IdProperty sourceIdProperty;
        if (!isRelationshipsSupported || !isPoliciesSupported || relationshipTypeNotControllablePolicy == null) {
            return;
        }
        String source = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        String target = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        String policy = ObjectTest.createPolicy(policyType.isFileable() ? testRootFolderId : null, policyType.getId(), ObjectTest.generateName(policyType, null), "policy1", null, null, null);
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(relationshipTypeNotControllablePolicy);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateRelationship_ConstraintException_NotControllablePolicy");
        }
        if ((sourceIdProperty = (IdProperty)properties.get("cmis:sourceId")) != null) {
            sourceIdProperty.getValues().add(source);
        }
        if ((targetIdProperty = (IdProperty)properties.get("cmis:targetId")) != null) {
            targetIdProperty.getValues().add(target);
        }
        try {
            connection.createRelationship(properties, null, null, Arrays.asList(policy));
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreateRelationship_ConstraintException_NotControllableACL() throws Exception {
        IdProperty targetIdProperty;
        IdProperty sourceIdProperty;
        if (!isRelationshipsSupported || capabilities.getCapabilityACL() != CapabilityACL.MANAGE || relationshipTypeNotControllableAcl == null) {
            return;
        }
        String source = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        String target = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        List<AccessControlEntry> acl = ObjectTest.createACL(this.principal, "cmis:all");
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(relationshipTypeNotControllableAcl);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateRelationship_ConstraintException_NotControllableACL");
        }
        if ((sourceIdProperty = (IdProperty)properties.get("cmis:sourceId")) != null) {
            sourceIdProperty.getValues().add(source);
        }
        if ((targetIdProperty = (IdProperty)properties.get("cmis:targetId")) != null) {
            targetIdProperty.getValues().add(target);
        }
        try {
            connection.createRelationship(properties, acl, null, null);
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreateRelationship_ConstraintException_ACENotSupported() throws Exception {
        IdProperty targetIdProperty;
        IdProperty sourceIdProperty;
        if (!isRelationshipsSupported || !capabilities.getCapabilityACL().equals((Object)CapabilityACL.MANAGE) || relationshipTypeControllableAcl == null) {
            return;
        }
        String source = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        String target = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        List<AccessControlEntry> acl = ObjectTest.createACL(this.principal, "cmis:unknown");
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(relationshipTypeControllableAcl);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateRelationship_ConstraintException_ACENotSupported");
        }
        if ((sourceIdProperty = (IdProperty)properties.get("cmis:sourceId")) != null) {
            sourceIdProperty.getValues().add(source);
        }
        if ((targetIdProperty = (IdProperty)properties.get("cmis:targetId")) != null) {
            targetIdProperty.getValues().add(target);
        }
        try {
            connection.createRelationship(properties, acl, null, null);
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreatePolicy() throws Exception {
        StringProperty policyText;
        if (!isPoliciesSupported) {
            return;
        }
        String test = "test create policy";
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(policyType);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreatePolicy");
        }
        if ((policyText = (StringProperty)properties.get("cmis:policyText")) != null) {
            policyText.getValues().add(test);
        }
        String policyId = connection.createPolicy(policyType.isFileable() ? testRootFolderId : null, properties, null, null, null);
        CmisObject policy = null;
        try {
            policy = connection.getObject(policyId, false, IncludeRelationships.NONE, false, false, true, "cmis:policyText", "cmis:none");
        }
        catch (ObjectNotFoundException e) {
            Assert.fail((String)"Unable get newly create policy. ");
        }
        Assert.assertNotNull(policy);
        Assert.assertEquals((Object)"testCreatePolicy", (Object)policy.getObjectInfo().getName());
        StringProperty textProperty = (StringProperty)policy.getProperties().get("cmis:policyText");
        Assert.assertTrue((String)"Unable get policy text. ", (textProperty != null && textProperty.getValues().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)test, textProperty.getValues().get(0));
    }

    @Test
    public void testCreatePolicy_ApplyPolicy() throws Exception {
        StringProperty policyText;
        if (!isPoliciesSupported || policyTypeControllablePolicy == null) {
            return;
        }
        String policy1 = ObjectTest.createPolicy(policyType.isFileable() ? testRootFolderId : null, policyType.getId(), ObjectTest.generateName(policyType, null), "policy1", null, null, null);
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(policyTypeControllablePolicy);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreatePolicy_ApplyPolicy");
        }
        if ((policyText = (StringProperty)properties.get("cmis:policyText")) != null) {
            policyText.getValues().add("__TEST_POLICY__");
        }
        String policyId = connection.createPolicy(policyTypeControllablePolicy.isFileable() ? testRootFolderId : null, properties, null, null, Arrays.asList(policy1));
        List policies = connection.getAppliedPolicies(policyId, true, null);
        Assert.assertEquals((long)1L, (long)policies.size());
        Assert.assertEquals((Object)policy1, (Object)((CmisObject)policies.get(0)).getObjectInfo().getId());
    }

    @Test
    public void testCreatePolicy_ApplyACL() throws Exception {
        StringProperty policyText;
        if (!isPoliciesSupported || policyTypeControllableAcl == null || capabilities.getCapabilityACL() != CapabilityACL.MANAGE) {
            return;
        }
        List<AccessControlEntry> acl = ObjectTest.createACL(this.principal, "cmis:all");
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(policyTypeControllableAcl);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreatePolicy_ApplyACL");
        }
        if ((policyText = (StringProperty)properties.get("cmis:policyText")) != null) {
            policyText.getValues().add("__TEST_POLICY__");
        }
        String policyId = connection.createPolicy(policyTypeControllableAcl.isFileable() ? testRootFolderId : null, properties, acl, null, null);
        List actualACL = connection.getACL(policyId, false);
        this.validateACL(actualACL);
        this.checkACL(acl, actualACL);
    }

    @Test
    public void testCreatePolicy_NameConstraintViolationException() throws Exception {
        StringProperty policyText;
        if (!isPoliciesSupported || !policyType.isFileable()) {
            return;
        }
        String name = "testCreatePolicy_NameConstraintViolationException";
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(policyType);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add(name);
        }
        if ((policyText = (StringProperty)properties.get("cmis:policyText")) != null) {
            policyText.getValues().add("__TEST_POLICY__");
        }
        connection.createPolicy(policyType.isFileable() ? testRootFolderId : null, properties, null, null, null);
        try {
            String policyId2 = connection.createPolicy(policyType.isFileable() ? testRootFolderId : null, properties, null, null, null);
            CmisObject policy2 = connection.getObject(policyId2, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
            String name2 = policy2.getObjectInfo().getName();
            Assert.assertFalse((String)"NameConstraintViolationException must be throw or different name chosen. ", (boolean)name.equals(name2));
        }
        catch (NameConstraintViolationException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreatePolicy_ConstraintException_ObjectType() throws Exception {
        StringProperty policyText;
        if (!isPoliciesSupported) {
            return;
        }
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(policyType);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreatePolicy_ConstraintException_ObjectType");
        }
        if ((policyText = (StringProperty)properties.get("cmis:policyText")) != null) {
            policyText.getValues().add("__TEST_POLICY__");
        }
        IdProperty property = (IdProperty)properties.get("cmis:objectTypeId");
        property.getValues().clear();
        property.getValues().add(documentType.getId());
        try {
            connection.createPolicy(policyType.isFileable() ? testRootFolderId : null, properties, null, null, null);
            Assert.fail((String)"ConstraintException must be thrown.");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreatePolicy_ConstraintException_NotControllablePolicy() throws Exception {
        StringProperty policyText;
        if (!isPoliciesSupported || policyTypeNotControllablePolicy == null) {
            return;
        }
        String policy1 = ObjectTest.createPolicy(policyType.isFileable() ? testRootFolderId : null, policyType.getId(), ObjectTest.generateName(policyType, null), "policy1", null, null, null);
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(policyTypeNotControllablePolicy);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreatePolicy_ConstraintException_NotControllablePolicy");
        }
        if ((policyText = (StringProperty)properties.get("cmis:policyText")) != null) {
            policyText.getValues().add("__TEST_POLICY__");
        }
        try {
            connection.createPolicy(policyTypeNotControllablePolicy.isFileable() ? testRootFolderId : null, properties, null, null, Arrays.asList(policy1));
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreatePolicy_ConstraintException_NotControllableACL() throws Exception {
        StringProperty policyText;
        if (!isPoliciesSupported || policyTypeNotControllableAcl == null) {
            return;
        }
        List<AccessControlEntry> acl = ObjectTest.createACL(this.principal, "cmis:all");
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(policyTypeNotControllableAcl);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreatePolicy_ConstraintException_NotControllablePolicy");
        }
        if ((policyText = (StringProperty)properties.get("cmis:policyText")) != null) {
            policyText.getValues().add("__TEST_POLICY__");
        }
        try {
            connection.createPolicy(policyTypeNotControllableAcl.isFileable() ? testRootFolderId : null, properties, acl, null, null);
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
    }

    @Test
    public void testCreatePolicy_ConstraintException_ACENotSupported() throws Exception {
        StringProperty policyText;
        if (!isPoliciesSupported || !capabilities.getCapabilityACL().equals((Object)CapabilityACL.MANAGE) || policyTypeControllableAcl == null) {
            return;
        }
        List<AccessControlEntry> acl = ObjectTest.createACL(this.principal, "cmis:unknown");
        Map<String, Property<?>> properties = ObjectTest.createPropertyMap(policyTypeControllableAcl);
        StringProperty nameProperty = (StringProperty)properties.get("cmis:name");
        if (nameProperty != null) {
            nameProperty.getValues().add("testCreateRelationship_ConstraintException_ACENotSupported");
        }
        if ((policyText = (StringProperty)properties.get("cmis:policyText")) != null) {
            policyText.getValues().add("__TEST_POLICY__");
        }
        try {
            connection.createPolicy(policyTypeControllableAcl.isFileable() ? testRootFolderId : null, properties, acl, null, null);
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
    }

    @Test
    public void testGetAllowableActions_Simlpe() throws Exception {
        AllowableActions actions = connection.getAllowableActions(testRootFolderId);
        Assert.assertNotNull((String)"Unable get allowable actions. ", (Object)actions);
    }

    @Test
    public void testGetObject() throws Exception {
        CmisObject o = connection.getObject(testRootFolderId, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        Assert.assertEquals((Object)testRootFolderId, (Object)o.getObjectInfo().getId());
        Assert.assertNull((Object)o.getAllowableActions());
        Assert.assertEquals((long)0L, (long)o.getPolicyIds().size());
        Assert.assertEquals((long)0L, (long)o.getRelationship().size());
        Assert.assertEquals((long)0L, (long)o.getRenditions().size());
    }

    @Test
    public void testGetObject_PropertyFiltered() throws Exception {
        CmisObject o = connection.getObject(testRootFolderId, false, IncludeRelationships.NONE, false, false, true, "cmis:name,cmis:path", "cmis:none");
        BaseType baseType = o.getObjectInfo().getBaseType();
        HashSet<String> queryNames = new HashSet<String>();
        for (Map.Entry e : o.getProperties().entrySet()) {
            queryNames.add(((Property)e.getValue()).getQueryName());
        }
        Assert.assertEquals((Object)baseType, (Object)BaseType.FOLDER);
        Assert.assertEquals((long)2L, (long)queryNames.size());
        for (String q : queryNames) {
            Assert.assertTrue((String)("Unexpected property " + q + " in result. "), (q.equalsIgnoreCase("cmis:name") || q.equalsIgnoreCase("cmis:path") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetObject_IncludeRelationships() throws Exception {
        if (!isRelationshipsSupported) {
            return;
        }
        String relationship = ObjectTest.createRelationship(relationshipType.getId(), ObjectTest.generateName(relationshipType, null), testRootFolderId, testRootFolderId, null, null, null);
        CmisObject o = connection.getObject(testRootFolderId, false, IncludeRelationships.BOTH, false, false, true, null, "cmis:none");
        Assert.assertTrue((o.getRelationship().size() >= 1 ? 1 : 0) != 0);
        HashSet<String> r = new HashSet<String>();
        for (CmisObject rel : o.getRelationship()) {
            r.add(rel.getObjectInfo().getId());
        }
        Assert.assertTrue((String)("Expected relationship " + relationship + " not found in result. "), (boolean)r.contains(relationship));
    }

    @Test
    public void testGetObject_IncludePolicy() throws Exception {
        if (!isPoliciesSupported || !folderType.isControllablePolicy()) {
            return;
        }
        String policy = ObjectTest.createPolicy(policyType.isFileable() ? testRootFolderId : null, policyType.getId(), ObjectTest.generateName(relationshipType, null), "__TEST_POLICY__", null, null, null);
        connection.applyPolicy(policy, testRootFolderId);
        CmisObject o = connection.getObject(testRootFolderId, false, IncludeRelationships.NONE, true, false, true, null, "cmis:none");
        Assert.assertTrue((o.getPolicyIds().size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected policy " + policy + " not found in result. "), (boolean)o.getPolicyIds().contains(policy));
    }

    @Test
    public void testGetObject_IncludeACL() throws Exception {
        if (capabilities.getCapabilityACL() != CapabilityACL.MANAGE || documentTypeControllableAcl == null) {
            return;
        }
        List<AccessControlEntry> acl = ObjectTest.createACL(this.principal, "cmis:all");
        String documentId = ObjectTest.createDocument(testRootFolderId, documentTypeControllableAcl.getId(), ObjectTest.generateName(documentTypeControllableAcl, null), null, acl, null, null, null);
        CmisObject o = connection.getObject(documentId, false, IncludeRelationships.NONE, false, true, true, null, "cmis:none");
        List actualACL = o.getACL();
        this.validateACL(actualACL);
        this.checkACL(acl, actualACL);
    }

    @Test
    public void testGetObject_IncludeAllowableActions() throws Exception {
        String documentId = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        CmisObject o = connection.getObject(documentId, true, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        Assert.assertNotNull((Object)o.getAllowableActions());
    }

    @Test
    public void testGetObjectByPath() throws Exception {
        CmisObject o = connection.getObjectByPath("/object_testroot", false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        Assert.assertEquals((Object)testRootFolderId, (Object)o.getObjectInfo().getId());
        Assert.assertNull((Object)o.getAllowableActions());
        Assert.assertEquals((long)0L, (long)o.getPolicyIds().size());
        Assert.assertEquals((long)0L, (long)o.getRelationship().size());
        Assert.assertEquals((long)0L, (long)o.getRenditions().size());
    }

    @Test
    public void testGetObjectByPath_PropertyFiltered() throws Exception {
        CmisObject o = connection.getObjectByPath("/object_testroot", false, IncludeRelationships.NONE, false, false, true, "cmis:name,cmis:path", "cmis:none");
        BaseType baseType = o.getObjectInfo().getBaseType();
        HashSet<String> queryNames = new HashSet<String>();
        for (Map.Entry e : o.getProperties().entrySet()) {
            queryNames.add(((Property)e.getValue()).getQueryName());
        }
        Assert.assertEquals((Object)baseType, (Object)BaseType.FOLDER);
        Assert.assertEquals((long)2L, (long)queryNames.size());
        for (String q : queryNames) {
            Assert.assertTrue((String)("Unexpected property " + q + " in result. "), (q.equalsIgnoreCase("cmis:name") || q.equalsIgnoreCase("cmis:path") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetObjectByPath_IncludeRelationships() throws Exception {
        if (!isRelationshipsSupported) {
            return;
        }
        String relationship = ObjectTest.createRelationship(relationshipType.getId(), ObjectTest.generateName(relationshipType, null), testRootFolderId, testRootFolderId, null, null, null);
        CmisObject o = connection.getObjectByPath("/object_testroot", false, IncludeRelationships.BOTH, false, false, true, null, "cmis:none");
        Assert.assertTrue((o.getRelationship().size() >= 1 ? 1 : 0) != 0);
        HashSet<String> r = new HashSet<String>();
        for (CmisObject rel : o.getRelationship()) {
            r.add(rel.getObjectInfo().getId());
        }
        Assert.assertTrue((String)("Expected relationship " + relationship + " not found in result. "), (boolean)r.contains(relationship));
    }

    @Test
    public void testGetObjectByPath_IncludePolicy() throws Exception {
        if (!isPoliciesSupported || !folderType.isControllablePolicy()) {
            return;
        }
        String policy = ObjectTest.createPolicy(policyType.isFileable() ? testRootFolderId : null, policyType.getId(), ObjectTest.generateName(relationshipType, null), "__TEST_POLICY__", null, null, null);
        connection.applyPolicy(policy, testRootFolderId);
        CmisObject o = connection.getObjectByPath("/object_testroot", false, IncludeRelationships.NONE, true, false, true, null, "cmis:none");
        Assert.assertTrue((o.getPolicyIds().size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected policy " + policy + " not found in result. "), (boolean)o.getPolicyIds().contains(policy));
    }

    @Test
    public void testGetObjectByPath_IncludeAllowableActions() throws Exception {
        CmisObject o = connection.getObjectByPath("/object_testroot", true, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
        Assert.assertNotNull((Object)o.getAllowableActions());
    }

    @Test
    public void testGetContentStream() throws Exception {
        Map<String, Property<?>> properties;
        StringProperty nameProperty;
        String template = "TEST_GET_CONTENT";
        BaseContentStream content = null;
        if (documentType.getContentStreamAllowed() != ContentStreamAllowed.NOT_ALLOWED) {
            byte[] before = template.getBytes();
            content = new BaseContentStream(before, null, new MimeType("text", "plain"));
        }
        if ((nameProperty = (StringProperty)(properties = ObjectTest.createPropertyMap(documentType)).get("cmis:name")) != null) {
            nameProperty.getValues().add("testGetContentStream.txt");
        }
        String document = connection.createDocument(testRootFolderId, properties, (ContentStream)content, null, null, null, documentType.isVersionable() ? VersioningState.MAJOR : VersioningState.NONE);
        if (content != null) {
            if (content != null) {
                ContentStream content1 = connection.getContentStream(document, null);
                Assert.assertEquals((Object)content.getMediaType(), (Object)content1.getMediaType());
                byte[] buf = new byte[1024];
                int read = content1.getStream().read(buf);
                Assert.assertEquals((Object)template, (Object)new String(buf, 0, read));
            } else {
                try {
                    connection.getContentStream(document, null);
                    Assert.fail((String)"ConstraintException must be throw, content stream not allowed. ");
                }
                catch (ConstraintException e) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testDeleteContentStream() throws Exception {
        if (documentType.getContentStreamAllowed() != ContentStreamAllowed.ALLOWED) {
            return;
        }
        String document = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), TEST_CONTENT_STREAM, null, null, null, null);
        Map documentProperties = connection.getProperties(document, true, "cmis:changeToken").getProperties();
        StringProperty changeTokenProperty = (StringProperty)documentProperties.get("cmis:changeToken");
        ChangeTokenHolder holder = new ChangeTokenHolder();
        if (changeTokenProperty != null && changeTokenProperty.getValues().size() > 0) {
            holder.setValue(changeTokenProperty.getValues().get(0));
        }
        connection.deleteContentStream(document, holder);
        try {
            connection.getContentStream(document, null);
            Assert.fail((String)"ConstraintException must be thrown since document has not content stream. ");
        }
        catch (ConstraintException e) {
            // empty catch block
        }
    }

    @Test
    public void testMove() throws Exception {
        String document = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        String folder = ObjectTest.createFolder(testRootFolderId, folderType.getId(), ObjectTest.generateName(folderType, null), null, null, null);
        document = connection.moveObject(document, folder, testRootFolderId);
        List parents = connection.getObjectParents(document, false, IncludeRelationships.NONE, false, true, null, "cmis:none");
        Assert.assertEquals((Object)folder, (Object)((ObjectParent)parents.get(0)).getObject().getObjectInfo().getId());
    }

    @Test
    public void testMove_InvalidArgumentException_Missing() throws Exception {
        String document = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        String folder = ObjectTest.createFolder(testRootFolderId, folderType.getId(), ObjectTest.generateName(folderType, null), null, null, null);
        try {
            connection.moveObject(document, folder, null);
            Assert.fail((String)"InvalidArgumentException must be thrown. ");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMove_InvalidArgumentException_NotMatch() throws Exception {
        String document = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        String folder = ObjectTest.createFolder(testRootFolderId, folderType.getId(), ObjectTest.generateName(folderType, null), null, null, null);
        try {
            connection.moveObject(document, folder, folder);
            Assert.fail((String)"InvalidArgumentException must be thrown. ");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteObject() throws Exception {
        String document = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        connection.deleteObject(document, Boolean.valueOf(true));
        try {
            connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
            Assert.fail((String)"Object must be removed. ");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteObject_ConstraintException() throws Exception {
        String folder = ObjectTest.createFolder(testRootFolderId, folderType.getId(), ObjectTest.generateName(documentType, null), null, null, null);
        ObjectTest.createDocument(folder, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        try {
            connection.deleteObject(folder, Boolean.valueOf(true));
            Assert.fail((String)"ConstraintException must be thrown. ");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteTree() throws Exception {
        String folder = ObjectTest.createFolder(testRootFolderId, folderType.getId(), ObjectTest.generateName(documentType, null), null, null, null);
        String document = ObjectTest.createDocument(folder, documentType.getId(), ObjectTest.generateName(documentType, null), null, null, null, null, null);
        connection.deleteTree(folder, Boolean.valueOf(true), UnfileObject.DELETE, Boolean.valueOf(false));
        try {
            connection.getObject(document, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
            Assert.fail((String)"Document must be removed. ");
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        try {
            connection.getObject(folder, false, IncludeRelationships.NONE, false, false, true, null, "cmis:none");
            Assert.fail((String)"Folder must be removed. ");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testSetContentStream() throws Exception {
        if (documentType.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED) {
            return;
        }
        String document = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, "txt"), null, null, null, null, null);
        byte[] newContent = "UPDATED_CONTENT".getBytes();
        document = connection.setContentStream(document, (ContentStream)new BaseContentStream(newContent, "", new MimeType("text", "plain")), new ChangeTokenHolder(), Boolean.valueOf(true));
        ContentStream content = connection.getContentStream(document, null);
        Assert.assertEquals((Object)content.getMediaType(), (Object)content.getMediaType());
        byte[] buf = new byte[1024];
        int read = content.getStream().read(buf);
        byte[] res = new byte[read];
        System.arraycopy(buf, 0, res, 0, read);
        Assert.assertArrayEquals((byte[])newContent, (byte[])res);
    }

    @Test
    public void testSetContentStream_ContentAlreadyExistsException() throws Exception {
        if (documentType.getContentStreamAllowed() == ContentStreamAllowed.NOT_ALLOWED) {
            return;
        }
        String document = ObjectTest.createDocument(testRootFolderId, documentType.getId(), ObjectTest.generateName(documentType, "txt"), TEST_CONTENT_STREAM, null, null, null, null);
        byte[] newContent = "UPDATED_CONTENT".getBytes();
        try {
            connection.setContentStream(document, (ContentStream)new BaseContentStream(newContent, "", new MimeType("text", "plain")), new ChangeTokenHolder(), Boolean.valueOf(false));
            Assert.fail((String)"ContentAlreadyExistsException must be thrown. ");
        }
        catch (ContentAlreadyExistsException contentAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testSetContentStream_StreamNotSupportedException() throws Exception {
        if (documentTypeStreamNotSupported == null) {
            return;
        }
        String document = ObjectTest.createDocument(testRootFolderId, documentTypeStreamNotSupported.getId(), ObjectTest.generateName(documentTypeStreamNotSupported, "txt"), null, null, null, null, null);
        byte[] newContent = "_CONTENT_".getBytes();
        try {
            connection.setContentStream(document, (ContentStream)new BaseContentStream(newContent, "", new MimeType("text", "plain")), new ChangeTokenHolder(), Boolean.valueOf(false));
            Assert.fail((String)"StreamNotSupportedException must be thrown. ");
        }
        catch (StreamNotSupportedException streamNotSupportedException) {
            // empty catch block
        }
    }
}

