/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.Connection;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.StorageProvider;
import org.xcmis.spi.model.RepositoryShortInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmisRegistry {
    private static AtomicReference<CmisRegistry> service = new AtomicReference();
    protected List<String> providers = new ArrayList<String>();
    protected Map<String, StorageProvider> storageProviders = new HashMap<String, StorageProvider>();

    public static CmisRegistry getInstance() {
        CmisRegistry s = service.get();
        if (s == null) {
            service.compareAndSet(null, new CmisRegistry());
            s = service.get();
        }
        return s;
    }

    public static void setInstance(CmisRegistry inst) {
        service.set(inst);
    }

    protected CmisRegistry() {
    }

    public final void addStorage(StorageProvider storageProvider) {
        String id = storageProvider.getStorageID();
        if (this.storageProviders.get(id) != null) {
            throw new CmisRuntimeException("Storage " + id + " already registered.");
        }
        this.storageProviders.put(id, storageProvider);
    }

    public final Connection getConnection(String storageId) {
        StorageProvider storageProvider = this.storageProviders.get(storageId);
        if (storageProvider == null) {
            throw new InvalidArgumentException("Storage '" + storageId + "' does not exist.");
        }
        return storageProvider.getConnection();
    }

    public final Set<RepositoryShortInfo> getStorageInfos() {
        HashSet<RepositoryShortInfo> set = new HashSet<RepositoryShortInfo>();
        for (String id : this.storageProviders.keySet()) {
            RepositoryShortInfo info = new RepositoryShortInfo(id, id);
            info.setRootFolderId(this.storageProviders.get(id).getConnection().getStorage().getRepositoryInfo().getRootFolderId());
            set.add(info);
        }
        return Collections.unmodifiableSet(set);
    }

    public void addRenditionProvider(String provider) {
        if (provider != null) {
            this.providers.add(provider);
        }
    }
}

