/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.utils;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.document.DocumentReader;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.document.HandlerNotFoundException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.HTMLDocumentReader;
import org.exoplatform.services.document.impl.MSExcelDocumentReader;
import org.exoplatform.services.document.impl.MSOutlookDocumentReader;
import org.exoplatform.services.document.impl.MSWordDocumentReader;
import org.exoplatform.services.document.impl.OpenOfficeDocumentReader;
import org.exoplatform.services.document.impl.PPTDocumentReader;
import org.exoplatform.services.document.impl.TextPlainDocumentReader;
import org.exoplatform.services.document.impl.XMLDocumentReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.spi.utils.CmisPDFDocumentReader;

public class CmisDocumentReaderService
implements DocumentReaderService {
    private static final Log LOG = ExoLogger.getLogger(CmisDocumentReaderService.class);
    private Map<String, BaseDocumentReader> readers = new HashMap<String, BaseDocumentReader>();

    public CmisDocumentReaderService() {
        this.addDocumentReader((ComponentPlugin)new CmisPDFDocumentReader());
        this.addDocumentReader((ComponentPlugin)new MSWordDocumentReader());
        this.addDocumentReader((ComponentPlugin)new MSExcelDocumentReader());
        this.addDocumentReader((ComponentPlugin)new MSOutlookDocumentReader());
        this.addDocumentReader((ComponentPlugin)new PPTDocumentReader());
        this.addDocumentReader((ComponentPlugin)new HTMLDocumentReader(null));
        this.addDocumentReader((ComponentPlugin)new XMLDocumentReader());
        this.addDocumentReader((ComponentPlugin)new OpenOfficeDocumentReader());
        this.addDocumentReader((ComponentPlugin)new TextPlainDocumentReader(new InitParams()));
    }

    public String getContentAsText(String mimeType, InputStream is) throws Exception {
        BaseDocumentReader reader = this.readers.get(mimeType.toLowerCase());
        if (reader != null) {
            return reader.getContentAsText(is);
        }
        throw new Exception("Cannot handle the document type: " + mimeType);
    }

    public DocumentReader getDocumentReader(String mimeType) throws HandlerNotFoundException {
        BaseDocumentReader reader = this.readers.get(mimeType.toLowerCase());
        if (reader != null) {
            return reader;
        }
        throw new HandlerNotFoundException("No appropriate properties extractor for " + mimeType);
    }

    public void addDocumentReader(ComponentPlugin plugin) {
        BaseDocumentReader reader = (BaseDocumentReader)plugin;
        for (String mimeType : reader.getMimeTypes()) {
            this.readers.put(mimeType.toLowerCase(), reader);
        }
    }
}

