/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.wssoap.impl;

import javax.jws.WebService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.messaging.CmisExtensionType;
import org.xcmis.soap.CmisException;
import org.xcmis.soap.MultiFilingServicePort;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.Connection;
import org.xcmis.wssoap.impl.ExceptionFactory;

@WebService(serviceName="MultiFilingService", portName="MultiFilingServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", wsdlLocation="/wsdl/CMISWS-Service.wsdl")
public class MultiFilingServicePortImpl
implements MultiFilingServicePort {
    private static final Log LOG = ExoLogger.getLogger(MultiFilingServicePortImpl.class);

    public CmisExtensionType addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing operation addObjectToFolder");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            conn.addObjectToFolder(objectId, folderId, allVersions.booleanValue());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return new CmisExtensionType();
    }

    public CmisExtensionType removeObjectFromFolder(String repositoryId, String objectId, String folderId, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing operation removeObjectFromFolder");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            conn.removeObjectFromFolder(objectId, folderId);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return new CmisExtensionType();
    }
}

