/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.wssoap.impl;

import java.util.List;
import javax.jws.WebService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.core.CmisObjectType;
import org.xcmis.messaging.CmisExtensionType;
import org.xcmis.soap.CmisException;
import org.xcmis.soap.PolicyServicePort;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.Connection;
import org.xcmis.wssoap.impl.ExceptionFactory;
import org.xcmis.wssoap.impl.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="PolicyService", portName="PolicyServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", wsdlLocation="/wsdl/CMISWS-Service.wsdl")
public class PolicyServicePortImpl
implements PolicyServicePort {
    private static final Log LOG = ExoLogger.getLogger(PolicyServicePortImpl.class);

    @Override
    public CmisExtensionType applyPolicy(String repositoryId, String policyId, String objectId, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing operation applyPolicy");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            conn.applyPolicy(policyId, objectId);
        }
        catch (Exception e) {
            LOG.error((Object)("Apply policy error: " + e.getMessage()), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return new CmisExtensionType();
    }

    @Override
    public List<CmisObjectType> getAppliedPolicies(String repositoryId, String objectId, String propertyFilter, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing operation getAppliedPolicies");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            List<CmisObjectType> list = TypeConverter.getCmisObjectTypeList(conn.getAppliedPolicies(objectId, true, propertyFilter));
            return list;
        }
        catch (Exception e) {
            LOG.error((Object)("Get applied policies error: " + e.getMessage()), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public CmisExtensionType removePolicy(String repositoryId, String policyId, String objectId, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Executing operation removePolicy");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            conn.removePolicy(policyId, objectId);
        }
        catch (Exception e) {
            LOG.error((Object)("Remove applied policy error: " + e.getMessage()), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return new CmisExtensionType();
    }
}

