/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.wssoap.impl.server;

import java.util.ArrayList;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.EndpointImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.wssoap.impl.ACLServicePortImpl;
import org.xcmis.wssoap.impl.DiscoveryServicePortImpl;
import org.xcmis.wssoap.impl.MultiFilingServicePortImpl;
import org.xcmis.wssoap.impl.NavigationServicePortImpl;
import org.xcmis.wssoap.impl.ObjectServicePortImpl;
import org.xcmis.wssoap.impl.PolicyServicePortImpl;
import org.xcmis.wssoap.impl.RelationshipServicePortImpl;
import org.xcmis.wssoap.impl.RepositoryServicePortImpl;
import org.xcmis.wssoap.impl.VersioningServicePortImpl;

public class WebServiceLoader {
    private static final Log LOG = ExoLogger.getLogger(WebServiceLoader.class);

    public void init() {
        this.init(null);
    }

    public void init(String baseURL) {
        ArrayList<Object> services = new ArrayList<Object>();
        services.add(new ACLServicePortImpl());
        services.add(new DiscoveryServicePortImpl());
        services.add(new MultiFilingServicePortImpl());
        services.add(new NavigationServicePortImpl());
        services.add(new ObjectServicePortImpl());
        services.add(new PolicyServicePortImpl());
        services.add(new RelationshipServicePortImpl());
        services.add(new RepositoryServicePortImpl());
        services.add(new VersioningServicePortImpl());
        for (Object e : services) {
            String address = this.getAddress(baseURL, e);
            if (address == null) continue;
            WebServiceLoader.deployService(address, e);
            LOG.info((Object)("New singleton WebService '" + address + "' registered."));
        }
    }

    private String getAddress(String baseURL, Object implementor) {
        String serviceName = implementor.getClass().getAnnotation(WebService.class).serviceName();
        String portName = implementor.getClass().getAnnotation(WebService.class).portName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" serviceName = " + serviceName));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" portName = " + portName));
        }
        String address = new String();
        if (baseURL != null && baseURL.length() != 0) {
            address = address + baseURL;
        }
        if (serviceName != null && serviceName.length() != 0) {
            address = address + "/" + serviceName;
        }
        if (portName != null && portName.length() != 0) {
            address = address + "/" + portName;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getAddress() - address = " + address));
            LOG.debug((Object)("getAddress() - implementor = " + implementor));
        }
        return address;
    }

    public static Endpoint simpleDeployService(String address, Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting Service: object = " + object + " at the address = " + address));
        }
        Endpoint endpoint = Endpoint.publish((String)address, (Object)object);
        if (LOG.isDebugEnabled()) {
            EndpointImpl endpointImpl = (EndpointImpl)endpoint;
            ServerImpl server = endpointImpl.getServer();
            server.getEndpoint().getInInterceptors().add(new LoggingInInterceptor());
            server.getEndpoint().getOutInterceptors().add(new LoggingOutInterceptor());
        }
        if (endpoint.isPublished()) {
            LOG.info((Object)("The webservice '" + address + "' has been published SUCCESSFUL!"));
        }
        return endpoint;
    }

    static Endpoint deployService(String address, Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting Service: object = " + object + " at the address = " + address));
        }
        Endpoint endpoint = Endpoint.publish((String)address, (Object)object);
        if (LOG.isDebugEnabled()) {
            EndpointImpl endpointImpl = (EndpointImpl)endpoint;
            ServerImpl server = endpointImpl.getServer();
            server.getEndpoint().getInInterceptors().add(new LoggingInInterceptor());
            server.getEndpoint().getOutInterceptors().add(new LoggingOutInterceptor());
        }
        if (endpoint.isPublished()) {
            LOG.info((Object)("The webservice '" + address + "' has been published SUCCESSFUL!"));
        }
        return endpoint;
    }
}

