/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.wssoap.impl;

import org.xcmis.messaging.CmisFaultType;
import org.xcmis.messaging.EnumServiceException;
import org.xcmis.soap.CmisException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentAlreadyExistsException;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.NotSupportedException;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.PermissionDeniedException;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.StreamNotSupportedException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;

public class ExceptionFactory {
    public static CmisException generateException(Exception param) throws CmisException {
        CmisFaultType fault = new CmisFaultType();
        String msg = param.getMessage();
        fault.setMessage(msg);
        if (param instanceof ConstraintException) {
            fault.setType(EnumServiceException.CONSTRAINT);
        } else if (param instanceof ContentAlreadyExistsException) {
            fault.setType(EnumServiceException.CONTENT_ALREADY_EXISTS);
        } else if (param instanceof FilterNotValidException) {
            fault.setType(EnumServiceException.FILTER_NOT_VALID);
        } else if (param instanceof InvalidArgumentException) {
            fault.setType(EnumServiceException.INVALID_ARGUMENT);
        } else if (param instanceof ConstraintException) {
            fault.setType(EnumServiceException.NAME_CONSTRAINT_VIOLATION);
        } else if (param instanceof NotSupportedException) {
            fault.setType(EnumServiceException.NOT_SUPPORTED);
        } else if (param instanceof ObjectNotFoundException) {
            fault.setType(EnumServiceException.OBJECT_NOT_FOUND);
        } else if (param instanceof PermissionDeniedException) {
            fault.setType(EnumServiceException.PERMISSION_DENIED);
        } else if (param instanceof StorageException) {
            fault.setType(EnumServiceException.STORAGE);
        } else if (param instanceof StreamNotSupportedException) {
            fault.setType(EnumServiceException.STREAM_NOT_SUPPORTED);
        } else if (param instanceof UpdateConflictException) {
            fault.setType(EnumServiceException.UPDATE_CONFLICT);
        } else if (param instanceof VersioningException) {
            fault.setType(EnumServiceException.VERSIONING);
        } else {
            fault.setType(EnumServiceException.RUNTIME);
        }
        return new CmisException(msg, fault, param);
    }
}

