/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.wssoap.impl;

import java.util.List;
import javax.jws.WebService;
import org.xcmis.core.CmisObjectType;
import org.xcmis.messaging.CmisExtensionType;
import org.xcmis.soap.CmisException;
import org.xcmis.soap.PolicyServicePort;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.Connection;
import org.xcmis.spi.utils.Logger;
import org.xcmis.wssoap.impl.ExceptionFactory;
import org.xcmis.wssoap.impl.TypeConverter;

@WebService(serviceName="PolicyService", portName="PolicyServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", wsdlLocation="/wsdl/CMISWS-Service.wsdl")
public class PolicyServicePortImpl
implements PolicyServicePort {
    private static final Logger LOG = Logger.getLogger(PolicyServicePortImpl.class);

    @Override
    public CmisExtensionType applyPolicy(String repositoryId, String policyId, String objectId, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation applyPolicy");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            conn.applyPolicy(policyId, objectId);
        }
        catch (Exception e) {
            LOG.error("Apply policy error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return new CmisExtensionType();
    }

    @Override
    public List<CmisObjectType> getAppliedPolicies(String repositoryId, String objectId, String propertyFilter, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation getAppliedPolicies");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            List<CmisObjectType> list = TypeConverter.getCmisObjectTypeList(conn.getAppliedPolicies(objectId, false, propertyFilter));
            return list;
        }
        catch (Exception e) {
            LOG.error("Get applied policies error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public CmisExtensionType removePolicy(String repositoryId, String policyId, String objectId, CmisExtensionType extension) throws CmisException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing operation removePolicy");
        }
        Connection conn = null;
        try {
            conn = CmisRegistry.getInstance().getConnection(repositoryId);
            conn.removePolicy(policyId, objectId);
        }
        catch (Exception e) {
            LOG.error("Remove applied policy error: " + e.getMessage(), (Throwable)e);
            throw ExceptionFactory.generateException(e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return new CmisExtensionType();
    }
}

