/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.newmatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.parser.PropertyValue;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;

public class CascadedStyle {
    private final Map<CSSName, PropertyDeclaration> cascadedProperties;
    private String fingerprint;
    public static final CascadedStyle emptyCascadedStyle = new CascadedStyle(new TreeMap<CSSName, PropertyDeclaration>());

    public static CascadedStyle createAnonymousStyle(IdentValue display) {
        PropertyValue val = new PropertyValue(display);
        List<PropertyDeclaration> props = Collections.singletonList(new PropertyDeclaration(CSSName.DISPLAY, val, true, StylesheetInfo.Origin.USER));
        return new CascadedStyle(props);
    }

    public static CascadedStyle createLayoutStyle(PropertyDeclaration ... declarations) {
        return new CascadedStyle(Arrays.asList(declarations));
    }

    public static CascadedStyle createLayoutStyle(List<PropertyDeclaration> declarations) {
        return new CascadedStyle(declarations);
    }

    public static CascadedStyle createLayoutStyle(CascadedStyle startingPoint, PropertyDeclaration[] decls) {
        return new CascadedStyle(startingPoint.cascadedProperties, Arrays.asList(decls).iterator());
    }

    public static PropertyDeclaration createLayoutPropertyDeclaration(CSSName cssName, IdentValue display) {
        PropertyValue val = new PropertyValue(display);
        return new PropertyDeclaration(cssName, val, true, StylesheetInfo.Origin.USER);
    }

    CascadedStyle(Iterable<PropertyDeclaration> iter) {
        this(Collections.emptyMap(), iter.iterator());
    }

    private CascadedStyle(Map<CSSName, PropertyDeclaration> startingPoint, Iterator<PropertyDeclaration> iter) {
        ArrayList buckets = new ArrayList(6);
        for (int i = 0; i < 6; ++i) {
            buckets.add(new ArrayList());
        }
        while (iter.hasNext()) {
            PropertyDeclaration prop = iter.next();
            ((List)buckets.get(prop.getImportanceAndOrigin())).add(prop);
        }
        TreeMap<CSSName, PropertyDeclaration> cascadedProperties = new TreeMap<CSSName, PropertyDeclaration>(startingPoint);
        for (List list : buckets) {
            for (PropertyDeclaration prop : list) {
                cascadedProperties.put(prop.getCSSName(), prop);
            }
        }
        this.cascadedProperties = cascadedProperties;
    }

    private CascadedStyle(Map<CSSName, PropertyDeclaration> cascadedProperties) {
        this.cascadedProperties = cascadedProperties;
    }

    public boolean hasProperty(CSSName cssName) {
        return this.cascadedProperties.containsKey(cssName);
    }

    public PropertyDeclaration propertyByName(CSSName cssName) {
        return this.cascadedProperties.get(cssName);
    }

    public IdentValue getIdent(CSSName cssName) {
        PropertyDeclaration pd = this.propertyByName(cssName);
        return pd == null ? null : pd.asIdentValue();
    }

    public Iterator<PropertyDeclaration> getCascadedPropertyDeclarations() {
        ArrayList<PropertyDeclaration> list = new ArrayList<PropertyDeclaration>(this.cascadedProperties.size());
        list.addAll(this.cascadedProperties.values());
        return list.iterator();
    }

    public int countAssigned() {
        return this.cascadedProperties.size();
    }

    public String getFingerprint() {
        if (this.fingerprint == null) {
            StringBuilder sb = new StringBuilder();
            for (PropertyDeclaration propertyDeclaration : this.cascadedProperties.values()) {
                sb.append(propertyDeclaration.getFingerprint());
            }
            this.fingerprint = sb.toString();
        }
        return this.fingerprint;
    }
}

