/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.PDFAsImage;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.swing.NaiveUserAgent;
import org.xhtmlrenderer.util.ImageUtil;
import org.xhtmlrenderer.util.XRLog;

public class ITextUserAgent
extends NaiveUserAgent {
    private static final int IMAGE_CACHE_CAPACITY = 32;
    private SharedContext _sharedContext;
    private final ITextOutputDevice _outputDevice;

    public ITextUserAgent(ITextOutputDevice outputDevice) {
        super(32);
        this._outputDevice = outputDevice;
    }

    private byte[] readStream(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream out = new ByteArrayOutputStream(is.available());
        byte[] buf = new byte[10240];
        while ((i = is.read(buf)) != -1) {
            out.write(buf, 0, i);
        }
        out.close();
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource getImageResource(String uri) {
        ImageResource resource = null;
        if (ImageUtil.isEmbeddedBase64Image((String)uri)) {
            resource = this.loadEmbeddedBase64ImageResource(uri);
        } else {
            InputStream is;
            resource = (ImageResource)this._imageCache.get(uri = this.resolveURI(uri));
            if (resource == null && (is = this.resolveAndOpenStream(uri)) != null) {
                try {
                    URL url = new URL(uri);
                    if (url.getPath() != null && url.getPath().toLowerCase().endsWith(".pdf")) {
                        PdfReader reader = this._outputDevice.getReader(url);
                        PDFAsImage image = new PDFAsImage(url);
                        Rectangle rect = reader.getPageSizeWithRotation(1);
                        image.setInitialWidth(rect.getWidth() * this._outputDevice.getDotsPerPoint());
                        image.setInitialHeight(rect.getHeight() * this._outputDevice.getDotsPerPoint());
                        resource = new ImageResource(uri, (FSImage)image);
                    } else {
                        Image image = Image.getInstance((byte[])this.readStream(is));
                        this.scaleToOutputResolution(image);
                        resource = new ImageResource(uri, (FSImage)new ITextFSImage(image));
                    }
                    this._imageCache.put(uri, resource);
                }
                catch (Exception e) {
                    XRLog.exception((String)("Can't read image file; unexpected problem for URI '" + uri + "'"), (Throwable)e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            resource = resource != null ? new ImageResource(resource.getImageUri(), (FSImage)((ITextFSImage)resource.getImage()).clone()) : new ImageResource(uri, null);
        }
        return resource;
    }

    private ImageResource loadEmbeddedBase64ImageResource(String uri) {
        try {
            byte[] buffer = ImageUtil.getEmbeddedBase64Image((String)uri);
            Image image = Image.getInstance((byte[])buffer);
            this.scaleToOutputResolution(image);
            return new ImageResource(null, (FSImage)new ITextFSImage(image));
        }
        catch (Exception e) {
            XRLog.exception((String)"Can't read XHTML embedded image.", (Throwable)e);
            return new ImageResource(null, null);
        }
    }

    private void scaleToOutputResolution(Image image) {
        float factor = this._sharedContext.getDotsPerPixel();
        if (factor != 1.0f) {
            image.scaleAbsolute(image.getPlainWidth() * factor, image.getPlainHeight() * factor);
        }
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    public void setSharedContext(SharedContext sharedContext) {
        this._sharedContext = sharedContext;
    }
}

