/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.sheet.FontFaceRule;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.value.FontSpecification;
import org.xhtmlrenderer.extend.FontResolver;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.FontDescription;
import org.xhtmlrenderer.pdf.FontFamily;
import org.xhtmlrenderer.pdf.ITextFSFont;
import org.xhtmlrenderer.pdf.TrueTypeUtil;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.util.FontUtil;
import org.xhtmlrenderer.util.IOUtil;
import org.xhtmlrenderer.util.SupportedEmbeddedFontTypes;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRRuntimeException;

public class ITextFontResolver
implements FontResolver {
    private static final Logger log = LoggerFactory.getLogger(ITextFontResolver.class);
    private final Map<String, FontFamily> _fontFamilies = new HashMap<String, FontFamily>();
    private final Map<String, FontDescription> _fontCache = new ConcurrentHashMap<String, FontDescription>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, FontFamily> getFonts() {
        if (this._fontFamilies.isEmpty()) {
            Map<String, FontFamily> map = this._fontFamilies;
            synchronized (map) {
                if (this._fontFamilies.isEmpty()) {
                    this._fontFamilies.putAll(this.loadFonts());
                }
            }
        }
        return this._fontFamilies;
    }

    public static Set<String> getDistinctFontFamilyNames(String path, String encoding, boolean embedded) {
        try {
            BaseFont font = BaseFont.createFont((String)path, (String)encoding, (boolean)embedded);
            Collection<String> fontFamilyNames = TrueTypeUtil.getFamilyNames(font);
            return new HashSet<String>(fontFamilyNames);
        }
        catch (DocumentException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FSFont resolveFont(SharedContext renderingContext, FontSpecification spec) {
        return this.resolveFont(spec.families, spec.size, spec.fontWeight, spec.fontStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        Map<String, FontFamily> map = this._fontFamilies;
        synchronized (map) {
            this._fontFamilies.clear();
        }
        this._fontCache.clear();
    }

    public void flushFontFaceFonts() {
        this._fontCache.clear();
        Iterator<FontFamily> i = this.getFonts().values().iterator();
        while (i.hasNext()) {
            FontFamily family = i.next();
            family.getFontDescriptions().removeIf(FontDescription::isFromFontFace);
            if (!family.getFontDescriptions().isEmpty()) continue;
            i.remove();
        }
    }

    public void importFontFaces(List<FontFaceRule> fontFaces, UserAgentCallback userAgentCallback) {
        for (FontFaceRule rule : fontFaces) {
            CalculatedStyle style = rule.getCalculatedStyle();
            FSDerivedValue src = style.valueByName(CSSName.SRC);
            if (src == IdentValue.NONE) continue;
            byte[] font1 = userAgentCallback.getBinaryResource(src.asString());
            if (font1 == null) {
                XRLog.exception((String)("Could not load font " + src.asString()));
                continue;
            }
            byte[] font2 = null;
            FSDerivedValue metricsSrc = style.valueByName(CSSName.FS_FONT_METRIC_SRC);
            if (metricsSrc != IdentValue.NONE && (font2 = userAgentCallback.getBinaryResource(metricsSrc.asString())) == null) {
                XRLog.exception((String)("Could not load font metric data " + src.asString()));
                continue;
            }
            if (font2 != null) {
                byte[] t = font1;
                font1 = font2;
                font2 = t;
            }
            boolean embedded = style.isIdent(CSSName.FS_PDF_FONT_EMBED, IdentValue.EMBED);
            String encoding = style.getStringProperty(CSSName.FS_PDF_FONT_ENCODING);
            String fontFamily = null;
            IdentValue fontWeight = null;
            IdentValue fontStyle = null;
            if (rule.hasFontFamily()) {
                fontFamily = style.valueByName(CSSName.FONT_FAMILY).asString();
            }
            if (rule.hasFontWeight()) {
                fontWeight = style.getIdent(CSSName.FONT_WEIGHT);
            }
            if (rule.hasFontStyle()) {
                fontStyle = style.getIdent(CSSName.FONT_STYLE);
            }
            try {
                this.addFontFaceFont(fontFamily, fontWeight, fontStyle, src.asString(), encoding, embedded, font1, font2);
            }
            catch (DocumentException | IOException e) {
                XRLog.exception((String)("Could not load font " + src.asString()), (Throwable)e);
            }
        }
    }

    public void addFontDirectory(String dir, boolean embedded) throws DocumentException, IOException {
        File f = new File(dir);
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = Objects.requireNonNull(f.listFiles((dir1, name) -> {
                String lower = name.toLowerCase();
                return lower.endsWith(".otf") || lower.endsWith(".ttf");
            }))) {
                this.addFont(file.getAbsolutePath(), embedded);
            }
        }
    }

    public void addFont(String path, boolean embedded) throws DocumentException, IOException {
        this.addFont(path, "Cp1252", embedded);
    }

    public void addFont(String path, String encoding, boolean embedded) throws DocumentException, IOException {
        this.addFont(path, encoding, embedded, null);
    }

    public void addFont(String path, String encoding, boolean embedded, String pathToPFB) throws DocumentException, IOException {
        this.addFont(path, null, encoding, embedded, pathToPFB);
    }

    public void addFont(String path, String fontFamilyNameOverride, String encoding, boolean embedded, String pathToPFB) throws DocumentException, IOException {
        String lower = path.toLowerCase();
        if (lower.endsWith(".otf") || lower.endsWith(".ttf") || lower.contains(".ttc,")) {
            BaseFont font = BaseFont.createFont((String)path, (String)encoding, (boolean)embedded);
            Collection<String> fontFamilyNames = fontFamilyNameOverride != null ? Collections.singletonList(fontFamilyNameOverride) : TrueTypeUtil.getFamilyNames(font);
            for (String fontFamilyName : fontFamilyNames) {
                FontFamily fontFamily = this.getFontFamily(fontFamilyName);
                FontDescription description = new FontDescription(font);
                try {
                    TrueTypeUtil.populateDescription(path, font, description);
                }
                catch (DocumentException | IOException | IllegalAccessException | NoSuchFieldException e) {
                    throw new XRRuntimeException(e.getMessage(), e);
                }
                fontFamily.addFontDescription(description);
            }
        } else if (lower.endsWith(".ttc")) {
            String[] names = BaseFont.enumerateTTCNames((String)path);
            for (int i = 0; i < names.length; ++i) {
                this.addFont(path + "," + i, fontFamilyNameOverride, encoding, embedded, null);
            }
        } else if (lower.endsWith(".afm") || lower.endsWith(".pfm")) {
            if (embedded && pathToPFB == null) {
                throw new IOException("When embedding a font, path to PFB/PFA file must be specified");
            }
            BaseFont font = BaseFont.createFont((String)path, (String)encoding, (boolean)embedded, (boolean)false, null, (byte[])this.readFile(pathToPFB));
            String fontFamilyName = fontFamilyNameOverride != null ? fontFamilyNameOverride : font.getFamilyFontName()[0][3];
            FontFamily fontFamily = this.getFontFamily(fontFamilyName);
            FontDescription description = new FontDescription(font);
            fontFamily.addFontDescription(description);
        } else {
            throw new IOException("Unsupported font type");
        }
    }

    private boolean fontSupported(String uri) {
        String lower = uri.toLowerCase();
        if (FontUtil.isEmbeddedBase64Font((String)uri)) {
            return SupportedEmbeddedFontTypes.isSupported((String)uri);
        }
        return lower.endsWith(".otf") || lower.endsWith(".ttf") || lower.contains(".ttc,");
    }

    private void addFontFaceFont(String fontFamilyNameOverride, IdentValue fontWeightOverride, IdentValue fontStyleOverride, String uri, String encoding, boolean embedded, byte[] afmttf, byte[] pfb) throws DocumentException, IOException {
        String lower = uri.toLowerCase();
        if (this.fontSupported(lower)) {
            String fontName = FontUtil.isEmbeddedBase64Font((String)uri) ? fontFamilyNameOverride + SupportedEmbeddedFontTypes.getExtension((String)uri) : uri;
            BaseFont font = BaseFont.createFont((String)fontName, (String)encoding, (boolean)embedded, (boolean)false, (byte[])afmttf, (byte[])pfb);
            Collection<String> fontFamilyNames = fontFamilyNameOverride != null ? Collections.singletonList(fontFamilyNameOverride) : TrueTypeUtil.getFamilyNames(font);
            for (String fontFamilyName : fontFamilyNames) {
                FontFamily fontFamily = this.getFontFamily(fontFamilyName);
                FontDescription description = new FontDescription(font);
                try {
                    TrueTypeUtil.populateDescription(uri, afmttf, font, description);
                }
                catch (IOException | IllegalAccessException | NoSuchFieldException e) {
                    throw new XRRuntimeException(e.getMessage(), (Throwable)e);
                }
                description.setFromFontFace(true);
                if (fontWeightOverride != null) {
                    description.setWeight(ITextFontResolver.convertWeightToInt(fontWeightOverride));
                }
                if (fontStyleOverride != null) {
                    description.setStyle(fontStyleOverride);
                }
                fontFamily.addFontDescription(description);
            }
        } else if (lower.endsWith(".afm") || lower.endsWith(".pfm") || lower.endsWith(".pfb") || lower.endsWith(".pfa")) {
            if (embedded && pfb == null) {
                throw new IOException("When embedding a font, path to PFB/PFA file must be specified");
            }
            String name = uri.substring(0, uri.length() - 4) + ".afm";
            BaseFont font = BaseFont.createFont((String)name, (String)encoding, (boolean)embedded, (boolean)false, (byte[])afmttf, (byte[])pfb);
            String fontFamilyName = font.getFamilyFontName()[0][3];
            FontFamily fontFamily = this.getFontFamily(fontFamilyName);
            FontDescription description = new FontDescription(font);
            description.setFromFontFace(true);
            fontFamily.addFontDescription(description);
        } else {
            throw new IOException("Unsupported font type");
        }
    }

    private byte[] readFile(String path) throws IOException {
        return IOUtil.readBytes((Path)Paths.get(path, new String[0]));
    }

    private FontFamily getFontFamily(String fontFamilyName) {
        FontFamily fontFamily = this.getFonts().get(fontFamilyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily(fontFamilyName);
            this.getFonts().put(fontFamilyName, fontFamily);
        }
        return fontFamily;
    }

    private FSFont resolveFont(@Nullable String[] families, float size, IdentValue weight, IdentValue style) {
        if (style != IdentValue.NORMAL && style != IdentValue.OBLIQUE && style != IdentValue.ITALIC) {
            style = IdentValue.NORMAL;
        }
        if (families != null) {
            for (String family : families) {
                FSFont font = this.resolveFont(family, size, weight, style);
                if (font == null) continue;
                log.debug("Resolved font {}:{}:{} -> {}", new Object[]{family, weight, style, font});
                return font;
            }
        }
        log.debug("Could not resolve font {}:{}:{} - fallback to Serif", new Object[]{Arrays.toString(families), weight, style});
        return this.resolveFont("Serif", size, weight, style);
    }

    String normalizeFontFamily(String fontFamily) {
        String result = fontFamily;
        if (result.startsWith("\"")) {
            result = result.substring(1);
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.equalsIgnoreCase("serif")) {
            result = "Serif";
        } else if (result.equalsIgnoreCase("sans-serif")) {
            result = "SansSerif";
        } else if (result.equalsIgnoreCase("monospace")) {
            result = "Monospaced";
        }
        return result;
    }

    private FSFont resolveFont(String fontFamily, float size, IdentValue weight, IdentValue style) {
        String normalizedFontFamily = this.normalizeFontFamily(fontFamily);
        String cacheKey = String.format("%s-%s-%s", normalizedFontFamily, weight, style);
        FontDescription result = this._fontCache.get(cacheKey);
        if (result != null) {
            log.debug("Resolved font {}:{}:{} -> {}", new Object[]{fontFamily, weight, style, result});
            return new ITextFSFont(result, size);
        }
        FontFamily family = this.getFonts().get(normalizedFontFamily);
        if (family != null && (result = family.match(ITextFontResolver.convertWeightToInt(weight), style)) != null) {
            this._fontCache.put(cacheKey, result);
            return new ITextFSFont(result, size);
        }
        return null;
    }

    public static int convertWeightToInt(IdentValue weight) {
        if (weight == IdentValue.NORMAL) {
            return 400;
        }
        if (weight == IdentValue.BOLD) {
            return 700;
        }
        if (weight == IdentValue.FONT_WEIGHT_100) {
            return 100;
        }
        if (weight == IdentValue.FONT_WEIGHT_200) {
            return 200;
        }
        if (weight == IdentValue.FONT_WEIGHT_300) {
            return 300;
        }
        if (weight == IdentValue.FONT_WEIGHT_400) {
            return 400;
        }
        if (weight == IdentValue.FONT_WEIGHT_500) {
            return 500;
        }
        if (weight == IdentValue.FONT_WEIGHT_600) {
            return 600;
        }
        if (weight == IdentValue.FONT_WEIGHT_700) {
            return 700;
        }
        if (weight == IdentValue.FONT_WEIGHT_800) {
            return 800;
        }
        if (weight == IdentValue.FONT_WEIGHT_900) {
            return 900;
        }
        if (weight == IdentValue.LIGHTER) {
            return 400;
        }
        if (weight == IdentValue.BOLDER) {
            return 700;
        }
        throw new IllegalArgumentException("Cannot convert weight to integer: " + weight);
    }

    protected Map<String, FontFamily> loadFonts() {
        HashMap<String, FontFamily> result = new HashMap<String, FontFamily>();
        this.addCourier(result);
        this.addTimes(result);
        this.addHelvetica(result);
        this.addSymbol(result);
        this.addZapfDingbats(result);
        return result;
    }

    private BaseFont createFont(String name) {
        return this.createFont(name, "winansi", true);
    }

    private BaseFont createFont(String name, String encoding, boolean embedded) {
        try {
            return BaseFont.createFont((String)name, (String)encoding, (boolean)embedded);
        }
        catch (DocumentException | IOException e) {
            throw new RuntimeException("Failed to load font " + name + " and encoding " + encoding, e);
        }
    }

    private void addCourier(Map<String, FontFamily> result) {
        FontFamily courier = new FontFamily("Courier");
        courier.addFontDescription(new FontDescription(this.createFont("Courier-BoldOblique"), IdentValue.OBLIQUE, 700));
        courier.addFontDescription(new FontDescription(this.createFont("Courier-Oblique"), IdentValue.OBLIQUE, 400));
        courier.addFontDescription(new FontDescription(this.createFont("Courier-Bold"), IdentValue.NORMAL, 700));
        courier.addFontDescription(new FontDescription(this.createFont("Courier"), IdentValue.NORMAL, 400));
        result.put("DialogInput", courier);
        result.put("Monospaced", courier);
        result.put("Courier", courier);
    }

    private void addTimes(Map<String, FontFamily> result) {
        FontFamily times = new FontFamily("Times");
        times.addFontDescription(new FontDescription(this.createFont("Times-BoldItalic"), IdentValue.ITALIC, 700));
        times.addFontDescription(new FontDescription(this.createFont("Times-Italic"), IdentValue.ITALIC, 400));
        times.addFontDescription(new FontDescription(this.createFont("Times-Bold"), IdentValue.NORMAL, 700));
        times.addFontDescription(new FontDescription(this.createFont("Times-Roman"), IdentValue.NORMAL, 400));
        result.put("Serif", times);
        result.put("TimesRoman", times);
    }

    private void addHelvetica(Map<String, FontFamily> result) {
        FontFamily helvetica = new FontFamily("Helvetica");
        helvetica.addFontDescription(new FontDescription(this.createFont("Helvetica-BoldOblique"), IdentValue.OBLIQUE, 700));
        helvetica.addFontDescription(new FontDescription(this.createFont("Helvetica-Oblique"), IdentValue.OBLIQUE, 400));
        helvetica.addFontDescription(new FontDescription(this.createFont("Helvetica-Bold"), IdentValue.NORMAL, 700));
        helvetica.addFontDescription(new FontDescription(this.createFont("Helvetica"), IdentValue.NORMAL, 400));
        result.put("Dialog", helvetica);
        result.put("SansSerif", helvetica);
        result.put("Helvetica", helvetica);
    }

    private void addSymbol(Map<String, FontFamily> result) {
        FontFamily fontFamily = new FontFamily("Symbol");
        fontFamily.addFontDescription(new FontDescription(this.createFont("Symbol", "Cp1252", false), IdentValue.NORMAL, 400));
        result.put("Symbol", fontFamily);
    }

    private void addZapfDingbats(Map<String, FontFamily> result) {
        FontFamily fontFamily = new FontFamily("ZapfDingbats");
        fontFamily.addFontDescription(new FontDescription(this.createFont("ZapfDingbats", "Cp1252", false), IdentValue.NORMAL, 400));
        result.put("ZapfDingbats", fontFamily);
    }
}

