/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.util;

import java.io.File;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.environment.Environment;

public abstract class AbstractCacheConfigurationLoader {
    private static final String CONFX_CACHE_PATH = "cache.path";
    private CacheConfiguration configuration;
    private Environment environment;
    private String defaultPropsId;

    public AbstractCacheConfigurationLoader(CacheConfiguration configuration, String defaultPropsId) {
        this(configuration, null, defaultPropsId);
    }

    public AbstractCacheConfigurationLoader(CacheConfiguration configuration, Environment environment, String defaultPropsId) {
        this.configuration = (CacheConfiguration)configuration.clone();
        this.environment = environment;
        this.defaultPropsId = defaultPropsId;
    }

    public CacheConfiguration getCacheConfiguration() {
        return this.configuration;
    }

    protected String createTempDir() {
        String path = (String)this.configuration.get(CONFX_CACHE_PATH);
        if (path == null) {
            File file = this.environment != null ? new File(this.environment.getTemporaryDirectory().getAbsolutePath(), "cache") : new File(System.getProperty("java.io.tmpdir"), "xwiki");
            if (this.configuration.getConfigurationId() == null) {
                file = new File(file, this.configuration.getConfigurationId());
            }
            if (!file.exists()) {
                file.mkdirs();
            }
            path = file.getAbsolutePath();
        }
        return path;
    }

    public String getDefaultPropsId() {
        return this.defaultPropsId;
    }
}

