/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.classloader.internal.protocol.jar;

import edu.emory.mathcs.util.classloader.ResourceUtils;
import edu.emory.mathcs.util.io.RedirectingInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.xwiki.classloader.internal.protocol.jar.JarURLConnection;

public class JarProxy
implements JarURLConnection.JarOpener {
    private final Map<URL, CachedJarFile> cache = new HashMap<URL, CachedJarFile>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JarFile openJarFile(JarURLConnection conn) throws IOException {
        CachedJarFile result;
        URL url = conn.getJarFileURL();
        Map<URL, CachedJarFile> map = this.cache;
        synchronized (map) {
            result = this.cache.get(url);
        }
        if (result != null) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(result.perm);
            }
            return result;
        }
        try {
            URI uri = new URI(url.toString());
            if (ResourceUtils.isLocalFile((URI)uri)) {
                File file = new File(uri);
                FilePermission perm = new FilePermission(file.getAbsolutePath(), "read");
                result = new CachedJarFile(file, perm, false);
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (result == null) {
            final URLConnection jarconn = url.openConnection();
            jarconn.setAllowUserInteraction(conn.getAllowUserInteraction());
            jarconn.setDoInput(conn.getDoInput());
            jarconn.setDoOutput(conn.getDoOutput());
            jarconn.setIfModifiedSince(conn.getIfModifiedSince());
            Map<String, List<String>> map2 = conn.getRequestProperties();
            for (Map.Entry<String, List<String>> entry : map2.entrySet()) {
                StringBuilder value = new StringBuilder();
                for (String str : entry.getValue()) {
                    value.append(',').append(str);
                }
                if (value.length() < 1) continue;
                jarconn.setRequestProperty(entry.getKey(), value.substring(1));
            }
            jarconn.setUseCaches(conn.getUseCaches());
            try (final InputStream in = this.getJarInputStream(jarconn);){
                result = AccessController.doPrivileged(new PrivilegedExceptionAction<CachedJarFile>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public CachedJarFile run() throws IOException {
                        File file = File.createTempFile("jar_cache", "");
                        try (FileOutputStream out = new FileOutputStream(file);){
                            RedirectingInputStream r = new RedirectingInputStream(in, false, false);
                            int len = r.redirectAll((OutputStream)out);
                            out.flush();
                            if (len == 0) {
                                CachedJarFile cachedJarFile = null;
                                return cachedJarFile;
                            }
                        }
                        return new CachedJarFile(file, jarconn.getPermission(), true);
                    }
                });
            }
        }
        if (result == null) {
            return null;
        }
        map = this.cache;
        synchronized (map) {
            CachedJarFile asyncResult = this.cache.get(url);
            if (asyncResult != null) {
                result.closeCachedFile();
                return asyncResult;
            }
            this.cache.put(url, result);
            return result;
        }
    }

    protected InputStream getJarInputStream(URLConnection conn) throws IOException {
        return conn.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        HashMap<URL, CachedJarFile> cache;
        Map<URL, CachedJarFile> map = this.cache;
        synchronized (map) {
            cache = new HashMap<URL, CachedJarFile>(this.cache);
            this.cache.clear();
        }
        for (CachedJarFile jfile : cache.values()) {
            try {
                jfile.closeCachedFile();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }

    private static class CachedJarFile
    extends JarFile {
        final Permission perm;

        CachedJarFile(File file, Permission perm, boolean tmp) throws IOException {
            super(file, true, 1 | (tmp ? 4 : 0));
            this.perm = perm;
        }

        @Override
        public Manifest getManifest() throws IOException {
            Manifest orig = super.getManifest();
            if (orig == null) {
                return null;
            }
            Manifest man = new Manifest();
            man.getMainAttributes().putAll((Map<?, ?>)orig.getMainAttributes());
            for (Map.Entry<String, Attributes> entry : orig.getEntries().entrySet()) {
                man.getEntries().put(entry.getKey(), new Attributes(entry.getValue()));
            }
            return man;
        }

        @Override
        public ZipEntry getEntry(String name) {
            return super.getEntry(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws IOException {
            try {
                this.closeCachedFile();
            }
            finally {
                super.finalize();
            }
        }

        protected void closeCachedFile() throws IOException {
            super.close();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

