/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.classloader.internal.protocol.jar;

import edu.emory.mathcs.util.classloader.ResourceUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.classloader.ExtendedURLStreamHandler;
import org.xwiki.classloader.internal.protocol.jar.JarProxy;
import org.xwiki.classloader.internal.protocol.jar.JarURLConnection;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="jar")
@Singleton
public class JarURLStreamHandler
extends URLStreamHandler
implements ExtendedURLStreamHandler {
    private static final Pattern ABSOLUTE_JAR_URL_PATTERN = Pattern.compile("jar:(.*)!(/(?:.*/)?)((?:[^/#]+)?)((?:#.*)?)");
    private static final String JAR_PROTOCOL = "jar";
    private static final String JAR_PROTOCOL_SEPARATOR = "!";
    private JarURLConnection.JarOpener opener = new JarProxy();
    @Inject
    private URLStreamHandlerFactory handlerFactory;

    public String getProtocol() {
        return JAR_PROTOCOL;
    }

    @Override
    public URLConnection openConnection(URL url) throws IOException {
        return new JarURLConnection(url, this.opener, this.handlerFactory);
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        Matcher matcher = ABSOLUTE_JAR_URL_PATTERN.matcher(spec);
        if (matcher.matches()) {
            String base = matcher.group(1);
            try {
                new URL(base);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e.toString());
            }
            String path = matcher.group(2) + matcher.group(3);
            path = ResourceUtils.canonizePath((String)path);
            String ref = matcher.group(4);
            ref = ref.length() == 0 ? null : ref.substring(1);
            this.setURL(u, JAR_PROTOCOL, "", -1, "", "", base + JAR_PROTOCOL_SEPARATOR + path, null, ref);
        } else {
            matcher = ABSOLUTE_JAR_URL_PATTERN.matcher(u.toString());
            if (matcher.matches()) {
                String path;
                String ref = spec.substring(limit);
                ref = ref.length() == 0 ? null : ref.substring(1);
                String newSpec = spec.substring(start, limit);
                String base = matcher.group(1);
                if (newSpec.length() > 0 && newSpec.charAt(0) == '/') {
                    path = newSpec;
                } else {
                    String cxtDir = matcher.group(2);
                    path = cxtDir + newSpec;
                }
                path = ResourceUtils.canonizePath((String)path);
                this.setURL(u, JAR_PROTOCOL, "", -1, "", "", base + JAR_PROTOCOL_SEPARATOR + path, null, ref);
            } else {
                throw new IllegalArgumentException("Neither URL nor the spec are valid JAR URLs");
            }
        }
    }
}

